/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_0_0;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMFieldsCounter;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeDynamicDataMapping
extends UpgradeProcess {
    private static final String _CLASS_NAME_DDM_STRUCTURE = "com.liferay.dynamic.data.mapping.model.DDMStructure";
    private static final String _CLASS_NAME_DDM_TEMPLATE = "com.liferay.dynamic.data.mapping.model.DDMTemplate";
    private static final String[] _DLFOLDER_GROUP_PERMISSIONS = new String[]{"ADD_DOCUMENT", "ADD_SHORTCUT", "ADD_SUBFOLDER", "SUBSCRIBE", "VIEW"};
    private static final String[] _DLFOLDER_GUEST_PERMISSIONS = new String[]{"VIEW"};
    private static final String[] _DLFOLDER_OWNER_PERMISSIONS = new String[]{"ACCESS", "ADD_DOCUMENT", "ADD_SHORTCUT", "ADD_SUBFOLDER", "DELETE", "PERMISSIONS", "SUBSCRIBE", "UPDATE", "VIEW"};
    private static final String _INVALID_FIELD_NAME_CHARS_REGEX = "([\\p{Punct}&&[^_]]|\\p{Space})+";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDynamicDataMapping.class);
    private static final Pattern _invalidFieldNameCharsPattern = Pattern.compile("([\\p{Punct}&&[^_]]|\\p{Space})+");
    private final AssetEntryLocalService _assetEntryLocalService;
    private final DDM _ddm;
    private long _ddmContentClassNameId;
    private final DDMFormDeserializer _ddmFormJSONDeserializer;
    private final DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    private final Map<Long, DDMForm> _ddmForms = new HashMap<Long, DDMForm>();
    private final DDMFormSerializer _ddmFormSerializer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private final DDMFormValuesSerializer _ddmFormValuesSerializer;
    private final DDMFormDeserializer _ddmFormXSDDeserializer;
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final DLFileVersionLocalService _dlFileVersionLocalService;
    private final DLFolderLocalService _dlFolderLocalService;
    private final ModelPermissions _dlFolderModelPermissions;
    private final ExpandoRowLocalService _expandoRowLocalService;
    private long _expandoStorageAdapterClassNameId;
    private final ExpandoTableLocalService _expandoTableLocalService;
    private final ExpandoValueLocalService _expandoValueLocalService;
    private final Map<Long, DDMForm> _fullHierarchyDDMForms = new HashMap<Long, DDMForm>();
    private final ResourceLocalService _resourceLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final Store _store;
    private final Map<Long, Long> _structureClassNameIds = new HashMap<Long, Long>();
    private final Map<Long, Map<String, String>> _structureInvalidDDMFormFieldNamesMap = new HashMap<Long, Map<String, String>>();
    private final Map<String, String> _structureModelResourceNames = new HashMap<String, String>();
    private final Map<String, String> _templateModelResourceNames = new HashMap<String, String>();
    private final Map<Long, Long> _templateResourceClassNameIds = new HashMap<Long, Long>();

    public UpgradeDynamicDataMapping(AssetEntryLocalService assetEntryLocalService, DDM ddm, DDMFormDeserializer ddmFormJSONDeserializer, DDMFormDeserializer ddmFormXSDDeserializer, DDMFormLayoutSerializer ddmFormLayoutSerializer, DDMFormSerializer ddmFormSerializer, DDMFormValuesDeserializer ddmFormValuesDeserializer, DDMFormValuesSerializer ddmFormValuesSerializer, DLFileEntryLocalService dlFileEntryLocalService, DLFileVersionLocalService dlFileVersionLocalService, DLFolderLocalService dlFolderLocalService, ExpandoRowLocalService expandoRowLocalService, ExpandoTableLocalService expandoTableLocalService, ExpandoValueLocalService expandoValueLocalService, ResourceActions resourceActions, ResourceLocalService resourceLocalService, ResourcePermissionLocalService resourcePermissionLocalService, Store store) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._ddm = ddm;
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
        this._ddmFormXSDDeserializer = ddmFormXSDDeserializer;
        this._ddmFormLayoutSerializer = ddmFormLayoutSerializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._ddmFormValuesSerializer = ddmFormValuesSerializer;
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._dlFileVersionLocalService = dlFileVersionLocalService;
        this._dlFolderLocalService = dlFolderLocalService;
        this._expandoRowLocalService = expandoRowLocalService;
        this._expandoTableLocalService = expandoTableLocalService;
        this._expandoValueLocalService = expandoValueLocalService;
        this._resourceLocalService = resourceLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._store = store;
        this._dlFolderModelPermissions = ModelPermissionsFactory.create((String[])_DLFOLDER_GROUP_PERMISSIONS, (String[])_DLFOLDER_GUEST_PERMISSIONS);
        this._dlFolderModelPermissions.addRolePermissions("Owner", _DLFOLDER_OWNER_PERMISSIONS);
        this._initModelResourceNames(resourceActions);
    }

    protected void addDynamicContentElements(Element dynamicElementElement, String name, String data) {
        Map localizationMap = LocalizationUtil.getLocalizationMap((String)data);
        for (Map.Entry entry : localizationMap.entrySet()) {
            String[] values = StringUtil.split((String)((String)entry.getValue()));
            if (name.startsWith("_")) {
                values = new String[]{(String)entry.getValue()};
            }
            for (String value : values) {
                Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
                dynamicContentElement.addAttribute("language-id", LanguageUtil.getLanguageId((Locale)((Locale)entry.getKey())));
                dynamicContentElement.addCDATA(value.trim());
            }
        }
    }

    protected String createNewDDMFormFieldName(String fieldName, Set<String> existingFieldNames) throws Exception {
        String newFieldName = fieldName.replaceAll(_INVALID_FIELD_NAME_CHARS_REGEX, "");
        if (Validator.isNotNull((String)newFieldName)) {
            String updatedFieldName = newFieldName;
            int i = 1;
            while (existingFieldNames.contains(updatedFieldName)) {
                updatedFieldName = newFieldName + i;
                ++i;
            }
            return updatedFieldName;
        }
        throw new UpgradeException(String.format("Unable to automatically update field name \"%s\" because it only contains invalid characters", fieldName, newFieldName));
    }

    protected void deleteExpandoData(Set<Long> expandoRowIds) throws PortalException {
        HashSet<Long> expandoTableIds = new HashSet<Long>();
        for (long expandoRowId : expandoRowIds) {
            ExpandoRow expandoRow = this._expandoRowLocalService.fetchExpandoRow(expandoRowId);
            if (expandoRow == null) continue;
            expandoTableIds.add(expandoRow.getTableId());
        }
        for (long expandoTableId : expandoTableIds) {
            try {
                this._expandoTableLocalService.deleteTable(expandoTableId);
            }
            catch (PortalException portalException) {
                _log.error((Object)"Unable delete expando table", (Throwable)portalException);
                throw portalException;
            }
        }
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._ddmFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected DDMForm deserialize(String content, String type) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializer ddmFormDeserializer = null;
        if (StringUtil.equalsIgnoreCase((String)type, (String)"json")) {
            ddmFormDeserializer = this._ddmFormJSONDeserializer;
        } else if (StringUtil.equalsIgnoreCase((String)type, (String)"xsd")) {
            ddmFormDeserializer = this._ddmFormXSDDeserializer;
        }
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    protected void doUpgrade() throws Exception {
        this.setUpClassNameIds();
        this.upgradeExpandoStorageAdapter();
        this.upgradeStructuresAndAddStructureVersionsAndLayouts();
        this.upgradeTemplatesAndAddTemplateVersions();
        this.upgradeXMLStorageAdapter();
        this.upgradeFieldTypeReferences();
        this.upgradeStructuresPermissions();
        this.upgradeTemplatesPermissions();
    }

    protected List<String> getDDMDateFieldNames(DDMForm ddmForm) throws Exception {
        ArrayList<String> ddmDateFieldNames = new ArrayList<String>();
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            String dataType = ddmFormField.getType();
            if (!dataType.equals("ddm-date")) continue;
            ddmDateFieldNames.add(ddmFormField.getName());
        }
        return ddmDateFieldNames;
    }

    /*
     * Loose catch block
     */
    protected DDMForm getDDMForm(long structureId) throws Exception {
        DDMForm ddmForm = this._ddmForms.get(structureId);
        if (ddmForm != null) {
            return ddmForm;
        }
        Throwable throwable = null;
        try (PreparedStatement ps = this.connection.prepareStatement("select parentStructureId, definition, storageType from DDMStructure where structureId = ?");){
            Throwable throwable2;
            ResultSet rs;
            block33: {
                DDMForm dDMForm;
                block34: {
                    block35: {
                        DDMForm parentDDMForm;
                        Set commonDDMFormFieldNames;
                        ps.setLong(1, structureId);
                        rs = ps.executeQuery();
                        throwable2 = null;
                        if (!rs.next()) break block33;
                        String definition = rs.getString("definition");
                        String storageType = rs.getString("storageType");
                        ddmForm = storageType.equals("expando") || storageType.equals("xml") ? this.deserialize(definition, "xsd") : this.deserialize(definition, "json");
                        try {
                            this.validateDDMFormFieldNames(ddmForm);
                        }
                        catch (DDMFormValidationException.MustNotDuplicateFieldName mndfn) {
                            throw new UpgradeException(String.format("The field name '%s' from structure ID %d is defined more than once", mndfn.getFieldName(), structureId));
                        }
                        long parentStructureId = rs.getLong("parentStructureId");
                        if (parentStructureId > 0L && !(commonDDMFormFieldNames = SetUtil.intersect(this.getDDMFormFieldsNames(parentDDMForm = this.getDDMForm(parentStructureId)), this.getDDMFormFieldsNames(ddmForm))).isEmpty()) {
                            throw new UpgradeException("Duplicate DDM form field names: " + StringUtil.merge((Collection)commonDDMFormFieldNames));
                        }
                        this._ddmForms.put(structureId, ddmForm);
                        dDMForm = ddmForm;
                        if (rs == null) break block34;
                        if (throwable2 == null) break block35;
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block34;
                    }
                    rs.close();
                }
                return dDMForm;
            }
            try {
                block36: {
                    if (rs != null) {
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            rs.close();
                        }
                    }
                    break block36;
                    catch (Throwable throwable5) {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (rs != null) {
                                if (throwable2 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                            throw throwable6;
                        }
                    }
                }
                throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
    }

    protected Set<String> getDDMFormFieldsNames(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        HashSet<String> ddmFormFieldsNames = new HashSet<String>();
        for (String ddmFormFieldName : ddmFormFieldsMap.keySet()) {
            ddmFormFieldsNames.add(StringUtil.toLowerCase((String)ddmFormFieldName));
        }
        return ddmFormFieldsNames;
    }

    protected DDMFormValues getDDMFormValues(long companyId, DDMForm ddmForm, String xml) throws Exception {
        DDMFormValuesXSDDeserializer ddmFormValuesXSDDeserializer = new DDMFormValuesXSDDeserializer(companyId);
        return ddmFormValuesXSDDeserializer.deserialize(ddmForm, xml);
    }

    /*
     * Exception decompiling
     */
    protected Map<String, String> getDDMTemplateScriptMap(long structureId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getDefaultDDMFormLayoutDefinition(DDMForm ddmForm) {
        DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
        DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(builder.build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    protected Map<String, String> getExpandoValuesMap(long expandoRowId) throws PortalException {
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        List expandoValues = this._expandoValueLocalService.getRowValues(expandoRowId);
        for (ExpandoValue expandoValue : expandoValues) {
            ExpandoColumn expandoColumn = expandoValue.getColumn();
            fieldsMap.put(expandoColumn.getName(), expandoValue.getData());
        }
        return fieldsMap;
    }

    /*
     * Loose catch block
     */
    protected DDMForm getFullHierarchyDDMForm(long structureId) throws Exception {
        DDMForm fullHierarchyDDMForm = this._fullHierarchyDDMForms.get(structureId);
        if (fullHierarchyDDMForm != null) {
            return fullHierarchyDDMForm;
        }
        Throwable throwable = null;
        try (PreparedStatement ps = this.connection.prepareStatement("select parentStructureId from DDMStructure where structureId = ?");){
            Throwable throwable2;
            ResultSet rs;
            block31: {
                DDMForm dDMForm;
                block32: {
                    block33: {
                        ps.setLong(1, structureId);
                        rs = ps.executeQuery();
                        throwable2 = null;
                        if (!rs.next()) break block31;
                        long parentStructureId = rs.getLong("parentStructureId");
                        fullHierarchyDDMForm = this.getDDMForm(structureId);
                        if (parentStructureId > 0L) {
                            DDMForm parentDDMForm = this.getFullHierarchyDDMForm(parentStructureId);
                            List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
                            ddmFormFields.addAll(parentDDMForm.getDDMFormFields());
                        }
                        this._fullHierarchyDDMForms.put(structureId, fullHierarchyDDMForm);
                        dDMForm = fullHierarchyDDMForm;
                        if (rs == null) break block32;
                        if (throwable2 == null) break block33;
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block32;
                    }
                    rs.close();
                }
                return dDMForm;
            }
            try {
                block34: {
                    if (rs != null) {
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            rs.close();
                        }
                    }
                    break block34;
                    catch (Throwable throwable5) {
                        try {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            if (rs != null) {
                                if (throwable2 != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                } else {
                                    rs.close();
                                }
                            }
                            throw throwable6;
                        }
                    }
                }
                throw new UpgradeException("Unable to find dynamic data mapping structure with ID " + structureId);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
    }

    protected String getStructureModelResourceName(long classNameId) throws UpgradeException {
        String className = PortalUtil.getClassName((long)classNameId);
        String structureModelResourceName = this._structureModelResourceNames.get(className);
        if (structureModelResourceName == null) {
            throw new UpgradeException(StringBundler.concat((String[])new String[]{"Model ", className, " does not support DDM structure ", "permission checking"}));
        }
        return structureModelResourceName;
    }

    protected String getTemplateModelResourceName(long classNameId) throws UpgradeException {
        String className = PortalUtil.getClassName((long)classNameId);
        String templateModelResourceName = this._templateModelResourceNames.get(className);
        if (templateModelResourceName == null) {
            throw new UpgradeException(StringBundler.concat((String[])new String[]{"Model ", className, " does not support DDM template ", "permission checking"}));
        }
        return templateModelResourceName;
    }

    protected Long getTemplateResourceClassNameId(long classNameId, long classPK) {
        if (classNameId != PortalUtil.getClassNameId(DDMStructure.class)) {
            return PortalUtil.getClassNameId((String)"com.liferay.portlet.display.template.PortletDisplayTemplate");
        }
        if (classPK == 0L) {
            return PortalUtil.getClassNameId((String)"com.liferay.portlet.journal.model.JournalArticle");
        }
        return this._structureClassNameIds.get(classPK);
    }

    /*
     * Exception decompiling
     */
    protected boolean hasStructureVersion(long structureId, String version) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean hasTemplateVersion(long templateId, String version) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isInvalidFieldName(String fieldName) {
        Matcher matcher = _invalidFieldNameCharsPattern.matcher(fieldName);
        return matcher.find();
    }

    protected void populateStructureInvalidDDMFormFieldNamesMap(long structureId, DDMForm ddmForm) {
        HashMap<String, String> ddmFormFieldNamesMap = new HashMap<String, String>();
        Map ddmFormFieldMap = ddmForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldMap.values()) {
            String oldName = (String)ddmFormField.getProperty("oldName");
            if (oldName == null) continue;
            ddmFormFieldNamesMap.put(oldName, ddmFormField.getName());
        }
        this._structureInvalidDDMFormFieldNamesMap.put(structureId, ddmFormFieldNamesMap);
    }

    protected String renameInvalidDDMFormFieldNames(long structureId, String string) {
        Map<String, String> ddmFormFieldNamesMap = this._structureInvalidDDMFormFieldNamesMap.get(structureId);
        if (ddmFormFieldNamesMap == null || ddmFormFieldNamesMap.isEmpty()) {
            return string;
        }
        Set<String> oldFieldNames = ddmFormFieldNamesMap.keySet();
        String[] oldSub = oldFieldNames.toArray(new String[0]);
        String[] newSub = new String[oldFieldNames.size()];
        for (int i = 0; i < oldSub.length; ++i) {
            newSub[i] = ddmFormFieldNamesMap.get(oldSub[i]);
        }
        return StringUtil.replace((String)string, (String[])oldSub, (String[])newSub);
    }

    protected void setUpClassNameIds() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this._ddmContentClassNameId = PortalUtil.getClassNameId(DDMContent.class);
            this._expandoStorageAdapterClassNameId = PortalUtil.getClassNameId((String)"com.liferay.portlet.dynamicdatamapping.storage.ExpandoStorageAdapter");
        }
    }

    protected String toJSON(DDMForm ddmForm) {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    protected String toJSON(DDMFormValues ddmFormValues) {
        DDMFormValuesSerializerSerializeRequest.Builder builder = DDMFormValuesSerializerSerializeRequest.Builder.newBuilder((DDMFormValues)ddmFormValues);
        DDMFormValuesSerializerSerializeResponse ddmFormValuesSerializerSerializeResponse = this._ddmFormValuesSerializer.serialize(builder.build());
        return ddmFormValuesSerializerSerializeResponse.getContent();
    }

    protected String toXML(Map<String, String> expandoValuesMap) {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        for (Map.Entry<String, String> entry : expandoValuesMap.entrySet()) {
            Element dynamicElementElement = rootElement.addElement("dynamic-element");
            String name = entry.getKey();
            String data = entry.getValue();
            dynamicElementElement.addAttribute("name", name);
            dynamicElementElement.addAttribute("default-language-id", LocalizationUtil.getDefaultLanguageId((String)data));
            this.addDynamicContentElements(dynamicElementElement, name, data);
        }
        return document.asXML();
    }

    protected void transformFieldTypeDDMFormFields(long groupId, long companyId, long userId, String userName, Timestamp createDate, long entryId, String entryVersion, String entryModelName, DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new FileUploadDDMFormFieldValueTransformer(groupId, companyId, userId, userName, createDate, entryId, entryVersion, entryModelName));
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new DateDDMFormFieldValueTransformer());
        ddmFormValuesTransformer.transform();
    }

    protected DDMForm updateDDMFormFields(DDMForm ddmForm) throws Exception {
        DDMForm copyDDMForm = new DDMForm(ddmForm);
        Map ddmFormFieldsMap = copyDDMForm.getDDMFormFieldsMap(true);
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String dataType;
            String fieldName = ddmFormField.getName();
            if (this.isInvalidFieldName(fieldName)) {
                String newFieldName = this.createNewDDMFormFieldName(fieldName, ddmFormFieldsMap.keySet());
                ddmFormField.setName(newFieldName);
                ddmFormField.setProperty("oldName", (Object)fieldName);
            }
            if (Objects.equals(dataType = ddmFormField.getDataType(), "file-upload")) {
                ddmFormField.setDataType("document-library");
                ddmFormField.setType("ddm-documentlibrary");
                continue;
            }
            if (!Objects.equals(dataType, "image")) continue;
            ddmFormField.setFieldNamespace("ddm");
            ddmFormField.setType("ddm-image");
        }
        return copyDDMForm;
    }

    protected void updateDDMStructureStorageType() throws Exception {
        this.runSQL("update DDMStructure set storageType = 'xml' where storageType = 'expando'");
    }

    protected void updateStructureStorageType() throws Exception {
        this.runSQL("update DDMStructure set storageType='json' where storageType = 'xml'");
    }

    protected void updateStructureVersionStorageType() throws Exception {
        this.runSQL("update DDMStructureVersion set storageType='json' where storageType = 'xml'");
    }

    protected void updateTemplateScript(long templateId, String script) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update DDMTemplate set script = ? where templateId = ?");){
            ps.setString(1, script);
            ps.setLong(2, templateId);
            ps.executeUpdate();
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to update dynamic data mapping template with template ID " + templateId));
            throw exception;
        }
    }

    protected String updateTemplateScriptDateAssignStatement(String dateFieldName, String language, String script) {
        StringBundler oldTemplateScriptSB = new StringBundler(7);
        StringBundler newTemplateScriptSB = new StringBundler(5);
        if (language.equals("ftl")) {
            oldTemplateScriptSB.append("<#assign\\s+");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*=\\s*getterUtil\\s*.");
            oldTemplateScriptSB.append("\\s*getLong\\s*\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append(".\\s*getData\\s*\\(\\s*\\)");
            oldTemplateScriptSB.append("\\s*\\)\\s*/?>");
            newTemplateScriptSB.append("<#assign ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data = getterUtil.getString(");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append(".getData()) />");
        } else if (language.equals("vm")) {
            dateFieldName = "\\$" + dateFieldName;
            oldTemplateScriptSB.append("#set\\s+\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*=\\s*\\$getterUtil.");
            oldTemplateScriptSB.append("getLong\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append(".getData\\(\\)\\s*\\)\\s*\\)");
            newTemplateScriptSB.append("#set (");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data = \\$getterUtil.getString(");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append(".getData()))");
        }
        return script.replaceAll(oldTemplateScriptSB.toString(), newTemplateScriptSB.toString());
    }

    protected void updateTemplateScriptDateFields(long structureId, DDMForm ddmForm) throws Exception {
        List<String> ddmDateFieldNames = this.getDDMDateFieldNames(ddmForm);
        if (ddmDateFieldNames.isEmpty()) {
            return;
        }
        Map<String, String> ddmTemplateScriptMap = this.getDDMTemplateScriptMap(structureId);
        for (Map.Entry<String, String> entrySet : ddmTemplateScriptMap.entrySet()) {
            String[] templateIdAndLanguage = StringUtil.split((String)entrySet.getKey(), (String)"$");
            long ddmTemplateId = GetterUtil.getLong((String)templateIdAndLanguage[0]);
            String language = templateIdAndLanguage[1];
            String script = entrySet.getValue();
            for (String ddmDateFieldName : ddmDateFieldNames) {
                script = this.updateTemplateScriptDateAssignStatement(ddmDateFieldName, language, script);
                script = this.updateTemplateScriptDateIfStatement(ddmDateFieldName, language, script);
                script = this.updateTemplateScriptDateParseStatement(ddmDateFieldName, language, script);
                script = this.updateTemplateScriptDateGetDateStatement(language, script);
            }
            this.updateTemplateScript(ddmTemplateId, script);
        }
    }

    protected String updateTemplateScriptDateGetDateStatement(String language, String script) {
        StringBundler oldTemplateScriptSB = new StringBundler(3);
        String newTemplateScript = null;
        if (language.equals("ftl")) {
            oldTemplateScriptSB.append("dateUtil.getDate\\((.*)");
            oldTemplateScriptSB.append("locale[,\\s]*timeZoneUtil.");
            oldTemplateScriptSB.append("getTimeZone\\(\"UTC\"\\)\\s*\\)");
            newTemplateScript = "dateUtil.getDate($1locale)";
        } else if (language.equals("vm")) {
            oldTemplateScriptSB.append("dateUtil.getDate\\((.*)");
            oldTemplateScriptSB.append("\\$locale[,\\s]*\\$timeZoneUtil.");
            oldTemplateScriptSB.append("getTimeZone\\(\"UTC\"\\)\\s*\\)");
            newTemplateScript = "dateUtil.getDate($1\\$locale)";
        }
        return script.replaceAll(oldTemplateScriptSB.toString(), newTemplateScript);
    }

    protected String updateTemplateScriptDateIfStatement(String dateFieldName, String language, String script) {
        String oldTemplateScript = "";
        String newTemplateScript = "";
        if (language.equals("ftl")) {
            oldTemplateScript = StringBundler.concat((String[])new String[]{"<#if\\s*\\(?\\s*", dateFieldName, "_Data\\s*>\\s*0\\s*\\)?", "\\s*>"});
            newTemplateScript = "<#if validator.isNotNull(" + dateFieldName + "_Data)>";
        } else if (language.equals("vm")) {
            dateFieldName = "\\$" + dateFieldName;
            oldTemplateScript = "#if\\s*\\(\\s*" + dateFieldName + "_Data\\s*>\\s*0\\s*\\)";
            newTemplateScript = "#if (\\$validator.isNotNull(" + dateFieldName + "_Data))";
        }
        return script.replaceAll(oldTemplateScript, newTemplateScript);
    }

    protected String updateTemplateScriptDateParseStatement(String dateFieldName, String language, String script) {
        StringBundler oldTemplateScriptSB = new StringBundler(6);
        StringBundler newTemplateScriptSB = new StringBundler(5);
        if (language.equals("ftl")) {
            oldTemplateScriptSB.append("<#assign\\s+");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_DateObj\\s*=\\s*dateUtil\\s*.");
            oldTemplateScriptSB.append("\\s*newDate\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*\\)\\s*/?>");
            newTemplateScriptSB.append("<#assign ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_DateObj = dateUtil.parseDate(\"yyyy-MM-dd\", ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data, locale) />");
        } else if (language.equals("vm")) {
            dateFieldName = "\\$" + dateFieldName;
            oldTemplateScriptSB.append("#set\\s*\\(");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_DateObj\\s*=\\s*\\$dateUtil.");
            oldTemplateScriptSB.append("newDate\\(\\s*");
            oldTemplateScriptSB.append(dateFieldName);
            oldTemplateScriptSB.append("_Data\\s*\\)\\s*\\)");
            newTemplateScriptSB.append("#set (");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_DateObj = \\$dateUtil.parseDate(\"yyyy-MM-dd\", ");
            newTemplateScriptSB.append(dateFieldName);
            newTemplateScriptSB.append("_Data, \\$locale))");
        }
        return script.replaceAll(oldTemplateScriptSB.toString(), newTemplateScriptSB.toString());
    }

    protected void upgradeDDLFieldTypeReferences() throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append("select DDLRecordVersion.*, DDMContent.data_, ");
        sb.append("DDMStructure.structureId from DDLRecordVersion inner join ");
        sb.append("DDLRecordSet on DDLRecordVersion.recordSetId = ");
        sb.append("DDLRecordSet.recordSetId inner join DDMContent on  ");
        sb.append("DDLRecordVersion.DDMStorageId = DDMContent.contentId ");
        sb.append("inner join DDMStructure on DDLRecordSet.DDMStructureId = ");
        sb.append("DDMStructure.structureId");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_= ? where contentId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                long entryId = rs.getLong("recordId");
                String entryVersion = rs.getString("version");
                long contentId = rs.getLong("ddmStorageId");
                String data_ = rs.getString("data_");
                long ddmStructureId = rs.getLong("structureId");
                DDMForm ddmForm = this.getFullHierarchyDDMForm(ddmStructureId);
                DDMFormValues ddmFormValues = this.deserialize(data_, ddmForm);
                this.transformFieldTypeDDMFormFields(groupId, companyId, userId, userName, createDate, entryId, entryVersion, "DDLRecord", ddmFormValues);
                ps2.setString(1, this.toJSON(ddmFormValues));
                ps2.setLong(2, contentId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void upgradeDLFieldTypeReferences() throws Exception {
        StringBundler sb = new StringBundler(10);
        sb.append("select DLFileVersion.*, DDMContent.contentId, ");
        sb.append("DDMContent.data_, DDMStructure.structureId from ");
        sb.append("DLFileEntryMetadata inner join DDMContent on ");
        sb.append("DLFileEntryMetadata.DDMStorageId = DDMContent.contentId ");
        sb.append("inner join DDMStructure on ");
        sb.append("DLFileEntryMetadata.DDMStructureId = DDMStructure.");
        sb.append("structureId inner join DLFileVersion on ");
        sb.append("DLFileEntryMetadata.fileVersionId = DLFileVersion.");
        sb.append("fileVersionId and DLFileEntryMetadata.fileEntryId = ");
        sb.append("DLFileVersion.fileEntryId");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_= ? where contentId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                long entryId = rs.getLong("fileEntryId");
                String entryVersion = rs.getString("version");
                long contentId = rs.getLong("contentId");
                String data_ = rs.getString("data_");
                long ddmStructureId = rs.getLong("structureId");
                DDMForm ddmForm = this.getFullHierarchyDDMForm(ddmStructureId);
                DDMFormValues ddmFormValues = this.deserialize(data_, ddmForm);
                this.transformFieldTypeDDMFormFields(groupId, companyId, userId, userName, createDate, entryId, entryVersion, "DLFileEntry", ddmFormValues);
                ps2.setString(1, this.toJSON(ddmFormValues));
                ps2.setLong(2, contentId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void upgradeExpandoStorageAdapter() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb1 = new StringBundler(5);
            sb1.append("select DDMStructure.*, DDMStorageLink.* from ");
            sb1.append("DDMStorageLink inner join DDMStructure on ");
            sb1.append("DDMStorageLink.structureId = ");
            sb1.append("DDMStructure.structureId where ");
            sb1.append("DDMStructure.storageType = 'expando'");
            StringBundler sb2 = new StringBundler(4);
            sb2.append("insert into DDMContent (uuid_, contentId, groupId, ");
            sb2.append("companyId, userId, userName, createDate, ");
            sb2.append("modifiedDate, name, description, data_) values (?, ");
            sb2.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            StringBundler sb3 = new StringBundler(2);
            sb3.append("update DDMStorageLink set classNameId = ? where ");
            sb3.append("classNameId = ? and classPK = ?");
            try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
                 PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb3.toString());
                 ResultSet rs = ps1.executeQuery();){
                HashSet<Long> expandoRowIds = new HashSet<Long>();
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    long companyId = rs.getLong("companyId");
                    long userId = rs.getLong("userId");
                    String userName = rs.getString("userName");
                    Timestamp createDate = rs.getTimestamp("createDate");
                    long expandoRowId = rs.getLong("classPK");
                    String xml = this.toXML(this.getExpandoValuesMap(expandoRowId));
                    ps2.setString(1, PortalUUIDUtil.generate());
                    ps2.setLong(2, expandoRowId);
                    ps2.setLong(3, groupId);
                    ps2.setLong(4, companyId);
                    ps2.setLong(5, userId);
                    ps2.setString(6, userName);
                    ps2.setTimestamp(7, createDate);
                    ps2.setTimestamp(8, createDate);
                    ps2.setString(9, DDMStorageLink.class.getName());
                    ps2.setString(10, null);
                    ps2.setString(11, xml);
                    ps2.addBatch();
                    ps3.setLong(1, this._ddmContentClassNameId);
                    ps3.setLong(2, this._expandoStorageAdapterClassNameId);
                    ps3.setLong(3, expandoRowId);
                    ps3.addBatch();
                    expandoRowIds.add(expandoRowId);
                }
                if (expandoRowIds.isEmpty()) {
                    return;
                }
                ps2.executeBatch();
                ps3.executeBatch();
                this.updateDDMStructureStorageType();
                this.deleteExpandoData(expandoRowIds);
            }
        }
    }

    protected void upgradeFieldTypeReferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.upgradeDDLFieldTypeReferences();
            this.upgradeDLFieldTypeReferences();
        }
    }

    protected void upgradeStructurePermissions(long companyId, long structureId) throws Exception {
        List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(companyId, DDMStructure.class.getName(), 4, String.valueOf(structureId));
        for (ResourcePermission resourcePermission : resourcePermissions) {
            Long classNameId = this._structureClassNameIds.get(Long.valueOf(resourcePermission.getPrimKey()));
            if (classNameId == null) continue;
            String resourceName = this.getStructureModelResourceName(classNameId);
            resourcePermission.setName(resourceName);
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        }
    }

    protected void upgradeStructuresAndAddStructureVersionsAndLayouts() throws Exception {
        StringBundler sb1 = new StringBundler(6);
        sb1.append("insert into DDMStructureVersion (structureVersionId, ");
        sb1.append("groupId, companyId, userId, userName, createDate, ");
        sb1.append("structureId, version, parentStructureId, name, ");
        sb1.append("description, definition, storageType, type_, status, ");
        sb1.append("statusByUserId, statusByUserName, statusDate) values (?, ");
        sb1.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        StringBundler sb2 = new StringBundler(4);
        sb2.append("insert into DDMStructureLayout (uuid_, ");
        sb2.append("structureLayoutId, groupId, companyId, userId, userName, ");
        sb2.append("createDate, modifiedDate, structureVersionId, ");
        sb2.append("definition) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select * from DDMStructure");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb1.toString());
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long structureId = rs.getLong("structureId");
                long classNameId = rs.getLong("classNameId");
                String version = rs.getString("version");
                this._structureClassNameIds.put(structureId, classNameId);
                DDMForm ddmForm = this.getDDMForm(structureId);
                ddmForm = this.updateDDMFormFields(ddmForm);
                this.populateStructureInvalidDDMFormFieldNamesMap(structureId, ddmForm);
                String definition = this.toJSON(ddmForm);
                ps2.setString(1, definition);
                ps2.setLong(2, structureId);
                ps2.addBatch();
                this.updateTemplateScriptDateFields(structureId, ddmForm);
                if (this.hasStructureVersion(structureId, version)) continue;
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long parentStructureId = rs.getLong("parentStructureId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                String storageType = rs.getString("storageType");
                int type = rs.getInt("type_");
                long structureVersionId = this.increment();
                ps3.setLong(1, structureVersionId);
                ps3.setLong(2, groupId);
                ps3.setLong(3, companyId);
                ps3.setLong(4, userId);
                ps3.setString(5, userName);
                ps3.setTimestamp(6, modifiedDate);
                ps3.setLong(7, structureId);
                ps3.setString(8, "1.0");
                ps3.setLong(9, parentStructureId);
                ps3.setString(10, name);
                ps3.setString(11, description);
                ps3.setString(12, definition);
                ps3.setString(13, storageType);
                ps3.setInt(14, type);
                ps3.setInt(15, 0);
                ps3.setLong(16, userId);
                ps3.setString(17, userName);
                ps3.setTimestamp(18, modifiedDate);
                ps3.addBatch();
                String ddmFormLayoutDefinition = this.getDefaultDDMFormLayoutDefinition(ddmForm);
                ps4.setString(1, PortalUUIDUtil.generate());
                ps4.setLong(2, this.increment());
                ps4.setLong(3, groupId);
                ps4.setLong(4, companyId);
                ps4.setLong(5, userId);
                ps4.setString(6, userName);
                ps4.setTimestamp(7, modifiedDate);
                ps4.setTimestamp(8, modifiedDate);
                ps4.setLong(9, structureVersionId);
                ps4.setString(10, ddmFormLayoutDefinition);
                ps4.addBatch();
            }
            ps2.executeBatch();
            ps3.executeBatch();
            ps4.executeBatch();
        }
    }

    protected void upgradeStructuresPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from DDMStructure");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long structureId = rs.getLong("structureId");
                this.upgradeStructurePermissions(companyId, structureId);
            }
        }
    }

    protected void upgradeTemplatePermissions(long companyId, long templateId) throws Exception {
        List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(companyId, DDMTemplate.class.getName(), 4, String.valueOf(templateId));
        for (ResourcePermission resourcePermission : resourcePermissions) {
            Long classNameId = this._templateResourceClassNameIds.get(Long.valueOf(resourcePermission.getPrimKey()));
            if (classNameId == null) continue;
            String resourceName = this.getTemplateModelResourceName(classNameId);
            resourcePermission.setName(resourceName);
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        }
    }

    protected void upgradeTemplatesAndAddTemplateVersions() throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("insert into DDMTemplateVersion (templateVersionId, ");
        sb.append("groupId, companyId, userId, userName, createDate, ");
        sb.append("classNameId, classPK, templateId, version, name, ");
        sb.append("description, language, script, status, statusByUserId, ");
        sb.append("statusByUserName, statusDate) values (?, ?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select * from DDMTemplate");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplate set resourceClassNameId = ? where templateId = ?");
             PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMTemplate set language = ?, script = ? where templateId = ?");
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long classNameId = rs.getLong("classNameId");
                long classPK = rs.getLong("classPK");
                long templateId = rs.getLong("templateId");
                Long resourceClassNameId = this.getTemplateResourceClassNameId(classNameId, classPK);
                if (resourceClassNameId == null) {
                    _log.error((Object)("Orphaned DDM template " + templateId));
                    continue;
                }
                String version = rs.getString("version");
                String language = rs.getString("language");
                String script = rs.getString("script");
                ps2.setLong(1, resourceClassNameId);
                ps2.setLong(2, templateId);
                ps2.addBatch();
                this._templateResourceClassNameIds.put(templateId, resourceClassNameId);
                String updatedScript = this.renameInvalidDDMFormFieldNames(classPK, script);
                if (language.equals("xsd")) {
                    DDMForm ddmForm = this.deserialize(updatedScript, "xsd");
                    ddmForm = this.updateDDMFormFields(ddmForm);
                    updatedScript = this.toJSON(ddmForm);
                    language = "json";
                }
                if (!script.equals(updatedScript)) {
                    ps3.setString(1, language);
                    ps3.setString(2, updatedScript);
                    ps3.setLong(3, templateId);
                    ps3.addBatch();
                }
                if (this.hasTemplateVersion(templateId, version)) continue;
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                ps4.setLong(1, this.increment());
                ps4.setLong(2, rs.getLong("groupId"));
                ps4.setLong(3, rs.getLong("companyId"));
                ps4.setLong(4, userId);
                ps4.setString(5, userName);
                ps4.setTimestamp(6, modifiedDate);
                ps4.setLong(7, classNameId);
                ps4.setLong(8, classPK);
                ps4.setLong(9, templateId);
                ps4.setString(10, "1.0");
                ps4.setString(11, rs.getString("name"));
                ps4.setString(12, rs.getString("description"));
                ps4.setString(13, language);
                ps4.setString(14, updatedScript);
                ps4.setInt(15, 0);
                ps4.setLong(16, userId);
                ps4.setString(17, userName);
                ps4.setTimestamp(18, modifiedDate);
                ps4.addBatch();
            }
            ps2.executeBatch();
            ps3.executeBatch();
            ps4.executeBatch();
        }
    }

    protected void upgradeTemplatesPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from DDMTemplate");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long templateId = rs.getLong("templateId");
                this.upgradeTemplatePermissions(companyId, templateId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void upgradeXMLStorageAdapter() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(5);
            sb.append("select DDMStorageLink.classPK, DDMStorageLink.");
            sb.append("structureId from DDMStorageLink inner join ");
            sb.append("DDMStructure on (DDMStorageLink.structureId = ");
            sb.append("DDMStructure.structureId) where DDMStorageLink.");
            sb.append("classNameId = ? and DDMStructure.storageType = ?");
            try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
                 PreparedStatement ps2 = this.connection.prepareStatement("select companyId, data_ from DDMContent where contentId = ? and data_ like '<%'");
                 PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_= ? where contentId = ?");){
                ps1.setLong(1, this._ddmContentClassNameId);
                ps1.setString(2, "xml");
                try (ResultSet rs = ps1.executeQuery();){
                    while (rs.next()) {
                        ResultSet rs2;
                        block71: {
                            long structureId = rs.getLong("structureId");
                            long classPK = rs.getLong("classPK");
                            DDMForm ddmForm = this.getFullHierarchyDDMForm(structureId);
                            ps2.setLong(1, classPK);
                            rs2 = ps2.executeQuery();
                            Throwable throwable = null;
                            try {
                                if (rs2.next()) {
                                    long companyId = rs2.getLong("companyId");
                                    String xml = rs2.getString("data_");
                                    DDMFormValues ddmFormValues = this.getDDMFormValues(companyId, ddmForm, xml);
                                    String content = this.toJSON(ddmFormValues);
                                    content = this.renameInvalidDDMFormFieldNames(structureId, content);
                                    ps3.setString(1, content);
                                    ps3.setLong(2, classPK);
                                    ps3.addBatch();
                                }
                                if (rs2 == null) continue;
                                if (throwable == null) break block71;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (rs2 == null) throw throwable3;
                                    if (throwable == null) {
                                        rs2.close();
                                        throw throwable3;
                                    }
                                    try {
                                        rs2.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                rs2.close();
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                continue;
                            }
                        }
                        rs2.close();
                    }
                    ps3.executeBatch();
                }
            }
            this.updateStructureStorageType();
            this.updateStructureVersionStorageType();
            return;
        }
    }

    protected void validateDDMFormFieldName(DDMFormField ddmFormField, Set<String> ddmFormFieldNames) throws DDMFormValidationException.MustNotDuplicateFieldName {
        if (ddmFormFieldNames.contains(StringUtil.toLowerCase((String)ddmFormField.getName()))) {
            throw new DDMFormValidationException.MustNotDuplicateFieldName(ddmFormField.getName());
        }
        ddmFormFieldNames.add(StringUtil.toLowerCase((String)ddmFormField.getName()));
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.validateDDMFormFieldName(nestedDDMFormField, ddmFormFieldNames);
        }
    }

    protected void validateDDMFormFieldNames(DDMForm ddmForm) throws DDMFormValidationException.MustNotDuplicateFieldName {
        List ddmFormFields = ddmForm.getDDMFormFields();
        HashSet<String> ddmFormFieldNames = new HashSet<String>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            this.validateDDMFormFieldName(ddmFormField, ddmFormFieldNames);
        }
    }

    private void _initModelResourceNames(ResourceActions resourceActions) {
        this._structureModelResourceNames.put("com.liferay.document.library.kernel.model.DLFileEntry", resourceActions.getCompositeModelName(new String[]{"com.liferay.document.library.kernel.model.DLFileEntry", _CLASS_NAME_DDM_STRUCTURE}));
        this._structureModelResourceNames.put("com.liferay.document.library.kernel.model.DLFileEntryMetadata", resourceActions.getCompositeModelName(new String[]{"com.liferay.document.library.kernel.model.DLFileEntryMetadata", _CLASS_NAME_DDM_STRUCTURE}));
        this._structureModelResourceNames.put("com.liferay.document.library.kernel.util.RawMetadataProcessor", _CLASS_NAME_DDM_STRUCTURE);
        this._structureModelResourceNames.put("com.liferay.dynamic.data.lists.model.DDLRecordSet", resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_STRUCTURE}));
        this._structureModelResourceNames.put("com.liferay.portlet.dynamicdatalists.model.DDLRecordSet", resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_STRUCTURE}));
        this._structureModelResourceNames.put("com.liferay.portlet.journal.model.JournalArticle", resourceActions.getCompositeModelName(new String[]{"com.liferay.journal.model.JournalArticle", _CLASS_NAME_DDM_STRUCTURE}));
        this._templateModelResourceNames.put("com.liferay.dynamic.data.lists.model.DDLRecordSet", resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_TEMPLATE}));
        this._templateModelResourceNames.put("com.liferay.portlet.display.template.PortletDisplayTemplate", _CLASS_NAME_DDM_TEMPLATE);
        this._templateModelResourceNames.put("com.liferay.portlet.dynamicdatalists.model.DDLRecordSet", resourceActions.getCompositeModelName(new String[]{"com.liferay.dynamic.data.lists.model.DDLRecordSet", _CLASS_NAME_DDM_TEMPLATE}));
        this._templateModelResourceNames.put("com.liferay.portlet.journal.model.JournalArticle", resourceActions.getCompositeModelName(new String[]{"com.liferay.journal.model.JournalArticle", _CLASS_NAME_DDM_TEMPLATE}));
    }

    private class FileUploadDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final long _companyId;
        private final Timestamp _createDate;
        private final long _entryId;
        private final String _entryModelName;
        private final String _entryVersion;
        private final long _groupId;
        private final String[] _groupPermissions = new String[]{"ADD_DISCUSSION", "VIEW"};
        private final String[] _guestPermissions = new String[]{"ADD_DISCUSSION", "VIEW"};
        private final ModelPermissions _modelPermissions;
        private final Timestamp _now = new Timestamp(System.currentTimeMillis());
        private final String[] _ownerPermissions = new String[]{"ADD_DISCUSSION", "DELETE", "DELETE_DISCUSSION", "OVERRIDE_CHECKOUT", "PERMISSIONS", "UPDATE", "UPDATE_DISCUSSION", "VIEW"};
        private final long _userId;
        private final String _userName;

        public FileUploadDDMFormFieldValueTransformer(long groupId, long companyId, long userId, String userName, Timestamp createDate, long entryId, String entryVersion, String entryModelName) {
            this._groupId = groupId;
            this._companyId = companyId;
            this._userId = userId;
            this._userName = userName;
            this._createDate = createDate;
            this._entryId = entryId;
            this._entryVersion = entryVersion;
            this._entryModelName = entryModelName;
            this._modelPermissions = ModelPermissionsFactory.create((String[])this._groupPermissions, (String[])this._guestPermissions);
            this._modelPermissions.addRolePermissions("Owner", this._ownerPermissions);
        }

        public String getFieldType() {
            return "ddm-fileupload";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                for (Locale locale : value.getAvailableLocales()) {
                    String valueString = value.getString(locale);
                    if (Validator.isNull((String)valueString)) continue;
                    String fileEntryUuid = PortalUUIDUtil.generate();
                    this.upgradeFileUploadReference(fileEntryUuid, ddmFormFieldValue.getName(), valueString);
                    value.addString(locale, this.toJSON(this._groupId, fileEntryUuid));
                }
            }
        }

        protected void addAssetEntry(long entryId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String classUuid, long classTypeId, boolean visible, Timestamp startDate, Timestamp endDate, Timestamp publishDate, Timestamp expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, double priority, int viewCount) throws Exception {
            AssetEntry assetEntry = UpgradeDynamicDataMapping.this._assetEntryLocalService.createAssetEntry(entryId);
            assetEntry.setGroupId(groupId);
            assetEntry.setCompanyId(companyId);
            assetEntry.setUserId(userId);
            assetEntry.setUserName(userName);
            assetEntry.setCreateDate((Date)createDate);
            assetEntry.setModifiedDate((Date)modifiedDate);
            assetEntry.setClassNameId(classNameId);
            assetEntry.setClassPK(classPK);
            assetEntry.setClassUuid(classUuid);
            assetEntry.setClassTypeId(classTypeId);
            assetEntry.setVisible(visible);
            assetEntry.setStartDate((Date)startDate);
            assetEntry.setEndDate((Date)endDate);
            assetEntry.setPublishDate((Date)publishDate);
            assetEntry.setExpirationDate((Date)expirationDate);
            assetEntry.setMimeType(mimeType);
            assetEntry.setTitle(title);
            assetEntry.setDescription(description);
            assetEntry.setSummary(summary);
            assetEntry.setUrl(url);
            assetEntry.setLayoutUuid(layoutUuid);
            assetEntry.setHeight(height);
            assetEntry.setWidth(width);
            assetEntry.setPriority(priority);
            assetEntry.setViewCount(viewCount);
            UpgradeDynamicDataMapping.this._assetEntryLocalService.updateAssetEntry(assetEntry);
        }

        protected long addDDMDLFolder() throws Exception {
            long ddmFolderId = this.getDLFolderId(this._groupId, 0L, "DDM");
            if (ddmFolderId > 0L) {
                return ddmFolderId;
            }
            ddmFolderId = UpgradeDynamicDataMapping.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), ddmFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, 0L, "DDM", "", this._now);
            return ddmFolderId;
        }

        protected DLFileEntry addDLFileEntry(String uuid, long fileEntryId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, long repositoryId, long folderId, String treePath, String name, String fileName, String extension, String mimeType, String title, String description, String extraSettings, long fileEntryTypeId, String version, long size, int readCount, long smallImageId, long largeImageId, long custom1ImageId, long custom2ImageId, boolean manualCheckInRequired) throws Exception {
            DLFileEntry dlFileEntry = UpgradeDynamicDataMapping.this._dlFileEntryLocalService.createDLFileEntry(fileEntryId);
            dlFileEntry.setUuid(uuid);
            dlFileEntry.setGroupId(groupId);
            dlFileEntry.setCompanyId(companyId);
            dlFileEntry.setUserId(userId);
            dlFileEntry.setUserName(userName);
            dlFileEntry.setCreateDate((Date)createDate);
            dlFileEntry.setModifiedDate((Date)modifiedDate);
            dlFileEntry.setClassNameId(classNameId);
            dlFileEntry.setClassPK(classPK);
            dlFileEntry.setRepositoryId(repositoryId);
            dlFileEntry.setFolderId(folderId);
            dlFileEntry.setTreePath(treePath);
            dlFileEntry.setName(name);
            dlFileEntry.setFileName(fileName);
            dlFileEntry.setExtension(extension);
            dlFileEntry.setMimeType(mimeType);
            dlFileEntry.setTitle(title);
            dlFileEntry.setDescription(description);
            dlFileEntry.setExtraSettings(extraSettings);
            dlFileEntry.setFileEntryTypeId(fileEntryTypeId);
            dlFileEntry.setVersion(version);
            dlFileEntry.setSize(size);
            dlFileEntry.setReadCount(readCount);
            dlFileEntry.setSmallImageId(smallImageId);
            dlFileEntry.setLargeImageId(largeImageId);
            dlFileEntry.setCustom1ImageId(custom1ImageId);
            dlFileEntry.setCustom2ImageId(custom2ImageId);
            dlFileEntry.setManualCheckInRequired(manualCheckInRequired);
            return dlFileEntry;
        }

        protected void addDLFileVersion(String uuid, long fileVersionId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long folderId, long fileEntryId, String treePath, String fileName, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, String version, long size, String checksum, int status, long statusByUserId, String statusByUserName, Timestamp statusDate) throws Exception {
            DLFileVersion dlFileVersion = UpgradeDynamicDataMapping.this._dlFileVersionLocalService.createDLFileVersion(fileVersionId);
            dlFileVersion.setUuid(uuid);
            dlFileVersion.setGroupId(groupId);
            dlFileVersion.setCompanyId(companyId);
            dlFileVersion.setUserId(userId);
            dlFileVersion.setUserName(userName);
            dlFileVersion.setCreateDate((Date)createDate);
            dlFileVersion.setModifiedDate((Date)modifiedDate);
            dlFileVersion.setRepositoryId(repositoryId);
            dlFileVersion.setFolderId(folderId);
            dlFileVersion.setFileEntryId(fileEntryId);
            dlFileVersion.setTreePath(treePath);
            dlFileVersion.setFileName(fileName);
            dlFileVersion.setExtension(extension);
            dlFileVersion.setMimeType(mimeType);
            dlFileVersion.setTitle(title);
            dlFileVersion.setDescription(description);
            dlFileVersion.setChangeLog(changeLog);
            dlFileVersion.setExtraSettings(extraSettings);
            dlFileVersion.setFileEntryTypeId(fileEntryTypeId);
            dlFileVersion.setVersion(version);
            dlFileVersion.setSize(size);
            dlFileVersion.setChecksum(checksum);
            dlFileVersion.setStatus(status);
            dlFileVersion.setStatusByUserId(statusByUserId);
            dlFileVersion.setStatusByUserName(statusByUserName);
            dlFileVersion.setStatusDate((Date)statusDate);
            UpgradeDynamicDataMapping.this._dlFileVersionLocalService.updateDLFileVersion(dlFileVersion);
        }

        protected void addDLFolder(String uuid, long folderId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long parentFolderId, String name, String description, Timestamp lastPostDate) throws Exception {
            DLFolder dlFolder = UpgradeDynamicDataMapping.this._dlFolderLocalService.createDLFolder(folderId);
            dlFolder.setUuid(uuid);
            dlFolder.setGroupId(groupId);
            dlFolder.setCompanyId(companyId);
            dlFolder.setUserId(userId);
            dlFolder.setUserName(userName);
            dlFolder.setCreateDate((Date)createDate);
            dlFolder.setModifiedDate((Date)modifiedDate);
            dlFolder.setRepositoryId(repositoryId);
            dlFolder.setMountPoint(false);
            dlFolder.setParentFolderId(parentFolderId);
            dlFolder.setName(name);
            dlFolder.setDescription(description);
            dlFolder.setLastPostDate((Date)lastPostDate);
            dlFolder.setDefaultFileEntryTypeId(0L);
            dlFolder.setHidden(false);
            dlFolder.setRestrictionType(0);
            dlFolder.setStatus(0);
            dlFolder.setStatusByUserId(0L);
            dlFolder.setStatusByUserName("");
            UpgradeDynamicDataMapping.this._dlFolderLocalService.updateDLFolder(dlFolder);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setModelPermissions(UpgradeDynamicDataMapping.this._dlFolderModelPermissions);
            UpgradeDynamicDataMapping.this._resourceLocalService.addModelResources((AuditedModel)dlFolder, serviceContext);
        }

        protected long addDLFolderTree(String ddmFormFieldName) throws Exception {
            long ddmFolderId = this.addDDMDLFolder();
            long entryIdFolderId = this.addEntryIdDLFolder(ddmFolderId);
            long entryVersionFolderId = this.addEntryVersionDLFolder(entryIdFolderId);
            long fieldNameFolderId = UpgradeDynamicDataMapping.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), fieldNameFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, entryVersionFolderId, ddmFormFieldName, "", this._now);
            return fieldNameFolderId;
        }

        protected long addEntryIdDLFolder(long ddmFolderId) throws Exception {
            long entryIdFolderId = this.getDLFolderId(this._groupId, ddmFolderId, String.valueOf(this._entryId));
            if (entryIdFolderId > 0L) {
                return entryIdFolderId;
            }
            entryIdFolderId = UpgradeDynamicDataMapping.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), entryIdFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, ddmFolderId, String.valueOf(this._entryId), "", this._now);
            return entryIdFolderId;
        }

        protected long addEntryVersionDLFolder(long entryIdFolderId) throws Exception {
            long entryVersionFolderId = this.getDLFolderId(this._groupId, entryIdFolderId, this._entryVersion);
            if (entryVersionFolderId > 0L) {
                return entryVersionFolderId;
            }
            entryVersionFolderId = UpgradeDynamicDataMapping.this.increment();
            this.addDLFolder(PortalUUIDUtil.generate(), entryVersionFolderId, this._groupId, this._companyId, this._userId, this._userName, this._now, this._now, this._groupId, entryIdFolderId, this._entryVersion, "", this._now);
            return entryVersionFolderId;
        }

        protected File fetchFile(String filePath) throws PortalException {
            try {
                return UpgradeDynamicDataMapping.this._store.getFile(this._companyId, 0L, filePath);
            }
            catch (PortalException portalException) {
                _log.error((Object)String.format("Unable to find the binary file with path \"%s\" referenced by %s", filePath, this.getModelInfo()));
                throw portalException;
            }
        }

        protected long getDLFolderId(long groupId, long parentFolderId, String name) {
            DLFolder dlFolder = UpgradeDynamicDataMapping.this._dlFolderLocalService.fetchFolder(groupId, parentFolderId, name);
            if (dlFolder == null) {
                return 0L;
            }
            return dlFolder.getFolderId();
        }

        protected String getExtension(String fileName) {
            String extension = "";
            int pos = fileName.lastIndexOf(46);
            if (pos > 0) {
                extension = fileName.substring(pos + 1);
            }
            return StringUtil.toLowerCase((String)extension);
        }

        protected String getModelInfo() {
            return String.format("%s {primaryKey: %d, version: %s}", this._entryModelName, this._entryId, this._entryVersion);
        }

        protected String toJSON(long groupId, String fileEntryUuid) {
            JSONObject jsonObject = JSONUtil.put((String)"groupId", (Object)groupId).put("uuid", fileEntryUuid);
            return jsonObject.toString();
        }

        protected String upgradeFileUploadReference(String fileEntryUuid, String ddmFormFieldName, String valueString) throws PortalException {
            try {
                long dlFolderId = this.addDLFolderTree(ddmFormFieldName);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                String name = String.valueOf(UpgradeDynamicDataMapping.this.increment(DLFileEntry.class.getName()));
                String fileName = jsonObject.getString("name");
                String filePath = jsonObject.getString("path");
                long fileEntryId = UpgradeDynamicDataMapping.this.increment();
                String extension = this.getExtension(fileName);
                File file = this.fetchFile(filePath);
                DLFileEntry dlFileEntry = this.addDLFileEntry(fileEntryUuid, fileEntryId, this._groupId, this._companyId, this._userId, this._userName, this._createDate, this._createDate, 0L, 0L, this._groupId, dlFolderId, "", name, fileName, extension, MimeTypesUtil.getContentType((String)fileName), fileName, "", "", 0L, "1.0", file.length(), 0, 0L, 0L, 0L, 0L, false);
                this.addDLFileVersion(fileEntryUuid, UpgradeDynamicDataMapping.this.increment(), this._groupId, this._companyId, this._userId, this._userName, this._createDate, this._createDate, this._groupId, dlFolderId, fileEntryId, "", fileName, extension, MimeTypesUtil.getContentType((String)fileName), fileName, "", "", "", 0L, "1.0", file.length(), "", 0, this._userId, this._userName, this._createDate);
                UpgradeDynamicDataMapping.this._dlFileEntryLocalService.updateDLFileEntry(dlFileEntry);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setModelPermissions(this._modelPermissions);
                UpgradeDynamicDataMapping.this._resourceLocalService.addModelResources((AuditedModel)dlFileEntry, serviceContext);
                this.addAssetEntry(UpgradeDynamicDataMapping.this.increment(), this._groupId, this._companyId, this._userId, this._userName, this._createDate, this._createDate, PortalUtil.getClassNameId(DLFileEntry.class), fileEntryId, fileEntryUuid, 0L, false, null, null, null, null, MimeTypesUtil.getContentType((String)fileName), fileName, "", "", null, null, 0, 0, 0.0, 0);
                UpgradeDynamicDataMapping.this._store.addFile(this._companyId, dlFolderId, name, file);
                return fileEntryUuid;
            }
            catch (Exception exception) {
                throw new UpgradeException((Throwable)exception);
            }
        }
    }

    private static class DDMFormValuesXSDDeserializer {
        private long _companyId;

        public DDMFormValuesXSDDeserializer(long companyId) {
            this._companyId = companyId;
        }

        public DDMFormValues deserialize(DDMForm ddmForm, String xml) throws PortalException {
            try {
                DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
                Document document = SAXReaderUtil.read((String)xml);
                Element rootElement = document.getRootElement();
                this.setDDMFormValuesAvailableLocales(ddmFormValues, rootElement);
                this.setDDMFormValuesDefaultLocale(ddmFormValues, rootElement);
                DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
                for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
                    String fieldName = ddmFormField.getName();
                    int repetitions = this.countDDMFieldRepetitions(rootElement, fieldName, null, -1);
                    for (int i = 0; i < repetitions; ++i) {
                        DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(ddmFormField, ddmFieldsCounter, fieldName, rootElement);
                        if (ddmFormFieldValue == null) continue;
                        ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
                    }
                }
                return ddmFormValues;
            }
            catch (DocumentException documentException) {
                throw new UpgradeException((Throwable)documentException);
            }
        }

        protected int countDDMFieldRepetitions(Element rootElement, String fieldName, String parentFieldName, int parentOffset) {
            String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(rootElement, true);
            if (ddmFieldsDisplayValues.length != 0) {
                return this.countDDMFieldRepetitions(ddmFieldsDisplayValues, fieldName, parentFieldName, parentOffset);
            }
            Element dynamicElementElement = this.getDynamicElementElementByName(rootElement, fieldName);
            if (dynamicElementElement != null) {
                return 1;
            }
            return 0;
        }

        protected int countDDMFieldRepetitions(String[] fieldsDisplayValues, String fieldName, String parentFieldName, int parentOffset) {
            int offset = -1;
            int repetitions = 0;
            for (String fieldDisplayName : fieldsDisplayValues) {
                if (offset > parentOffset) break;
                if (fieldDisplayName.equals(parentFieldName)) {
                    ++offset;
                }
                if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
                ++repetitions;
            }
            return repetitions;
        }

        protected DDMFormFieldValue createDDMFormFieldValue(DDMFormField ddmFormField, DDMFieldsCounter ddmFieldsCounter, final String fieldName, Element rootElement) throws PortalException {
            final Value value = this.extractDDMFormFieldValue(ddmFormField, ddmFieldsCounter, fieldName, rootElement);
            if (value == null && !ddmFormField.isTransient()) {
                return null;
            }
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setName(fieldName);
                    this.setValue(value);
                }
            };
            this.setDDMFormFieldValueInstanceId(ddmFormFieldValue, rootElement, ddmFieldsCounter);
            this.setNestedDDMFormFieldValues(ddmFormFieldValue, ddmFormField, rootElement, ddmFieldsCounter);
            ddmFieldsCounter.incrementKey((Object)fieldName);
            return ddmFormFieldValue;
        }

        protected Value extractDDMFormFieldLocalizedValue(Element element, int index) {
            LocalizedValue value = new LocalizedValue(this.getDefaultLocale(element));
            HashMap<String, Integer> dynamicContentValues = new HashMap<String, Integer>();
            for (Element dynamicContentElement : element.elements("dynamic-content")) {
                String languageId = dynamicContentElement.attributeValue("language-id");
                int localizedContentIndex = dynamicContentValues.getOrDefault(languageId, 0);
                if (localizedContentIndex == index) {
                    value.addString(LocaleUtil.fromLanguageId((String)languageId), dynamicContentElement.getText());
                }
                dynamicContentValues.put(languageId, localizedContentIndex + 1);
            }
            return value;
        }

        protected Value extractDDMFormFieldValue(DDMFormField ddmFormField, DDMFieldsCounter ddmFieldsCounter, String fieldName, Element rootElement) {
            Object value = null;
            Element element = this.getDynamicElementElementByName(rootElement, fieldName);
            if (Validator.isNotNull((String)ddmFormField.getDataType()) && element != null) {
                value = ddmFormField.isLocalizable() ? this.extractDDMFormFieldLocalizedValue(element, ddmFieldsCounter.get((Object)fieldName)) : new UnlocalizedValue(this.getDDMFormFieldValueValueString(element, this.getDefaultLocale(element), ddmFieldsCounter.get((Object)fieldName)));
            }
            return value;
        }

        protected Set<Locale> getAvailableLocales(Element dynamicElementElement) {
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            LinkedHashSet<Locale> availableLocales = new LinkedHashSet<Locale>();
            for (Element dynamicContentElement : dynamicContentElements) {
                String languageId = dynamicContentElement.attributeValue("language-id");
                availableLocales.add(LocaleUtil.fromLanguageId((String)languageId));
            }
            return availableLocales;
        }

        protected Set<Locale> getAvailableLocales(List<Element> dynamicElementElements) {
            LinkedHashSet<Locale> availableLocales = new LinkedHashSet<Locale>();
            for (Element dynamicElementElement : dynamicElementElements) {
                availableLocales.addAll(this.getAvailableLocales(dynamicElementElement));
            }
            return availableLocales;
        }

        protected String getDDMFieldInstanceId(Element rootElement, String fieldName, int index) {
            String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(rootElement, false);
            if (ddmFieldsDisplayValues.length == 0) {
                return StringUtil.randomString();
            }
            String prefix = fieldName.concat("_INSTANCE_");
            for (String ddmFieldsDisplayValue : ddmFieldsDisplayValues) {
                if (!ddmFieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
                return StringUtil.extractLast((String)ddmFieldsDisplayValue, (String)"_INSTANCE_");
            }
            return null;
        }

        protected String[] getDDMFieldsDisplayValues(Element rootElement, boolean extractFieldName) {
            Element fieldsDisplayDynamicContent;
            Element fieldsDisplayElement = this.getDynamicElementElementByName(rootElement, "_fieldsDisplay");
            ArrayList<String> ddmFieldsDisplayValues = new ArrayList<String>();
            if (fieldsDisplayElement != null && (fieldsDisplayDynamicContent = fieldsDisplayElement.element("dynamic-content")) != null) {
                String fieldsDisplayText = fieldsDisplayDynamicContent.getText();
                for (String fieldDisplayValue : StringUtil.split((String)fieldsDisplayText)) {
                    if (extractFieldName) {
                        fieldDisplayValue = StringUtil.extractFirst((String)fieldDisplayValue, (String)"_INSTANCE_");
                    }
                    ddmFieldsDisplayValues.add(fieldDisplayValue);
                }
            }
            return ddmFieldsDisplayValues.toArray(new String[0]);
        }

        protected DDMFormFieldValue getDDMFormFieldValue(Element dynamicElementElement) {
            DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
            ddmFormFieldValue.setName(dynamicElementElement.attributeValue("name"));
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            ddmFormFieldValue.setValue(this.getValue(dynamicContentElements));
            ddmFormFieldValue.setNestedDDMFormFields(this.getDDMFormFieldValues(dynamicElementElement.elements("dynamic-element")));
            return ddmFormFieldValue;
        }

        protected List<DDMFormFieldValue> getDDMFormFieldValues(List<Element> dynamicElementElements) {
            if (dynamicElementElements == null) {
                return null;
            }
            ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
            for (Element dynamicElement : dynamicElementElements) {
                ddmFormFieldValues.add(this.getDDMFormFieldValue(dynamicElement));
            }
            return ddmFormFieldValues;
        }

        protected String getDDMFormFieldValueValueString(Element dynamicElementElement, Locale locale, int index) {
            Element dynamicContentElement = this.getDynamicContentElement(dynamicElementElement, locale, index);
            return dynamicContentElement.getTextTrim();
        }

        protected Locale getDefaultLocale(Element dynamicElementElement) {
            if (dynamicElementElement == null) {
                String locale = null;
                try {
                    locale = UpgradeProcessUtil.getDefaultLanguageId((long)this._companyId);
                }
                catch (SQLException sqlException) {
                    _log.error((Object)("Unable to get default locale for company " + this._companyId), (Throwable)sqlException);
                    throw new RuntimeException(sqlException);
                }
                return LocaleUtil.fromLanguageId((String)locale);
            }
            String defaultLanguageId = dynamicElementElement.attributeValue("default-language-id");
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }

        protected Locale getDefaultLocale(List<Element> dynamicElementElements) {
            for (Element dynamicElement : dynamicElementElements) {
                String defaultLanguageId = dynamicElement.attributeValue("default-language-id");
                if (defaultLanguageId == null) continue;
                return LocaleUtil.fromLanguageId((String)defaultLanguageId);
            }
            return null;
        }

        protected Element getDynamicContentElement(Element dynamicElementElement, Locale locale, int index) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            XPath dynamicContentXPath = SAXReaderUtil.createXPath((String)("dynamic-content[(@language-id='" + languageId + "')]"));
            List nodes = dynamicContentXPath.selectNodes((Object)dynamicElementElement);
            if (nodes.isEmpty()) {
                dynamicContentXPath = SAXReaderUtil.createXPath((String)"dynamic-content");
                nodes = dynamicContentXPath.selectNodes((Object)dynamicElementElement);
                Element element = null;
                element = nodes.isEmpty() ? dynamicElementElement.addElement("dynamic-content") : (Element)nodes.get(index);
                element.addAttribute("language-id", languageId);
                return element;
            }
            return (Element)nodes.get(index);
        }

        protected Element getDynamicElementElementByName(Element rootElement, String fieldName) {
            XPath dynamicElementXPath = SAXReaderUtil.createXPath((String)("//dynamic-element[(@name=\"" + fieldName + "\")]"));
            if (dynamicElementXPath.booleanValueOf((Object)rootElement)) {
                return (Element)dynamicElementXPath.evaluate((Object)rootElement);
            }
            return null;
        }

        protected Value getValue(List<Element> dynamicContentElements) {
            LocalizedValue value = new LocalizedValue();
            for (Element dynamicContentElement : dynamicContentElements) {
                String fieldValue = dynamicContentElement.getText();
                String languageId = dynamicContentElement.attributeValue("language-id");
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                value.addString(locale, fieldValue);
            }
            return value;
        }

        protected void setDDMFormFieldValueInstanceId(DDMFormFieldValue ddmFormFieldValue, Element rootElement, DDMFieldsCounter ddmFieldsCounter) {
            String name = ddmFormFieldValue.getName();
            String instanceId = this.getDDMFieldInstanceId(rootElement, name, ddmFieldsCounter.get((Object)name));
            ddmFormFieldValue.setInstanceId(instanceId);
        }

        protected void setDDMFormValuesAvailableLocales(DDMFormValues ddmFormValues, Element rootElement) {
            Set<Locale> availableLocales = this.getAvailableLocales(rootElement.elements("dynamic-element"));
            ddmFormValues.setAvailableLocales(availableLocales);
        }

        protected void setDDMFormValuesDefaultLocale(DDMFormValues ddmFormValues, Element rootElement) {
            Locale defaultLocale = this.getDefaultLocale(rootElement.elements("dynamic-element"));
            ddmFormValues.setDefaultLocale(defaultLocale);
        }

        protected void setNestedDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue, DDMFormField ddmFormField, Element rootElement, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
            String fieldName = ddmFormFieldValue.getName();
            int parentOffset = ddmFieldsCounter.get((Object)fieldName);
            Map nestedDDMFormFieldsMap = ddmFormField.getNestedDDMFormFieldsMap();
            String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(rootElement, true);
            for (Map.Entry nestedDDMFormFieldEntry : nestedDDMFormFieldsMap.entrySet()) {
                String nestedDDMFormFieldName = (String)nestedDDMFormFieldEntry.getKey();
                DDMFormField nestedDDMFormField = (DDMFormField)nestedDDMFormFieldEntry.getValue();
                int repetitions = this.countDDMFieldRepetitions(ddmFieldsDisplayValues, nestedDDMFormFieldName, fieldName, parentOffset);
                for (int i = 0; i < repetitions; ++i) {
                    DDMFormFieldValue nestedDDMFormFieldValue = this.createDDMFormFieldValue(nestedDDMFormField, ddmFieldsCounter, nestedDDMFormFieldName, rootElement);
                    if (nestedDDMFormFieldValue == null) continue;
                    ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
                }
            }
        }
    }

    private static class DateDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private final DateFormat _dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd", (TimeZone)TimeZoneUtil.getTimeZone((String)"UTC"));

        private DateDDMFormFieldValueTransformer() {
        }

        public String getFieldType() {
            return "ddm-date";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            if (value != null) {
                for (Locale locale : value.getAvailableLocales()) {
                    String valueString = value.getString(locale);
                    if (Validator.isNull((String)valueString) || !Validator.isNumber((String)valueString)) continue;
                    Date dateValue = new Date(GetterUtil.getLong((String)valueString));
                    value.addString(locale, this._dateFormat.format(dateValue));
                }
            }
        }
    }
}

