/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.background.task;

import com.liferay.dynamic.data.mapping.internal.background.task.DDMStructureIndexerTracker;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.DDMStructureIndexer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"background.task.executor.class.name=com.liferay.dynamic.data.mapping.internal.background.task.DDMStructureIndexerBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class DDMStructureIndexerBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    private static final String _BACKGROUND_TASK_NAME_PREFIX = "DDMStructureIndexerBackgroundTaskExecutor-";
    private DDMStructureIndexerTracker _ddmStructureIndexerTracker;
    private DDMStructureLocalService _ddmStructureLocalService;

    public static String getBackgroundTaskName(long structureId) {
        return _BACKGROUND_TASK_NAME_PREFIX + structureId;
    }

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        Number structureIdNumber = (Number)taskContextMap.get("structureId");
        long structureId = structureIdNumber.longValue();
        DDMStructureIndexer structureIndexer = this.getDDMStructureIndexer(structureId);
        List<Long> ddmStructureIds = this.getChildrenStructureIds(structureId);
        structureIndexer.reindexDDMStructures(ddmStructureIds);
        return BackgroundTaskResult.SUCCESS;
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return null;
    }

    public int getIsolationLevel() {
        return 5;
    }

    public boolean isSerial() {
        return true;
    }

    protected void getChildrenStructureIds(List<Long> structureIds, long parentStructureId) throws PortalException {
        List structures = this._ddmStructureLocalService.getChildrenStructures(parentStructureId);
        for (DDMStructure structure : structures) {
            structureIds.add(structure.getStructureId());
            this.getChildrenStructureIds(structureIds, structure.getStructureId());
        }
    }

    protected List<Long> getChildrenStructureIds(long structureId) throws PortalException {
        ArrayList<Long> structureIds = new ArrayList<Long>();
        this.getChildrenStructureIds(structureIds, structureId);
        structureIds.add(0, structureId);
        return structureIds;
    }

    protected DDMStructureIndexer getDDMStructureIndexer(long structureId) throws PortalException {
        DDMStructure structure = this._ddmStructureLocalService.getStructure(structureId);
        return this._ddmStructureIndexerTracker.getDDMStructureIndexer(structure.getClassName());
    }

    @Reference(unbind="-")
    protected void setDDMStructureIndexerTracker(DDMStructureIndexerTracker ddmStructureIndexerTracker) {
        this._ddmStructureIndexerTracker = ddmStructureIndexerTracker;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }
}

