/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.internal.search.util.DDMSearchHelper;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutDeserializerTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerTracker;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLayoutLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.persistence.DDMStructureLayoutPersistence;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMStructureLayoutLocalServiceImpl
extends DDMStructureLayoutLocalServiceBaseImpl {
    @ServiceReference(type=DDMFormLayoutDeserializerTracker.class)
    protected DDMFormLayoutDeserializerTracker ddmFormLayoutDeserializerTracker;
    @ServiceReference(type=DDMFormLayoutSerializerTracker.class)
    protected DDMFormLayoutSerializerTracker ddmFormLayoutSerializerTracker;
    @ServiceReference(type=DDMFormLayoutValidator.class)
    protected DDMFormLayoutValidator ddmFormLayoutValidator;
    @ServiceReference(type=DDMSearchHelper.class)
    protected DDMSearchHelper ddmSearchHelper;

    public DDMStructureLayout addStructureLayout(long userId, long groupId, long structureVersionId, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(ddmFormLayout);
        long structureLayoutId = this.counterLocalService.increment();
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.create(structureLayoutId);
        structureLayout.setUuid(serviceContext.getUuid());
        structureLayout.setGroupId(groupId);
        structureLayout.setCompanyId(user.getCompanyId());
        structureLayout.setUserId(user.getUserId());
        structureLayout.setUserName(user.getFullName());
        structureLayout.setStructureVersionId(structureVersionId);
        structureLayout.setDefinition(this.serialize(ddmFormLayout));
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructureLayout addStructureLayout(long userId, long groupId, long structureVersionId, Map<Locale, String> name, Map<Locale, String> description, String definition, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long structureLayoutId = this.counterLocalService.increment();
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.create(structureLayoutId);
        structureLayout.setUuid(serviceContext.getUuid());
        structureLayout.setGroupId(groupId);
        structureLayout.setCompanyId(user.getCompanyId());
        structureLayout.setUserId(user.getUserId());
        structureLayout.setUserName(user.getFullName());
        structureLayout.setCreateDate(new Date());
        structureLayout.setModifiedDate(new Date());
        structureLayout.setStructureVersionId(structureVersionId);
        structureLayout.setNameMap(name);
        structureLayout.setDescriptionMap(description);
        structureLayout.setDefinition(definition);
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    @SystemEvent(type=1)
    public void deleteStructureLayout(DDMStructureLayout structureLayout) {
        this.ddmStructureLayoutPersistence.remove((BaseModel)structureLayout);
    }

    public void deleteStructureLayout(long structureLayoutId) throws PortalException {
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
        this.ddmStructureLayoutLocalService.deleteStructureLayout(structureLayout);
    }

    public DDMStructureLayout getStructureLayout(long structureLayoutId) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
    }

    public DDMStructureLayout getStructureLayoutByStructureVersionId(long structureVersionId) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByStructureVersionId(structureVersionId);
    }

    public DDMFormLayout getStructureLayoutDDMFormLayout(DDMStructureLayout structureLayout) {
        DDMFormLayoutDeserializer ddmFormLayoutDeserializer = this.ddmFormLayoutDeserializerTracker.getDDMFormLayoutDeserializer("json");
        DDMFormLayoutDeserializerDeserializeRequest.Builder builder = DDMFormLayoutDeserializerDeserializeRequest.Builder.newBuilder((String)structureLayout.getDefinition());
        DDMFormLayoutDeserializerDeserializeResponse ddmFormLayoutDeserializerDeserializeResponse = ddmFormLayoutDeserializer.deserialize(builder.build());
        return ddmFormLayoutDeserializerDeserializeResponse.getDDMFormLayout();
    }

    public List<DDMStructureLayout> getStructureLayouts(long groupId, int start, int end) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByGroupId(groupId, start, end);
    }

    public int getStructureLayoutsCount(long groupId) {
        return this.ddmStructureLayoutPersistence.countByGroupId(groupId);
    }

    public List<DDMStructureLayout> search(long companyId, long[] groupIds, long classNameId, String keywords, int start, int end, OrderByComparator<DDMStructureLayout> orderByComparator) throws PortalException {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureLayoutSearchContext(companyId, groupIds, classNameId, keywords, keywords, "", null, -1, start, end, orderByComparator);
        return this.ddmSearchHelper.doSearch(searchContext, DDMStructureLayout.class, arg_0 -> ((DDMStructureLayoutPersistence)this.ddmStructureLayoutPersistence).findByPrimaryKey(arg_0));
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords) throws PortalException {
        SearchContext searchContext = this.ddmSearchHelper.buildStructureLayoutSearchContext(companyId, groupIds, classNameId, keywords, keywords, "", null, -1, -1, -1, null);
        return this.ddmSearchHelper.doSearchCount(searchContext, DDMStructureLayout.class);
    }

    public DDMStructureLayout updateStructureLayout(long structureLayoutId, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
        this.validate(ddmFormLayout);
        structureLayout.setDefinition(this.serialize(ddmFormLayout));
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMStructureLayout updateStructureLayout(long structureLayoutId, long structureVersionId, Map<Locale, String> name, Map<Locale, String> description, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
        structureLayout.setModifiedDate(new Date());
        structureLayout.setStructureVersionId(structureVersionId);
        structureLayout.setNameMap(name);
        structureLayout.setDescriptionMap(description);
        structureLayout.setDefinition(definition);
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    protected String serialize(DDMFormLayout ddmFormLayout) {
        DDMFormLayoutSerializer ddmFormLayoutSerializer = this.ddmFormLayoutSerializerTracker.getDDMFormLayoutSerializer("json");
        DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
        DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = ddmFormLayoutSerializer.serialize(builder.build());
        return ddmFormLayoutSerializerSerializeResponse.getContent();
    }

    protected void validate(DDMFormLayout ddmFormLayout) throws PortalException {
        this.ddmFormLayoutValidator.validate(ddmFormLayout);
    }
}

