/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.io.DDMFormDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DDMFormTemplateSynchonizer {
    private final DDMFormDeserializer _ddmFormDeserializer;
    private final DDMFormSerializer _ddmFormSerializer;
    private List<DDMTemplate> _ddmFormTemplates = new ArrayList<DDMTemplate>();
    private final DDMTemplateLocalService _ddmTemplateLocalService;
    private final DDMForm _structureDDMForm;

    public DDMFormTemplateSynchonizer(DDMForm structureDDMForm, DDMFormDeserializer ddmFormDeserializer, DDMFormSerializer ddmFormSerializer, DDMTemplateLocalService ddmTemplateLocalService) {
        this._structureDDMForm = structureDDMForm;
        this._ddmFormDeserializer = ddmFormDeserializer;
        this._ddmFormSerializer = ddmFormSerializer;
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    public void setDDMFormTemplates(List<DDMTemplate> ddmFormTemplates) {
        this._ddmFormTemplates = ddmFormTemplates;
    }

    public void synchronize() throws PortalException {
        for (DDMTemplate ddmTemplate : this.getDDMFormTemplates()) {
            DDMForm templateDDMForm = this.deserialize(ddmTemplate.getScript());
            this.synchronizeDDMFormFields(this._structureDDMForm.getDDMFormFieldsMap(true), templateDDMForm.getDDMFormFields(), ddmTemplate.getMode());
            String mode = ddmTemplate.getMode();
            if (mode.equals("create")) {
                this.addRequiredDDMFormFields(this._structureDDMForm.getDDMFormFields(), templateDDMForm.getDDMFormFields());
            }
            this.updateDDMTemplate(ddmTemplate, templateDDMForm);
        }
    }

    protected void addRequiredDDMFormFields(List<DDMFormField> structureDDMFormFields, List<DDMFormField> templateDDMFormFields) {
        for (DDMFormField structureDDMFormField : structureDDMFormFields) {
            DDMFormField templateDDMFormField = this.getDDMFormField(templateDDMFormFields, structureDDMFormField.getName());
            if (templateDDMFormField == null) {
                if (!structureDDMFormField.isRequired()) continue;
                templateDDMFormFields.add(structureDDMFormField);
                continue;
            }
            this.addRequiredDDMFormFields(structureDDMFormField.getNestedDDMFormFields(), templateDDMFormField.getNestedDDMFormFields());
        }
    }

    protected DDMForm deserialize(String content) {
        DDMFormDeserializerDeserializeRequest.Builder builder = DDMFormDeserializerDeserializeRequest.Builder.newBuilder((String)content);
        DDMFormDeserializerDeserializeResponse ddmFormDeserializerDeserializeResponse = this._ddmFormDeserializer.deserialize(builder.build());
        return ddmFormDeserializerDeserializeResponse.getDDMForm();
    }

    protected DDMFormField getDDMFormField(List<DDMFormField> ddmFormFields, String name) {
        LinkedList<DDMFormField> queue = new LinkedList<DDMFormField>(ddmFormFields);
        DDMFormField ddmFormField = null;
        while ((ddmFormField = (DDMFormField)queue.poll()) != null) {
            if (name.equals(ddmFormField.getName())) {
                return ddmFormField;
            }
            queue.addAll(ddmFormField.getNestedDDMFormFields());
        }
        return null;
    }

    protected List<DDMTemplate> getDDMFormTemplates() {
        return this._ddmFormTemplates;
    }

    protected String serialize(DDMForm ddmForm) {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }

    protected void synchronizeDDMFormFieldOptions(DDMFormField structureDDMFormField, DDMFormField templateDDMFormField) {
        if (structureDDMFormField == null) {
            return;
        }
        String fieldType = structureDDMFormField.getType();
        if (fieldType.equals("select") || fieldType.equals("radio")) {
            templateDDMFormField.setDDMFormFieldOptions(structureDDMFormField.getDDMFormFieldOptions());
        }
    }

    protected void synchronizeDDMFormFieldRequiredProperty(DDMFormField structureDDMFormField, DDMFormField templateDDMFormField, String templateMode) {
        if (structureDDMFormField == null) {
            return;
        }
        if (!templateMode.equals("create")) {
            return;
        }
        templateDDMFormField.setRequired(structureDDMFormField.isRequired());
    }

    protected void synchronizeDDMFormFields(Map<String, DDMFormField> structureDDMFormFieldsMap, List<DDMFormField> templateDDMFormFields, String templateMode) {
        Iterator<DDMFormField> itr = templateDDMFormFields.iterator();
        while (itr.hasNext()) {
            DDMFormField templateDDMFormField = itr.next();
            String dataType = templateDDMFormField.getDataType();
            String name = templateDDMFormField.getName();
            if (Validator.isNotNull((String)dataType) && !structureDDMFormFieldsMap.containsKey(name)) {
                itr.remove();
                continue;
            }
            this.synchronizeDDMFormFieldOptions(structureDDMFormFieldsMap.get(name), templateDDMFormField);
            this.synchronizeDDMFormFieldRequiredProperty(structureDDMFormFieldsMap.get(name), templateDDMFormField, templateMode);
            this.synchronizeDDMFormFields(structureDDMFormFieldsMap, templateDDMFormField.getNestedDDMFormFields(), templateMode);
        }
    }

    protected void updateDDMTemplate(DDMTemplate ddmTemplate, DDMForm templateDDMForm) {
        String script = this.serialize(templateDDMForm);
        ddmTemplate.setScript(script);
        this._ddmTemplateLocalService.updateDDMTemplate(ddmTemplate);
    }
}

