/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.render.ValueAccessorException;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import java.util.Locale;

public abstract class BaseListDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    protected ValueAccessor getValueAcessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                JSONArray jsonArray = this.createJSONArray(value.getString(this.locale));
                if (jsonArray.length() == 0) {
                    return "";
                }
                StringBundler sb = new StringBundler(jsonArray.length() * 2);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    LocalizedValue label = this.getDDMFormFieldOptionLabel(ddmFormFieldValue, jsonArray.getString(i));
                    if (label == null) continue;
                    sb.append(label.getString(this.locale));
                    sb.append(", ");
                }
                if (sb.length() == 0) {
                    return "";
                }
                sb.setIndex(sb.index() - 1);
                return sb.toString();
            }

            protected JSONArray createJSONArray(String json) {
                try {
                    return JSONFactoryUtil.createJSONArray((String)json);
                }
                catch (JSONException jsone) {
                    throw new ValueAccessorException((Throwable)jsone);
                }
            }

            protected LocalizedValue getDDMFormFieldOptionLabel(DDMFormFieldValue ddmFormFieldValue, String optionValue) {
                DDMFormField ddmFormField = this.getDDMFormField(ddmFormFieldValue);
                DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
                return ddmFormFieldOptions.getOptionLabels(optionValue);
            }
        };
    }
}

