/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.verify;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMContent;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStorageLink;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLink;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.model.DDMTemplateLink;
import com.liferay.dynamic.data.mapping.service.DDMContentLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValuesValidator;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.verify.VerifyProcess;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"verify.process.name=com.liferay.dynamic.data.mapping.service"}, service={VerifyProcess.class})
public class DDMServiceVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(DDMServiceVerifyProcess.class);
    private DDMContentLocalService _ddmContentLocalService;
    private DDMFormLayoutValidator _ddmFormLayoutValidator;
    private DDMFormValidator _ddmFormValidator;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private DDMFormValuesValidator _ddmFormValuesValidator;
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    private DDMTemplateLinkLocalService _ddmTemplateLinkLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;

    protected void doVerify() throws Exception {
        this.verifyStructures();
        this.verifyStructureLinks();
        this.verifyTemplateLinks();
        this.verifyContents();
    }

    protected DDMFormValues getDDMFormValues(DDMForm ddmForm, DDMContent ddmContent) throws PortalException {
        return this._ddmFormValuesJSONDeserializer.deserialize(ddmForm, ddmContent.getData());
    }

    protected DDMFormValues getDDMFormValues(DDMStructure ddmStructure, DDMContent ddmContent) throws PortalException {
        return this.getDDMFormValues(ddmStructure.getDDMForm(), ddmContent);
    }

    @Reference(unbind="-")
    protected void setDDMContentLocalService(DDMContentLocalService ddmContentLocalService) {
        this._ddmContentLocalService = ddmContentLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMFormLayoutValidator(DDMFormLayoutValidator ddmFormLayoutValidator) {
        this._ddmFormLayoutValidator = ddmFormLayoutValidator;
    }

    @Reference(unbind="-")
    protected void setDDMFormValidator(DDMFormValidator ddmFormValidator) {
        this._ddmFormValidator = ddmFormValidator;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesValidator(DDMFormValuesValidator ddmFormValuesValidator) {
        this._ddmFormValuesValidator = ddmFormValuesValidator;
    }

    @Reference(unbind="-")
    protected void setDDMStorageLinkLocalService(DDMStorageLinkLocalService ddmStorageLinkLocalService) {
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLinkLocalService(DDMStructureLinkLocalService ddmStructureLinkLocalService) {
        this._ddmStructureLinkLocalService = ddmStructureLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureVersionLocalService(DDMStructureVersionLocalService ddmStructureVersionLocalService) {
        this._ddmStructureVersionLocalService = ddmStructureVersionLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLinkLocalService(DDMTemplateLinkLocalService ddmTemplateLinkLocalService) {
        this._ddmTemplateLinkLocalService = ddmTemplateLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    protected void verifyContent(DDMContent ddmContent) throws PortalException {
        block2: {
            DDMStorageLink ddmStorageLink = this._ddmStorageLinkLocalService.getClassStorageLink(ddmContent.getContentId());
            DDMStructureVersion ddmStructureVersion = this._ddmStructureVersionLocalService.getStructureVersion(ddmStorageLink.getStructureVersionId());
            try {
                DDMFormValues ddmFormValues = this.getDDMFormValues(ddmStructureVersion.getDDMForm(), ddmContent);
                this._ddmFormValuesValidator.validate(ddmFormValues);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)String.format("Stale or invalid data for DDM content %d  and structure version %d causes: {%s}", ddmContent.getContentId(), ddmStructureVersion.getStructureId(), e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void verifyContents() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmContentLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(object -> {
                DDMContent ddmContent = (DDMContent)object;
                this.verifyContent(ddmContent);
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void verifyDDMForm(DDMForm ddmForm) throws PortalException {
        this._ddmFormValidator.validate(ddmForm);
    }

    protected void verifyDDMFormLayout(DDMFormLayout ddmFormLayout) throws PortalException {
        this._ddmFormLayoutValidator.validate(ddmFormLayout);
    }

    protected void verifyStructure(DDMStructure ddmStructure) throws PortalException {
        this.verifyDDMForm(ddmStructure.getDDMForm());
        this.verifyDDMFormLayout(ddmStructure.getDDMFormLayout());
    }

    protected void verifyStructureLink(DDMStructureLink ddmStructureLink) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(ddmStructureLink.getStructureId());
        if (ddmStructure == null) {
            this._ddmStructureLinkLocalService.deleteStructureLink(ddmStructureLink.getStructureLinkId());
        }
    }

    protected void verifyStructureLinks() throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmStructureLinkLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(object -> {
                DDMStructureLink ddmStructureLink = (DDMStructureLink)object;
                this.verifyStructureLink(ddmStructureLink);
            });
        }
    }

    protected void verifyStructures() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmStructureLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(object -> {
                DDMStructure ddmStructure = (DDMStructure)object;
                try {
                    this.verifyStructure(ddmStructure);
                }
                catch (PortalException pe) {
                    _log.error((Object)String.format("Invalid data for DDM structure %d causes: {%s}", ddmStructure.getStructureId(), pe.getMessage()), (Throwable)pe);
                }
            });
            actionableDynamicQuery.performActions();
        }
    }

    protected void verifyTemplateLink(DDMTemplateLink ddmTemplateLink) throws PortalException {
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(ddmTemplateLink.getTemplateId());
        if (ddmTemplate == null) {
            this._ddmTemplateLinkLocalService.deleteTemplateLink(ddmTemplateLink.getTemplateId());
        }
    }

    protected void verifyTemplateLinks() throws PortalException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._ddmTemplateLinkLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setPerformActionMethod(object -> {
                DDMTemplateLink ddmTemplateLink = (DDMTemplateLink)object;
                this.verifyTemplateLink(ddmTemplateLink);
            });
        }
    }
}

