/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage.impl;

import com.liferay.dynamic.data.mapping.storage.BaseFieldRenderer;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class DateFieldRenderer
extends BaseFieldRenderer {
    private static final Log _log = LogFactoryUtil.getLog(DateFieldRenderer.class);

    protected String doRender(Field field, Locale locale) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            if (Validator.isNull((Object)value)) continue;
            values.add(this._format(value, locale));
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        return this._format(value, locale);
    }

    private String _format(Serializable value, Locale locale) {
        try {
            return DateUtil.formatDate((String)"yyyy-MM-dd", (String)value.toString(), (Locale)locale);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return LanguageUtil.format((Locale)locale, (String)"is-temporarily-unavailable", (Object)"content");
        }
    }
}

