/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.exception.FormInstanceRecordGroupIdException;
import com.liferay.dynamic.data.mapping.exception.NoSuchFormInstanceRecordException;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.internal.notification.DDMFormEmailNotificationSender;
import com.liferay.dynamic.data.mapping.internal.storage.StorageEngineAccessor;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.service.base.DDMFormInstanceRecordLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;

public class DDMFormInstanceRecordLocalServiceImpl
extends DDMFormInstanceRecordLocalServiceBaseImpl {
    @ServiceReference(type=DDMFormEmailNotificationSender.class)
    protected DDMFormEmailNotificationSender ddmFormEmailNotificationSender;
    @ServiceReference(type=IndexerRegistry.class)
    protected IndexerRegistry indexerRegistry;
    @ServiceReference(type=StorageEngineAccessor.class)
    protected StorageEngineAccessor storageEngineAccessor;
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"companyId", "entryClassPK", "uid"};
    private static final String _VERSION_DEFAULT = "1.0";
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordLocalServiceImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public DDMFormInstanceRecord addFormInstanceRecord(long userId, long groupId, long ddmFormInstanceId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDMFormInstance ddmFormInstance = this.ddmFormInstancePersistence.findByPrimaryKey(ddmFormInstanceId);
        this.validate(groupId, ddmFormInstance);
        long recordId = this.counterLocalService.increment();
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordPersistence.create(recordId);
        ddmFormInstanceRecord.setUuid(serviceContext.getUuid());
        ddmFormInstanceRecord.setGroupId(groupId);
        ddmFormInstanceRecord.setCompanyId(user.getCompanyId());
        ddmFormInstanceRecord.setUserId(user.getUserId());
        ddmFormInstanceRecord.setUserName(user.getFullName());
        ddmFormInstanceRecord.setVersionUserId(user.getUserId());
        ddmFormInstanceRecord.setVersionUserName(user.getFullName());
        StorageEngine storageEngine = this.storageEngineAccessor.getStorageEngine();
        long ddmStorageId = storageEngine.create(ddmFormInstance.getCompanyId(), ddmFormInstance.getStructureId(), ddmFormValues, serviceContext);
        ddmFormInstanceRecord.setStorageId(ddmStorageId);
        ddmFormInstanceRecord.setFormInstanceId(ddmFormInstanceId);
        ddmFormInstanceRecord.setFormInstanceVersion(ddmFormInstance.getVersion());
        ddmFormInstanceRecord.setVersion(_VERSION_DEFAULT);
        this.ddmFormInstanceRecordPersistence.update((BaseModel)ddmFormInstanceRecord);
        int status = GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)2);
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this.addFormInstanceRecordVersion(user, ddmFormInstanceRecord, ddmStorageId, status, _VERSION_DEFAULT);
        Locale locale = serviceContext.getLocale();
        this.updateAsset(userId, ddmFormInstanceRecord, ddmFormInstanceRecordVersion, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), locale, serviceContext.getAssetPriority());
        if (serviceContext.getWorkflowAction() == 1) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)DDMFormInstanceRecord.class.getName(), (long)ddmFormInstanceRecordVersion.getFormInstanceRecordVersionId(), (Object)ddmFormInstanceRecordVersion, (ServiceContext)serviceContext);
            if (this.isEmailNotificationEnabled(ddmFormInstance)) {
                this.ddmFormEmailNotificationSender.sendEmailNotification(serviceContext, ddmFormInstanceRecord);
            }
        }
        return ddmFormInstanceRecord;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public DDMFormInstanceRecord deleteFormInstanceRecord(DDMFormInstanceRecord ddmFormInstanceRecord) throws PortalException {
        this.ddmFormInstanceRecordPersistence.remove((BaseModel)ddmFormInstanceRecord);
        List ddmFormInstanceRecordVersions = this.ddmFormInstanceRecordVersionPersistence.findByFormInstanceRecordId(ddmFormInstanceRecord.getFormInstanceRecordId());
        StorageEngine storageEngine = this.storageEngineAccessor.getStorageEngine();
        for (DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion : ddmFormInstanceRecordVersions) {
            this.ddmFormInstanceRecordVersionPersistence.remove((BaseModel)ddmFormInstanceRecordVersion);
            storageEngine.deleteByClass(ddmFormInstanceRecordVersion.getStorageId());
            this.deleteWorkflowInstanceLink(ddmFormInstanceRecord.getCompanyId(), ddmFormInstanceRecord.getGroupId(), ddmFormInstanceRecordVersion.getPrimaryKey());
        }
        this.assetEntryLocalService.deleteEntry(DDMFormInstanceRecord.class.getName(), ddmFormInstanceRecord.getFormInstanceRecordId());
        return ddmFormInstanceRecord;
    }

    @Indexable(type=IndexableType.DELETE)
    public DDMFormInstanceRecord deleteFormInstanceRecord(long ddmFormInstanceRecordId) throws PortalException {
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordPersistence.findByPrimaryKey(ddmFormInstanceRecordId);
        return this.ddmFormInstanceRecordLocalService.deleteFormInstanceRecord(ddmFormInstanceRecord);
    }

    public void deleteFormInstanceRecords(long ddmFormInstanceId) throws PortalException {
        List ddmFormInstanceRecords = this.ddmFormInstanceRecordPersistence.findByFormInstanceId(ddmFormInstanceId);
        for (DDMFormInstanceRecord ddmFormInstanceRecord : ddmFormInstanceRecords) {
            this.deleteFormInstanceRecord(ddmFormInstanceRecord);
        }
    }

    public DDMFormInstanceRecord fetchFormInstanceRecord(long ddmFormInstanceRecordId) {
        return this.ddmFormInstanceRecordPersistence.fetchByPrimaryKey(ddmFormInstanceRecordId);
    }

    public DDMFormValues getDDMFormValues(long ddmStorageId) throws StorageException {
        StorageEngine storageEngine = this.storageEngineAccessor.getStorageEngine();
        return storageEngine.getDDMFormValues(ddmStorageId);
    }

    public DDMFormInstanceRecord getFormInstanceRecord(long ddmFormInstanceRecordId) throws PortalException {
        return this.ddmFormInstanceRecordPersistence.findByPrimaryKey(ddmFormInstanceRecordId);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId) {
        return this.ddmFormInstanceRecordPersistence.findByFormInstanceId(ddmFormInstanceId);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId, int status, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) {
        return this.ddmFormInstanceRecordFinder.findByF_S(ddmFormInstanceId, status, start, end, orderByComparator);
    }

    public List<DDMFormInstanceRecord> getFormInstanceRecords(long ddmFormInstanceId, long userId, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) {
        return this.ddmFormInstanceRecordPersistence.findByU_F(userId, ddmFormInstanceId, start, end, orderByComparator);
    }

    public int getFormInstanceRecordsCount(long ddmFormInstanceId) {
        return this.ddmFormInstanceRecordPersistence.countByFormInstanceId(ddmFormInstanceId);
    }

    public int getFormInstanceRecordsCount(long ddmFormInstanceId, int status) {
        return this.ddmFormInstanceRecordFinder.countByF_S(ddmFormInstanceId, status);
    }

    public int getFormInstanceRecordsCount(long ddmFormInstanceId, long userId) {
        return this.ddmFormInstanceRecordPersistence.countByU_F(userId, ddmFormInstanceId);
    }

    public void revertFormInstanceRecord(long userId, long ddmFormInstanceRecordId, String version, ServiceContext serviceContext) throws PortalException {
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this.ddmFormInstanceRecordVersionLocalService.getFormInstanceRecordVersion(ddmFormInstanceRecordId, version);
        if (!ddmFormInstanceRecordVersion.isApproved()) {
            return;
        }
        StorageEngine storageEngine = this.storageEngineAccessor.getStorageEngine();
        DDMFormValues ddmFormValues = storageEngine.getDDMFormValues(ddmFormInstanceRecordVersion.getStorageId());
        serviceContext.setCommand("revert");
        this.updateFormInstanceRecord(userId, ddmFormInstanceRecordId, true, ddmFormValues, serviceContext);
    }

    public BaseModelSearchResult<DDMFormInstanceRecord> searchFormInstanceRecords(SearchContext searchContext) {
        try {
            Indexer<DDMFormInstanceRecord> indexer = this.getDDMFormInstanceRecordIndexer();
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<DDMFormInstanceRecord> formInstanceRecords = this.getFormInstanceRecords(hits);
            return new BaseModelSearchResult(formInstanceRecords, hits.getLength());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMFormInstanceRecord updateFormInstanceRecord(long userId, long ddmFormInstanceRecordId, boolean majorVersion, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordPersistence.findByPrimaryKey(ddmFormInstanceRecordId);
        ddmFormInstanceRecord.setModifiedDate(serviceContext.getModifiedDate(null));
        ddmFormInstanceRecord = (DDMFormInstanceRecord)this.ddmFormInstanceRecordPersistence.update((BaseModel)ddmFormInstanceRecord);
        StorageEngine storageEngine = this.storageEngineAccessor.getStorageEngine();
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = ddmFormInstanceRecord.getLatestFormInstanceRecordVersion();
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecord.getFormInstance();
        if (ddmFormInstanceRecordVersion.isApproved()) {
            long ddmStorageId = storageEngine.create(ddmFormInstance.getCompanyId(), ddmFormInstance.getStructureId(), ddmFormValues, serviceContext);
            String version = this.getNextVersion(ddmFormInstanceRecordVersion.getVersion(), majorVersion, serviceContext.getWorkflowAction());
            ddmFormInstanceRecordVersion = this.addFormInstanceRecordVersion(user, ddmFormInstanceRecord, ddmStorageId, 2, version);
        } else {
            storageEngine.update(ddmFormInstanceRecordVersion.getStorageId(), ddmFormValues, serviceContext);
            String version = ddmFormInstanceRecordVersion.getVersion();
            this.updateFormInstanceRecordVersion(user, ddmFormInstanceRecordVersion, ddmFormInstanceRecordVersion.getStatus(), version, serviceContext);
        }
        if (this.isKeepFormInstanceRecordVersionLabel(ddmFormInstanceRecord.getFormInstanceRecordVersion(), ddmFormInstanceRecordVersion, serviceContext)) {
            this.ddmFormInstanceRecordVersionPersistence.remove((BaseModel)ddmFormInstanceRecordVersion);
            storageEngine.deleteByClass(ddmFormInstanceRecordVersion.getStorageId());
            return ddmFormInstanceRecord;
        }
        if (serviceContext.getWorkflowAction() == 1) {
            WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)ddmFormInstanceRecord.getGroupId(), (long)userId, (String)DDMFormInstanceRecord.class.getName(), (long)ddmFormInstanceRecordVersion.getFormInstanceRecordVersionId(), (Object)ddmFormInstanceRecordVersion, (ServiceContext)serviceContext);
            if (this.isEmailNotificationEnabled(ddmFormInstance)) {
                this.ddmFormEmailNotificationSender.sendEmailNotification(serviceContext, ddmFormInstanceRecord);
            }
        }
        return ddmFormInstanceRecord;
    }

    @Indexable(type=IndexableType.REINDEX)
    public DDMFormInstanceRecord updateStatus(long userId, long recordVersionId, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        DDMFormInstanceRecordVersion formInstanceRecordVersion = this.ddmFormInstanceRecordVersionPersistence.findByPrimaryKey(recordVersionId);
        formInstanceRecordVersion.setStatus(status);
        formInstanceRecordVersion.setStatusByUserId(user.getUserId());
        formInstanceRecordVersion.setStatusByUserName(user.getFullName());
        formInstanceRecordVersion.setStatusDate(new Date());
        this.ddmFormInstanceRecordVersionPersistence.update((BaseModel)formInstanceRecordVersion);
        DDMFormInstanceRecord formInstanceRecord = this.ddmFormInstanceRecordPersistence.findByPrimaryKey(formInstanceRecordVersion.getFormInstanceRecordId());
        if (status == 0) {
            if (DLUtil.compareVersions((String)formInstanceRecord.getVersion(), (String)formInstanceRecordVersion.getVersion()) <= 0) {
                formInstanceRecord.setVersionUserId(formInstanceRecordVersion.getUserId());
                formInstanceRecord.setVersionUserName(formInstanceRecordVersion.getUserName());
                formInstanceRecord.setFormInstanceId(formInstanceRecordVersion.getFormInstanceId());
                formInstanceRecord.setStorageId(formInstanceRecordVersion.getStorageId());
                formInstanceRecord.setVersion(formInstanceRecordVersion.getVersion());
                formInstanceRecord.setVersion(formInstanceRecordVersion.getVersion());
                this.ddmFormInstanceRecordPersistence.update((BaseModel)formInstanceRecord);
            }
        } else if (Objects.equals(formInstanceRecord.getVersion(), formInstanceRecordVersion.getVersion())) {
            String newVersion = _VERSION_DEFAULT;
            List approvedRecordVersions = this.ddmFormInstanceRecordVersionPersistence.findByF_S(formInstanceRecord.getFormInstanceRecordId(), 0);
            if (!approvedRecordVersions.isEmpty()) {
                DDMFormInstanceRecordVersion firstApprovedVersion = (DDMFormInstanceRecordVersion)approvedRecordVersions.get(0);
                newVersion = firstApprovedVersion.getVersion();
            }
            formInstanceRecord.setVersion(newVersion);
            this.ddmFormInstanceRecordPersistence.update((BaseModel)formInstanceRecord);
        }
        return formInstanceRecord;
    }

    protected DDMFormInstanceRecordVersion addFormInstanceRecordVersion(User user, DDMFormInstanceRecord ddmFormInstanceRecord, long ddmStorageId, int status, String version) {
        long ddmFormInstanceRecordVersionId = this.counterLocalService.increment();
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this.ddmFormInstanceRecordVersionPersistence.create(ddmFormInstanceRecordVersionId);
        ddmFormInstanceRecordVersion.setGroupId(ddmFormInstanceRecord.getGroupId());
        ddmFormInstanceRecordVersion.setCompanyId(ddmFormInstanceRecord.getCompanyId());
        ddmFormInstanceRecordVersion.setUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setCreateDate(ddmFormInstanceRecord.getModifiedDate());
        ddmFormInstanceRecordVersion.setFormInstanceId(ddmFormInstanceRecord.getFormInstanceId());
        ddmFormInstanceRecordVersion.setFormInstanceVersion(ddmFormInstanceRecord.getFormInstanceVersion());
        ddmFormInstanceRecordVersion.setFormInstanceRecordId(ddmFormInstanceRecord.getFormInstanceRecordId());
        ddmFormInstanceRecordVersion.setVersion(version);
        ddmFormInstanceRecordVersion.setStatus(status);
        ddmFormInstanceRecordVersion.setStatusByUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setStatusByUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setStatusDate(ddmFormInstanceRecord.getModifiedDate());
        ddmFormInstanceRecordVersion.setStorageId(ddmStorageId);
        this.ddmFormInstanceRecordVersionPersistence.update((BaseModel)ddmFormInstanceRecordVersion);
        return ddmFormInstanceRecordVersion;
    }

    protected void deleteWorkflowInstanceLink(long companyId, long groupId, long ddmFormInstanceRecordVersionId) throws PortalException {
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(companyId, groupId, DDMFormInstanceRecord.class.getName(), ddmFormInstanceRecordVersionId);
    }

    protected Indexer<DDMFormInstanceRecord> getDDMFormInstanceRecordIndexer() {
        Indexer indexer = this.indexerRegistry.nullSafeGetIndexer(DDMFormInstanceRecord.class);
        return indexer;
    }

    protected List<DDMFormInstanceRecord> getFormInstanceRecords(Hits hits) throws PortalException {
        ArrayList<DDMFormInstanceRecord> formInstanceRecords = new ArrayList<DDMFormInstanceRecord>();
        for (Document document : hits.toList()) {
            long recordId = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                DDMFormInstanceRecord formInstanceRecord = this.getFormInstanceRecord(recordId);
                formInstanceRecords.add(formInstanceRecord);
            }
            catch (NoSuchFormInstanceRecordException nsfire) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("DDM form instance record index is stale andcontains record " + recordId), (Throwable)nsfire);
                }
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                Indexer<DDMFormInstanceRecord> indexer = this.getDDMFormInstanceRecordIndexer();
                indexer.delete(companyId, document.getUID());
            }
        }
        return formInstanceRecords;
    }

    protected String getNextVersion(String version, boolean majorVersion, int workflowAction) {
        if (workflowAction == 2) {
            majorVersion = false;
        }
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        if (majorVersion) {
            versionParts[0] = versionParts[0] + 1;
            versionParts[1] = 0;
        } else {
            versionParts[1] = versionParts[1] + 1;
        }
        return versionParts[0] + "." + versionParts[1];
    }

    protected ResourceBundle getResourceBundle(Locale defaultLocale) {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        return portalResourceBundleLoader.loadResourceBundle(defaultLocale);
    }

    protected boolean isEmailNotificationEnabled(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMFormInstanceSettings formInstanceSettings = ddmFormInstance.getSettingsModel();
        return formInstanceSettings.sendEmailNotification();
    }

    protected boolean isKeepFormInstanceRecordVersionLabel(DDMFormInstanceRecordVersion lastDDMFormInstanceRecordVersion, DDMFormInstanceRecordVersion latestDDMFormInstanceRecordVersion, ServiceContext serviceContext) throws PortalException {
        Map latestAttributes;
        DDMFormValues latestDDMFormValues;
        if (Objects.equals(serviceContext.getCommand(), "revert")) {
            return false;
        }
        if (serviceContext.getWorkflowAction() == 2) {
            return false;
        }
        if (Objects.equals(lastDDMFormInstanceRecordVersion.getVersion(), latestDDMFormInstanceRecordVersion.getVersion())) {
            return false;
        }
        StorageEngine storageEngine = this.storageEngineAccessor.getStorageEngine();
        DDMFormValues lastDDMFormValues = storageEngine.getDDMFormValues(lastDDMFormInstanceRecordVersion.getStorageId());
        if (!lastDDMFormValues.equals((Object)(latestDDMFormValues = storageEngine.getDDMFormValues(latestDDMFormInstanceRecordVersion.getStorageId())))) {
            return false;
        }
        ExpandoBridge lastExpandoBridge = lastDDMFormInstanceRecordVersion.getExpandoBridge();
        ExpandoBridge latestExpandoBridge = latestDDMFormInstanceRecordVersion.getExpandoBridge();
        Map lastAttributes = lastExpandoBridge.getAttributes();
        return lastAttributes.equals(latestAttributes = latestExpandoBridge.getAttributes());
    }

    protected void updateAsset(long userId, DDMFormInstanceRecord formInstanceRecord, DDMFormInstanceRecordVersion formInstanceRecordVersion, long[] assetCategoryIds, String[] assetTagNames, Locale locale, Double priority) throws PortalException {
        int approvedRecordVersionsCount;
        String version;
        boolean addDraftAssetEntry = false;
        if (formInstanceRecordVersion != null && !formInstanceRecordVersion.isApproved() && !(version = formInstanceRecordVersion.getVersion()).equals(_VERSION_DEFAULT) && (approvedRecordVersionsCount = this.ddmFormInstanceRecordVersionPersistence.countByF_S(formInstanceRecord.getFormInstanceRecordId(), 0)) > 0) {
            addDraftAssetEntry = true;
        }
        DDMFormInstance formInstance = formInstanceRecord.getFormInstance();
        String title = LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)"new-entry-for-form-x", (Object)formInstance.getName(locale), (boolean)false);
        if (addDraftAssetEntry) {
            this.assetEntryLocalService.updateEntry(userId, formInstanceRecord.getGroupId(), formInstanceRecord.getCreateDate(), formInstanceRecord.getModifiedDate(), DDMFormInstanceRecord.class.getName(), formInstanceRecordVersion.getFormInstanceRecordVersionId(), formInstanceRecord.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, null, null, "text/html", title, null, "", null, null, 0, 0, priority);
        } else {
            this.assetEntryLocalService.updateEntry(userId, formInstanceRecord.getGroupId(), formInstanceRecord.getCreateDate(), formInstanceRecord.getModifiedDate(), DDMFormInstanceRecord.class.getName(), formInstanceRecord.getFormInstanceRecordId(), formInstanceRecord.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, null, null, "text/html", title, null, "", null, null, 0, 0, priority);
        }
    }

    protected void updateFormInstanceRecordVersion(User user, DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, int status, String version, ServiceContext serviceContext) {
        ddmFormInstanceRecordVersion.setUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setVersion(version);
        ddmFormInstanceRecordVersion.setStatus(status);
        ddmFormInstanceRecordVersion.setStatusByUserId(user.getUserId());
        ddmFormInstanceRecordVersion.setStatusByUserName(user.getFullName());
        ddmFormInstanceRecordVersion.setStatusDate(serviceContext.getModifiedDate(null));
        this.ddmFormInstanceRecordVersionPersistence.update((BaseModel)ddmFormInstanceRecordVersion);
    }

    protected void validate(long groupId, DDMFormInstance ddmFormInstance) throws PortalException {
        if (ddmFormInstance.getGroupId() != groupId) {
            throw new FormInstanceRecordGroupIdException("Record group ID is not the same as the form instance group ID");
        }
    }
}

