/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.webdav;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.WebDAVException;
import java.io.InputStream;

public class DDMTemplateResourceImpl
extends BaseResourceImpl {
    private final DDMTemplate _template;

    public DDMTemplateResourceImpl(DDMTemplate template, String parentPath, String name) {
        super(parentPath, name, template.getName(template.getDefaultLanguageId()), template.getCreateDate(), template.getModifiedDate(), (long)template.getScript().getBytes().length);
        this.setModel(template);
        this.setClassName(DDMTemplate.class.getName());
        this.setPrimaryKey(template.getPrimaryKey());
        this._template = template;
    }

    public InputStream getContentAsStream() throws WebDAVException {
        try {
            String script = this._template.getScript();
            return new UnsyncByteArrayInputStream(script.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public String getContentType() {
        return "text/xml";
    }

    public boolean isCollection() {
        return false;
    }
}

