/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.util;

import com.liferay.dynamic.data.mapping.internal.util.DDMFieldsCounter;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={FieldsToDDMFormValuesConverter.class})
public class FieldsToDDMFormValuesConverterImpl
implements FieldsToDDMFormValuesConverter {
    public DDMFormValues convert(DDMStructure ddmStructure, Fields fields) throws PortalException {
        DDMForm ddmForm = ddmStructure.getFullHierarchyDDMForm();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        DDMFormValues ddmFormValues = this.createDDMFormValues(ddmForm, fields.getAvailableLocales(), fields.getDefaultLocale());
        DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
        for (String fieldName : this.getDDMFormFieldNames(ddmForm.getDDMFormFields())) {
            int repetitions = this.countDDMFieldRepetitions(ddmFormFieldsMap, fields, fieldName, null, -1);
            for (int i = 0; i < repetitions; ++i) {
                DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(fieldName);
                this.setDDMFormFieldValueProperties(ddmFormFieldValue, ddmFormFieldsMap, fields, ddmFieldsCounter);
                ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            }
        }
        return ddmFormValues;
    }

    protected int countDDMFieldRepetitions(Map<String, DDMFormField> ddmFormFieldsMap, Fields ddmFields, String fieldName, String parentFieldName, int parentOffset) throws PortalException {
        Field ddmFieldsDisplayField = ddmFields.get("_fieldsDisplay");
        if (ddmFieldsDisplayField == null) {
            if (ddmFields.contains(fieldName)) {
                return 1;
            }
            return 0;
        }
        String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(ddmFormFieldsMap, ddmFieldsDisplayField);
        int offset = -1;
        int repetitions = 0;
        for (String fieldDisplayName : ddmFieldsDisplayValues) {
            if (offset > parentOffset) break;
            if (fieldDisplayName.equals(parentFieldName)) {
                ++offset;
            }
            if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
            ++repetitions;
        }
        return repetitions;
    }

    protected DDMFormFieldValue createDDMFormFieldValue(String name) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setName(name);
        return ddmFormFieldValue;
    }

    protected DDMFormValues createDDMFormValues(DDMForm ddmForm, Set<Locale> availableLocales, Locale defaultLocale) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.setAvailableLocales(availableLocales);
        ddmFormValues.setDefaultLocale(defaultLocale);
        return ddmFormValues;
    }

    protected String getDDMFieldInstanceId(Fields ddmFields, String fieldName, int index) {
        String[] ddmFieldsDisplayValues;
        Field ddmFieldsDisplayField = ddmFields.get("_fieldsDisplay");
        if (ddmFieldsDisplayField == null) {
            return StringUtil.randomString();
        }
        String prefix = fieldName.concat("_INSTANCE_");
        for (String ddmFieldsDisplayValue : ddmFieldsDisplayValues = StringUtil.split((String)((String)((Object)ddmFieldsDisplayField.getValue())))) {
            if (!ddmFieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)ddmFieldsDisplayValue, (String)"_INSTANCE_");
        }
        return null;
    }

    protected String[] getDDMFieldsDisplayValues(Map<String, DDMFormField> ddmFormFieldsMap, Field ddmFieldsDisplayField) throws PortalException {
        try {
            String[] values;
            ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
            for (String value : values = this.splitFieldsDisplayValue(ddmFieldsDisplayField)) {
                String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
                if (!ddmFormFieldsMap.containsKey(fieldName)) continue;
                fieldsDisplayValues.add(fieldName);
            }
            return fieldsDisplayValues.toArray(new String[fieldsDisplayValues.size()]);
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    protected String getDDMFieldValueString(Field ddmField, Locale locale, int index) {
        Serializable fieldValue = ddmField.getValue(locale, index);
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            fieldValue = Long.valueOf(valueDate.getTime());
        }
        return String.valueOf(fieldValue);
    }

    protected List<String> getDDMFormFieldNames(List<DDMFormField> ddmFormFields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            fieldNames.add(ddmFormField.getName());
        }
        return fieldNames;
    }

    protected void setDDMFormFieldValueInstanceId(DDMFormFieldValue ddmFormFieldValue, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) {
        String name = ddmFormFieldValue.getName();
        String instanceId = this.getDDMFieldInstanceId(ddmFields, name, ddmFieldsCounter.get(name));
        ddmFormFieldValue.setInstanceId(instanceId);
    }

    protected void setDDMFormFieldValueLocalizedValue(DDMFormFieldValue ddmFormFieldValue, Field ddmField, int index) {
        LocalizedValue value = new LocalizedValue(ddmField.getDefaultLocale());
        for (Locale availableLocale : ddmField.getAvailableLocales()) {
            String valueString = this.getDDMFieldValueString(ddmField, availableLocale, index);
            value.addString(availableLocale, valueString);
        }
        ddmFormFieldValue.setValue((Value)value);
    }

    protected void setDDMFormFieldValueProperties(DDMFormFieldValue ddmFormFieldValue, Map<String, DDMFormField> ddmFormFieldsMap, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        this.setDDMFormFieldValueInstanceId(ddmFormFieldValue, ddmFields, ddmFieldsCounter);
        this.setNestedDDMFormFieldValues(ddmFormFieldValue, ddmFormFieldsMap, ddmFields, ddmFieldsCounter);
        this.setDDMFormFieldValueValues(ddmFormFieldValue, ddmFormFieldsMap, ddmFields, ddmFieldsCounter);
    }

    protected void setDDMFormFieldValueUnlocalizedValue(DDMFormFieldValue ddmFormFieldValue, Field ddmField, int index) {
        String valueString = this.getDDMFieldValueString(ddmField, ddmField.getDefaultLocale(), index);
        UnlocalizedValue value = new UnlocalizedValue(valueString);
        ddmFormFieldValue.setValue((Value)value);
    }

    protected void setDDMFormFieldValueValues(DDMFormFieldValue ddmFormFieldValue, Map<String, DDMFormField> ddmFormFieldMap, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        String fieldName = ddmFormFieldValue.getName();
        DDMFormField ddmFormField = ddmFormFieldMap.get(fieldName);
        if (Validator.isNotNull((String)ddmFormField.getDataType())) {
            if (ddmFormField.isLocalizable()) {
                this.setDDMFormFieldValueLocalizedValue(ddmFormFieldValue, ddmFields.get(fieldName), ddmFieldsCounter.get(fieldName));
            } else {
                this.setDDMFormFieldValueUnlocalizedValue(ddmFormFieldValue, ddmFields.get(fieldName), ddmFieldsCounter.get(fieldName));
            }
        }
        ddmFieldsCounter.incrementKey(fieldName);
    }

    protected void setNestedDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue, Map<String, DDMFormField> ddmFormFieldsMap, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        String fieldName = ddmFormFieldValue.getName();
        int parentOffset = ddmFieldsCounter.get(fieldName);
        DDMFormField parentDDMFormField = ddmFormFieldsMap.get(fieldName);
        List<String> nestedFieldNames = this.getDDMFormFieldNames(parentDDMFormField.getNestedDDMFormFields());
        for (String nestedFieldName : nestedFieldNames) {
            int repetitions = this.countDDMFieldRepetitions(ddmFormFieldsMap, ddmFields, nestedFieldName, fieldName, parentOffset);
            for (int i = 0; i < repetitions; ++i) {
                DDMFormFieldValue nestedDDMFormFieldValue = this.createDDMFormFieldValue(nestedFieldName);
                this.setDDMFormFieldValueProperties(nestedDDMFormFieldValue, ddmFormFieldsMap, ddmFields, ddmFieldsCounter);
                ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
            }
        }
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }
}

