/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_0;

import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldValueTransformer;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesTransformer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;

public class UpgradeCheckboxFieldToCheckboxMultipleField
extends UpgradeProcess {
    private static final int _SCOPE_FORMS = 2;
    private final DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private final DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private final DDMFormValuesJSONSerializer _ddmFormValuesJSONSerializer;
    private final JSONFactory _jsonFactory;

    public UpgradeCheckboxFieldToCheckboxMultipleField(DDMFormJSONDeserializer ddmFormJSONDeserializer, DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer, DDMFormValuesJSONSerializer ddmFormValuesJSONSerializer, JSONFactory jsonFactory) {
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
        this._ddmFormValuesJSONSerializer = ddmFormValuesJSONSerializer;
        this._jsonFactory = jsonFactory;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select DDMStructure.definition, DDLRecordSet.recordSetId, ");
        sb.append("DDMStructure.structureId from DDLRecordSet inner join ");
        sb.append("DDMStructure on DDLRecordSet.DDMStructureId = ");
        sb.append("DDMStructure.structureId where DDLRecordSet.scope = ? and ");
        sb.append("DDMStructure.definition like ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            ps1.setInt(1, 2);
            ps1.setString(2, "%checkbox%");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString(1);
                    long recordSetId = rs.getLong(2);
                    long structureId = rs.getLong(3);
                    String newDefinition = this.upgradeRecordSetStructureDefinition(definition);
                    ps2.setString(1, newDefinition);
                    ps2.setLong(2, structureId);
                    ps2.addBatch();
                    DDMForm ddmForm = this._ddmFormJSONDeserializer.deserialize(definition);
                    this.updateRecords(ddmForm, recordSetId);
                }
                ps2.executeBatch();
            }
        }
    }

    protected JSONArray getOptionsJSONArray(JSONObject checkboxFieldJSONObject) {
        JSONArray optionsJSONArray = this._jsonFactory.createJSONArray();
        JSONObject optionJSONObject = this._jsonFactory.createJSONObject();
        optionJSONObject.put("label", checkboxFieldJSONObject.getJSONObject("label"));
        optionJSONObject.put("value", checkboxFieldJSONObject.getString("name"));
        optionsJSONArray.put(optionJSONObject);
        return optionsJSONArray;
    }

    protected JSONObject getPredefinedValue(JSONObject checkboxFieldJSONObject) {
        JSONObject oldPredefinedValueJSONObject = checkboxFieldJSONObject.getJSONObject("predefinedValue");
        JSONObject newPredefinedValueJSONObject = this._jsonFactory.createJSONObject();
        Iterator languageKeys = oldPredefinedValueJSONObject.keys();
        while (languageKeys.hasNext()) {
            String languageKey = (String)languageKeys.next();
            String predefinedValue = oldPredefinedValueJSONObject.getString(languageKey);
            predefinedValue = Objects.equals(predefinedValue, "true") ? checkboxFieldJSONObject.getString("name") : "";
            newPredefinedValueJSONObject.put(languageKey, predefinedValue);
        }
        return newPredefinedValueJSONObject;
    }

    protected void transformCheckboxDDMFormField(JSONObject checkboxFieldJSONObject) {
        checkboxFieldJSONObject.put("dataType", "string");
        checkboxFieldJSONObject.put("options", this.getOptionsJSONArray(checkboxFieldJSONObject));
        checkboxFieldJSONObject.put("predefinedValue", this.getPredefinedValue(checkboxFieldJSONObject));
        checkboxFieldJSONObject.put("type", "checkbox_multiple");
    }

    protected void transformCheckboxDDMFormFieldValues(DDMFormValues ddmFormValues) throws Exception {
        DDMFormValuesTransformer ddmFormValuesTransformer = new DDMFormValuesTransformer(ddmFormValues);
        ddmFormValuesTransformer.addTransformer((DDMFormFieldValueTransformer)new CheckboxDDMFormFieldValueTransformer(this._jsonFactory));
        ddmFormValuesTransformer.transform();
    }

    protected void updateRecords(DDMForm ddmForm, long recordSetId) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select DDLRecordVersion.DDMStorageId, DDMContent.data_ ");
        sb.append("from DDLRecordVersion inner join DDLRecordSet on ");
        sb.append("DDLRecordVersion.recordSetId = DDLRecordSet.recordSetId ");
        sb.append("inner join DDMContent on DDLRecordVersion.DDMStorageId = ");
        sb.append("DDMContent.contentId where DDLRecordSet.recordSetId = ? ");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMContent set data_ = ? where contentId = ? ");){
            ps1.setLong(1, recordSetId);
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String data_ = rs.getString("data_");
                    DDMFormValues ddmFormValues = this._ddmFormValuesJSONDeserializer.deserialize(ddmForm, data_);
                    this.transformCheckboxDDMFormFieldValues(ddmFormValues);
                    ps2.setString(1, this._ddmFormValuesJSONSerializer.serialize(ddmFormValues));
                    long contentId = rs.getLong("DDMStorageId");
                    ps2.setLong(2, contentId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    protected String upgradeRecordSetStructureDefinition(String definition) throws JSONException {
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(definition);
        JSONArray fieldsJSONArray = definitionJSONObject.getJSONArray("fields");
        this.upgradeRecordSetStructureFields(fieldsJSONArray);
        return definitionJSONObject.toString();
    }

    protected void upgradeRecordSetStructureFields(JSONArray fieldsJSONArray) {
        for (int i = 0; i < fieldsJSONArray.length(); ++i) {
            JSONArray nestedFieldsJSONArray;
            JSONObject fieldJSONObject = fieldsJSONArray.getJSONObject(i);
            String type = fieldJSONObject.getString("type");
            if (type.equals("checkbox")) {
                this.transformCheckboxDDMFormField(fieldJSONObject);
            }
            if ((nestedFieldsJSONArray = fieldJSONObject.getJSONArray("nestedFields")) == null) continue;
            this.upgradeRecordSetStructureFields(nestedFieldsJSONArray);
        }
    }

    private static class CheckboxDDMFormFieldValueTransformer
    implements DDMFormFieldValueTransformer {
        private JSONFactory _jsonFactory;

        public CheckboxDDMFormFieldValueTransformer(JSONFactory jsonFactory) {
            this._jsonFactory = jsonFactory;
        }

        public String getFieldType() {
            return "checkbox";
        }

        public void transform(DDMFormFieldValue ddmFormFieldValue) throws PortalException {
            Value value = ddmFormFieldValue.getValue();
            for (Locale locale : value.getAvailableLocales()) {
                String valueString = value.getString(locale);
                JSONArray valueJSONArray = this._jsonFactory.createJSONArray();
                if (Objects.equals(valueString, "true")) {
                    DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                    valueJSONArray.put(ddmFormField.getName());
                }
                value.addString(locale, valueJSONArray.toString());
            }
        }
    }
}

