/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.search;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class DDMFormInstanceRecordIndexer
extends BaseIndexer<DDMFormInstanceRecord> {
    public static final String CLASS_NAME = DDMFormInstanceRecord.class.getName();
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected DDMFormInstanceLocalService ddmFormInstanceLocalService;
    @Reference
    protected DDMFormInstanceRecordLocalService ddmFormInstanceRecordLocalService;
    @Reference
    protected DDMFormInstanceRecordVersionLocalService ddmFormInstanceRecordVersionLocalService;
    @Reference
    protected DDMIndexer ddmIndexer;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected SearchPermissionChecker searchPermissionChecker;
    @Reference
    protected StorageEngine storageEngine;
    private static final Log _log = LogFactoryUtil.getLog(DDMFormInstanceRecordIndexer.class);

    public DDMFormInstanceRecordIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"description", "title"});
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public BooleanFilter getFacetBooleanFilter(String className, SearchContext searchContext) throws Exception {
        BooleanFilter facetBooleanFilter = new BooleanFilter();
        facetBooleanFilter.addTerm("entryClassName", DDMFormInstanceRecord.class.getName());
        if (searchContext.getUserId() > 0L) {
            facetBooleanFilter = this.searchPermissionChecker.getPermissionBooleanFilter(searchContext.getCompanyId(), searchContext.getGroupIds(), searchContext.getUserId(), DDMFormInstance.class.getName(), facetBooleanFilter, searchContext);
        }
        return facetBooleanFilter;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long ddmFormInstanceId;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextBooleanFilter.addRequiredTerm("status", status);
        }
        if ((ddmFormInstanceId = GetterUtil.getLong((Object)searchContext.getAttribute("ddmFormInstanceId"))) > 0L) {
            contextBooleanFilter.addRequiredTerm("ddmFormInstanceId", ddmFormInstanceId);
        }
        this.addSearchClassTypeIds(contextBooleanFilter, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            QueryFilter queryFilter = this.ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, searchContext.getLocale());
            contextBooleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        this.addContentSearchTerm(searchQuery, searchContext);
    }

    protected void addContent(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, DDMFormValues ddmFormValues, Document document) throws Exception {
        Set locales = ddmFormValues.getAvailableLocales();
        for (Locale locale : locales) {
            StringBundler sb = new StringBundler(3);
            sb.append("ddmContent");
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
            document.addText(sb.toString(), this.extractContent(ddmFormInstanceRecordVersion, locale));
        }
    }

    protected void addContentSearchTerm(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        Locale locale = searchContext.getLocale();
        StringBundler sb = new StringBundler(3);
        sb.append("ddmContent");
        sb.append("_");
        sb.append(LocaleUtil.toLanguageId((Locale)locale));
        this.addSearchTerm(searchQuery, searchContext, sb.toString(), false);
    }

    protected void doDelete(DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        this.deleteDocument(ddmFormInstanceRecord.getCompanyId(), ddmFormInstanceRecord.getFormInstanceRecordId());
    }

    protected Document doGetDocument(DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)ddmFormInstanceRecord);
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = ddmFormInstanceRecord.getFormInstanceRecordVersion();
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecordVersion.getFormInstance();
        document.addKeyword("classNameId", this.classNameLocalService.getClassNameId(DDMFormInstance.class));
        document.addKeyword("classPK", ddmFormInstance.getFormInstanceId());
        document.addKeyword("classTypeId", ddmFormInstanceRecordVersion.getFormInstanceId());
        document.addKeyword("relatedEntry", true);
        document.addKeyword("status", ddmFormInstanceRecordVersion.getStatus());
        document.addKeyword("version", ddmFormInstanceRecordVersion.getVersion());
        document.addKeyword("formInstanceId", ddmFormInstance.getFormInstanceId());
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMFormValues ddmFormValues = this.storageEngine.getDDMFormValues(ddmFormInstanceRecordVersion.getStorageId());
        this.addContent(ddmFormInstanceRecordVersion, ddmFormValues, document);
        this.ddmIndexer.addAttributes(document, ddmStructure, ddmFormValues);
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        long ddmFormInstanceId = GetterUtil.getLong((String)document.get("formInstanceId"));
        String title = this.getTitle(ddmFormInstanceId, locale);
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        summary.setTitle(title);
        return summary;
    }

    protected void doReindex(DDMFormInstanceRecord ddmFormInstanceRecord) throws Exception {
        Document document = this.getDocument(ddmFormInstanceRecord);
        this.indexWriterHelper.updateDocument(this.getSearchEngineId(), ddmFormInstanceRecord.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DDMFormInstanceRecord ddmFormInstanceRecord = this.ddmFormInstanceRecordLocalService.getFormInstanceRecord(classPK);
        this.doReindex(ddmFormInstanceRecord);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFormInstanceRecords(companyId);
    }

    protected String extractContent(DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion, Locale locale) throws Exception {
        DDMFormValues ddmFormValues = this.storageEngine.getDDMFormValues(ddmFormInstanceRecordVersion.getStorageId());
        if (ddmFormValues == null) {
            return "";
        }
        DDMFormInstance ddmFormInstance = ddmFormInstanceRecordVersion.getFormInstance();
        return this.ddmIndexer.extractIndexableAttributes(ddmFormInstance.getStructure(), ddmFormValues, locale);
    }

    protected ResourceBundle getResourceBundle(Locale defaultLocale) {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        return portalResourceBundleLoader.loadResourceBundle(defaultLocale);
    }

    protected String getTitle(long ddmFormInstanceId, Locale locale) {
        try {
            DDMFormInstance ddmFormInstance = this.ddmFormInstanceLocalService.getFormInstance(ddmFormInstanceId);
            String ddmFormInstanceName = ddmFormInstance.getName(locale);
            return LanguageUtil.format((ResourceBundle)this.getResourceBundle(locale), (String)"new-entry-for-form-x", (Object)ddmFormInstanceName, (boolean)false);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return "";
        }
    }

    protected void reindexFormInstanceRecords(long companyId) throws Exception {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.ddmFormInstanceRecordLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property ddmFormInstanceRecordIdProperty = PropertyFactoryUtil.forName((String)"formInstanceRecordId");
            DynamicQuery ddmFormInstanceRecordVersionDynamicQuery = this.ddmFormInstanceRecordVersionLocalService.dynamicQuery();
            ddmFormInstanceRecordVersionDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"formInstanceRecordId"));
            dynamicQuery.add(ddmFormInstanceRecordIdProperty.in(ddmFormInstanceRecordVersionDynamicQuery));
            Property ddmFormInstanceProperty = PropertyFactoryUtil.forName((String)"formInstanceId");
            DynamicQuery ddmFormInstanceDynamicQuery = this.ddmFormInstanceLocalService.dynamicQuery();
            ddmFormInstanceDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"formInstanceId"));
            dynamicQuery.add(ddmFormInstanceProperty.in(ddmFormInstanceDynamicQuery));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(ddmFormInstanceRecord -> {
            block3: {
                try {
                    Document document = this.getDocument(ddmFormInstanceRecord);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index form instance record " + ddmFormInstanceRecord.getFormInstanceRecordId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

