/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.render;

import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.BaseDDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.ValueAccessor;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Locale;

public class DateDDMFormFieldValueRenderer
extends BaseDDMFormFieldValueRenderer {
    private static final Log _log = LogFactoryUtil.getLog(DateDDMFormFieldValueRenderer.class);

    public String getSupportedDDMFormFieldType() {
        return "ddm-date";
    }

    protected ValueAccessor getValueAcessor(Locale locale) {
        return new ValueAccessor(locale){

            public String get(DDMFormFieldValue ddmFormFieldValue) {
                Value value = ddmFormFieldValue.getValue();
                String valueString = value.getString(this.locale);
                if (Validator.isNull((String)valueString)) {
                    return "";
                }
                return DateDDMFormFieldValueRenderer.this._format((Serializable)((Object)valueString), this.locale);
            }
        };
    }

    private String _format(Serializable value, Locale locale) {
        try {
            return DateUtil.formatDate((String)"yyyy-MM-dd", (String)value.toString(), (Locale)locale);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return LanguageUtil.format((Locale)locale, (String)"is-temporarily-unavailable", (Object)"content");
        }
    }
}

