/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_2_1;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Objects;

public class UpgradeDDMFormInstance
extends UpgradeProcess {
    private static final int _SCOPE_FORMS = 2;
    private final ClassNameLocalService _classNameLocalService;
    private final CounterLocalService _counterLocalService;
    private final PortletPreferencesLocalService _portletPreferencesLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;

    public UpgradeDDMFormInstance(ClassNameLocalService classNameLocalService, CounterLocalService counterLocalService, PortletPreferencesLocalService portletPreferencesLocalService, ResourcePermissionLocalService resourcePermissionLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._counterLocalService = counterLocalService;
        this._portletPreferencesLocalService = portletPreferencesLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    /*
     * Exception decompiling
     */
    public long getLatestStructureVersionId(long ddmStructureId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void deleteDDLRecordSet(long ddmStructureId, long recordSetId) throws SQLException {
        this.deleteStructureStructureLinks(ddmStructureId);
        try (PreparedStatement ps = this.connection.prepareStatement("delete from DDLRecordSet where recordSetId = ?");){
            ps.setLong(1, recordSetId);
            ps.executeUpdate();
        }
    }

    protected void deleteStructureStructureLinks(long ddmStructureId) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("delete from DDMStructureLink where structureId = ?");){
            ps.setLong(1, ddmStructureId);
            ps.executeUpdate();
        }
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("insert into DDMFormInstance(uuid_, formInstanceId, ");
        sb.append("groupId, companyId, userId, userName, versionUserId, ");
        sb.append("versionUserName, createDate, modifiedDate, structureId, ");
        sb.append("version, name, description, settings_, lastPublishDate) ");
        sb.append("values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps1 = this.connection.prepareStatement("select DDLRecordSet.* from DDLRecordSet where DDLRecordSet.scope = 2");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());){
            while (rs.next()) {
                long recordSetId = rs.getLong("recordSetId");
                long structureId = rs.getLong("DDMStructureId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                String name = rs.getString("name");
                String description = rs.getString("description");
                String settings = rs.getString("settings_");
                Timestamp lastPublishDate = rs.getTimestamp("lastPublishDate");
                ps2.setString(1, PortalUUIDUtil.generate());
                ps2.setLong(2, recordSetId);
                ps2.setLong(3, groupId);
                ps2.setLong(4, companyId);
                ps2.setLong(5, userId);
                ps2.setString(6, userName);
                ps2.setLong(7, userId);
                ps2.setString(8, userName);
                ps2.setTimestamp(9, createDate);
                ps2.setTimestamp(10, rs.getTimestamp("modifiedDate"));
                ps2.setLong(11, structureId);
                ps2.setString(12, "1.0");
                ps2.setString(13, name);
                ps2.setString(14, description);
                ps2.setString(15, settings);
                ps2.setTimestamp(16, lastPublishDate);
                this.updateDDMStructure(structureId);
                this.updateDDMStructureLink(structureId);
                this.upgradeDDMFormInstanceVersion(groupId, companyId, userId, userName, createDate, recordSetId, structureId, name, description, settings, lastPublishDate);
                this.upgradeResourcePermission(recordSetId, "com.liferay.dynamic.data.mapping.model.DDMFormInstance", true);
                this.upgradeResourcePermission(structureId, "com.liferay.dynamic.data.mapping.model.DDMFormInstance-com.liferay.dynamic.data.mapping.model.DDMStructure", false);
                this.upgradeResourcePermission("com_liferay_dynamic_data_lists_form_web_portlet_DDLFormAdminPortlet", "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet");
                this.updateInstanceablePortletPreferences(recordSetId, "com_liferay_dynamic_data_lists_form_web_portlet_DDLFormPortlet", "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet");
                this.deleteDDLRecordSet(structureId, recordSetId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected long getNewActionIds(long oldActionIds) {
        long bit4 = oldActionIds >> 3 & 1L;
        long bit5 = oldActionIds >> 4 & 1L;
        if (bit4 == bit5) {
            return oldActionIds;
        }
        int mask = 24;
        return oldActionIds ^ (long)mask;
    }

    protected void updateDDMStructure(long ddmStructureId) throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("update DDMStructure set classNameId = ? where structureId ");
        sb.append("= ?");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setLong(1, this._classNameLocalService.getClassNameId(DDMFormInstance.class.getName()));
            ps.setLong(2, ddmStructureId);
            ps.executeUpdate();
        }
    }

    protected void updateDDMStructureLink(long ddmStructureId) throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("update DDMStructureLink set classNameId = ? where ");
        sb.append("structureId = ?");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setLong(1, this._classNameLocalService.getClassNameId(DDMFormInstance.class.getName()));
            ps.setLong(2, ddmStructureId);
            ps.executeUpdate();
        }
    }

    protected void updateInstanceablePortletPreferences(long recordSetId, String oldPortletId, String newPortletId) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._portletPreferencesLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Disjunction junction = RestrictionsFactoryUtil.disjunction();
            Property property = PropertyFactoryUtil.forName((String)"portletId");
            junction.add(property.eq((Object)oldPortletId));
            junction.add(property.like((Object)(oldPortletId + "_INSTANCE_%")));
            junction.add(property.like((Object)(oldPortletId + "_USER_%_INSTANCE_%")));
            dynamicQuery.add((Criterion)junction);
        });
        actionableDynamicQuery.setPerformActionMethod(portletPreference -> this.updatePortletPreferences(recordSetId, recordSetId, oldPortletId, newPortletId, (PortletPreferences)portletPreference));
        actionableDynamicQuery.performActions();
    }

    protected void updatePortletPreferences(long ddmFormInstanceId, long recordSetId, String oldPortletId, String newPortletId, PortletPreferences portletPreferences) {
        portletPreferences.setPortletId(StringUtil.replace((String)portletPreferences.getPortletId(), (String)oldPortletId, (String)newPortletId));
        String preferences = portletPreferences.getPreferences();
        preferences = StringUtil.replace((String)preferences, (String)String.valueOf(recordSetId), (String)String.valueOf(ddmFormInstanceId));
        portletPreferences.setPreferences(preferences);
        this._portletPreferencesLocalService.updatePortletPreferences(portletPreferences);
    }

    protected void upgradeDDMFormInstanceVersion(long groupId, long companyId, long userId, String userName, Timestamp createDate, long formInstanceId, long structureId, String name, String description, String settings, Timestamp statusDate) throws SQLException {
        StringBundler sb = new StringBundler(6);
        sb.append("insert into DDMFormInstanceVersion(formInstanceVersionId, ");
        sb.append("groupId, companyId, userId, userName, createDate, ");
        sb.append("formInstanceId, structureVersionId, name, description, ");
        sb.append("settings_, version, status, statusByUserId, ");
        sb.append("statusByUserName, statusDate) values(?, ?, ?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());){
            ps2.setLong(1, this._counterLocalService.increment());
            ps2.setLong(2, groupId);
            ps2.setLong(3, companyId);
            ps2.setLong(4, userId);
            ps2.setString(5, userName);
            ps2.setTimestamp(6, createDate);
            ps2.setLong(7, formInstanceId);
            ps2.setLong(8, this.getLatestStructureVersionId(structureId));
            ps2.setString(9, name);
            ps2.setString(10, description);
            ps2.setString(11, settings);
            ps2.setString(12, "1.0");
            ps2.setInt(13, 0);
            ps2.setLong(14, userId);
            ps2.setString(15, userName);
            ps2.setTimestamp(16, statusDate);
            ps2.execute();
        }
    }

    protected void upgradeResourcePermission(long primKeyId, String name, boolean updateActionIds) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property nameProperty = PropertyFactoryUtil.forName((String)"primKey");
            dynamicQuery.add(nameProperty.eq((Object)String.valueOf(primKeyId)));
        });
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            resourcePermission.setName(name);
            if (updateActionIds) {
                resourcePermission.setActionIds(this.getNewActionIds(resourcePermission.getActionIds()));
            }
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        });
        actionableDynamicQuery.performActions();
    }

    protected void upgradeResourcePermission(String oldName, String newName) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property nameProperty = PropertyFactoryUtil.forName((String)"name");
            dynamicQuery.add(nameProperty.eq((Object)oldName));
        });
        actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
            resourcePermission.setName(newName);
            if (Objects.equals(resourcePermission.getPrimKey(), oldName)) {
                resourcePermission.setPrimKey(newName);
            }
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        });
        actionableDynamicQuery.performActions();
    }
}

