/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_0;

import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;

public class UpgradeDDMStructure
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDDMStructure.class);
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private final DDMFormJSONSerializer _ddmFormJSONSerializer;

    public UpgradeDDMStructure(DDMExpressionFactory ddmExpressionFactory, DDMFormJSONDeserializer ddmFormJSONDeserializer, DDMFormJSONSerializer ddmFormJSONSerializer) {
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
        this._ddmFormJSONSerializer = ddmFormJSONSerializer;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeDDMStructureDefinition();
        this.upgradeDDMStructureVersionDefinition();
    }

    protected DDMFormRule getSetVisibleDDMFormRule(String ddmFormFieldName, String visibilityExpression) throws DDMExpressionException {
        try {
            DDMExpression ddmExpression = this._ddmExpressionFactory.createBooleanDDMExpression(visibilityExpression);
            Map variableDependencies = ddmExpression.getVariableDependenciesMap();
            String condition = visibilityExpression;
            for (String variable : variableDependencies.keySet()) {
                condition = StringUtil.replace((String)condition, (String[])new String[]{variable}, (String[])new String[]{"getValue(" + StringUtil.quote((String)variable) + ")"}, (boolean)true);
            }
            return new DDMFormRule(condition, new String[]{"setVisible('" + ddmFormFieldName + "', true)"});
        }
        catch (DDMExpressionException ddmee) {
            _log.error((Object)String.format("Unable to upgrade the visibility expression \"%s\" to a form rule", visibilityExpression), (Throwable)ddmee);
            throw ddmee;
        }
    }

    protected String updateDefinition(String definition) throws PortalException {
        DDMForm ddmForm = this._ddmFormJSONDeserializer.deserialize(definition);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        List ddmFormRules = ddmForm.getDDMFormRules();
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            String visibilityExpression = ddmFormField.getVisibilityExpression();
            if (Validator.isNull((String)visibilityExpression)) continue;
            DDMFormRule ddmFormRule = this.getSetVisibleDDMFormRule(ddmFormField.getName(), visibilityExpression);
            ddmFormRules.add(ddmFormRule);
            ddmFormField.setVisibilityExpression("");
        }
        ddmForm.setDDMFormRules(ddmFormRules);
        return this._ddmFormJSONSerializer.serialize(ddmForm);
    }

    protected void upgradeDDMStructureDefinition() throws Exception {
        StringBundler sb = new StringBundler(2);
        sb.append("select DDMStructure.definition, DDMStructure.structureId ");
        sb.append("from DDMStructure");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String definition = rs.getString(1);
                long structureId = rs.getLong(2);
                String newDefinition = this.updateDefinition(definition);
                ps2.setString(1, newDefinition);
                ps2.setLong(2, structureId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void upgradeDDMStructureVersionDefinition() throws Exception {
        StringBundler sb = new StringBundler(3);
        sb.append("select DDMStructureVersion.definition, ");
        sb.append("DDMStructureVersion.structureVersionId from ");
        sb.append("DDMStructureVersion");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructureVersion set definition = ? where structureVersionId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String definition = rs.getString(1);
                long structureVersionId = rs.getLong(2);
                String newDefinition = this.updateDefinition(definition);
                ps2.setString(1, newDefinition);
                ps2.setLong(2, structureVersionId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

