/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.exportimport.staged.model.repository.DDMFormInstanceRecordStagedModelRepository;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class DDMFormInstanceRecordStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMFormInstanceRecord> {
    public static final String[] CLASS_NAMES = new String[]{DDMFormInstanceRecord.class.getName()};
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    private DDMFormInstanceRecordStagedModelRepository _ddmFormInstanceRecordStagedModelRepository;
    private ExportImportContentProcessor<DDMFormValues> _ddmFormValuesExportImportContentProcessor;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private DDMFormValuesJSONSerializer _ddmFormValuesJSONSerializer;
    private StorageEngine _storageEngine;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMFormInstanceRecord record) {
        return record.getUuid();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord record) throws Exception {
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)record, (StagedModel)record.getFormInstance(), (String)"strong");
        Element recordElement = portletDataContext.getExportDataElement((ClassedModel)record);
        this.exportDDMFormValues(portletDataContext, record, recordElement);
        portletDataContext.addClassedModel(recordElement, ExportImportPathUtil.getModelPath((StagedModel)record), (ClassedModel)record);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long recordId) throws Exception {
        DDMFormInstanceRecord existingRecord = (DDMFormInstanceRecord)this.fetchMissingReference(uuid, groupId);
        Map recordIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstanceRecord.class);
        recordIds.put(recordId, existingRecord.getFormInstanceRecordId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMFormInstanceRecord record) throws Exception {
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstance.class);
        long ddmFormInstanceId = MapUtil.getLong((Map)recordSetIds, (long)record.getFormInstanceId(), (long)record.getFormInstanceId());
        Element recordElement = portletDataContext.getImportDataElement((StagedModel)record);
        DDMFormValues ddmFormValues = this.getImportDDMFormValues(portletDataContext, recordElement, ddmFormInstanceId);
        DDMFormInstanceRecord importedRecord = (DDMFormInstanceRecord)record.clone();
        importedRecord.setGroupId(portletDataContext.getScopeGroupId());
        importedRecord.setFormInstanceId(ddmFormInstanceId);
        DDMFormInstanceRecord existingRecord = this._ddmFormInstanceRecordStagedModelRepository.fetchStagedModelByUuidAndGroupId(record.getUuid(), portletDataContext.getScopeGroupId());
        if (existingRecord == null || !portletDataContext.isDataStrategyMirror()) {
            importedRecord = this._ddmFormInstanceRecordStagedModelRepository.addStagedModel(portletDataContext, importedRecord, ddmFormValues);
        } else {
            importedRecord.setFormInstanceRecordId(existingRecord.getFormInstanceRecordId());
            importedRecord = this._ddmFormInstanceRecordStagedModelRepository.updateStagedModel(portletDataContext, importedRecord, ddmFormValues);
        }
        portletDataContext.importClassedModel((ClassedModel)record, (ClassedModel)importedRecord);
    }

    protected void exportDDMFormValues(PortletDataContext portletDataContext, DDMFormInstanceRecord record, Element recordElement) throws Exception {
        String ddmFormValuesPath = ExportImportPathUtil.getModelPath((StagedModel)record, (String)"ddm-form-values.json");
        recordElement.addAttribute("ddm-form-values-path", ddmFormValuesPath);
        DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(record.getStorageId());
        ddmFormValues = (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)record, (Serializable)ddmFormValues, true, false);
        portletDataContext.addZipEntry(ddmFormValuesPath, this._ddmFormValuesJSONSerializer.serialize(ddmFormValues));
    }

    protected DDMFormValues getImportDDMFormValues(PortletDataContext portletDataContext, Element recordElement, long ddmFormInstanceId) throws Exception {
        DDMFormInstance recordSet = this._ddmFormInstanceLocalService.getFormInstance(ddmFormInstanceId);
        DDMStructure ddmStructure = recordSet.getStructure();
        String ddmFormValuesPath = recordElement.attributeValue("ddm-form-values-path");
        String serializedDDMFormValues = portletDataContext.getZipEntryAsString(ddmFormValuesPath);
        DDMFormValues ddmFormValues = this._ddmFormValuesJSONDeserializer.deserialize(ddmStructure.getDDMForm(), serializedDDMFormValues);
        return (DDMFormValues)this._ddmFormValuesExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)ddmStructure, (Serializable)ddmFormValues);
    }

    protected StagedModelRepository<DDMFormInstanceRecord> getStagedModelRepository() {
        return this._ddmFormInstanceRecordStagedModelRepository;
    }

    @Reference(unbind="-")
    protected void setDDMFormInstanceLocalService(DDMFormInstanceLocalService ddmFormInstanceLocalService) {
        this._ddmFormInstanceLocalService = ddmFormInstanceLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord)", unbind="-")
    protected void setDDMFormInstanceRecordStagedModelRepository(DDMFormInstanceRecordStagedModelRepository ddmFormInstanceRecordStagedModelRepository) {
        this._ddmFormInstanceRecordStagedModelRepository = ddmFormInstanceRecordStagedModelRepository;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.storage.DDMFormValues)", unbind="-")
    protected void setDDMFormValuesExportImportContentProcessor(ExportImportContentProcessor<DDMFormValues> ddmFormValuesExportImportContentProcessor) {
        this._ddmFormValuesExportImportContentProcessor = ddmFormValuesExportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONSerializer(DDMFormValuesJSONSerializer ddmFormValuesJSONSerializer) {
        this._ddmFormValuesJSONSerializer = ddmFormValuesJSONSerializer;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }

    protected void validateExport(PortletDataContext portletDataContext, DDMFormInstanceRecord record) throws PortletDataException {
        int status = -1;
        try {
            status = record.getStatus();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
        if (!portletDataContext.isInitialPublication() && !ArrayUtil.contains((int[])this.getExportableStatuses(), (int)status)) {
            PortletDataException pde = new PortletDataException(9);
            pde.setStagedModelDisplayName(record.getUuid());
            pde.setStagedModelClassName(record.getModelClassName());
            pde.setStagedModelClassPK(GetterUtil.getString((Object)record.getFormInstanceRecordId()));
            throw pde;
        }
    }
}

