/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal;

import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.exception.StructureDuplicateElementException;
import com.liferay.dynamic.data.mapping.exception.StructureNameException;
import com.liferay.dynamic.data.mapping.internal.DDMStructureImpl;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.dynamic.data.mapping.kernel.RequiredStructureException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.dynamic.data.mapping.util.comparator.StructureIdComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureStructureKeyComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMStructureManagerImpl
implements DDMStructureManager {
    private DDM _ddm;
    private DDMBeanTranslator _ddmBeanTranslator;
    private DDMIndexer _ddmIndexer;
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    private DDMStructureLocalService _ddmStructureLocalService;

    public void addAttributes(long structureId, Document document, DDMFormValues ddmFormValues) throws PortalException {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(structureId);
        this._ddmIndexer.addAttributes(document, ddmStructure, this._ddmBeanTranslator.translate(ddmFormValues));
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, com.liferay.dynamic.data.mapping.kernel.DDMForm ddmForm, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        try {
            DDMForm translatedDDMForm = this._ddmBeanTranslator.translate(ddmForm);
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(userId, groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, translatedDDMForm, this._ddm.getDefaultDDMFormLayout(translatedDDMForm), storageType, type, serviceContext);
            return new DDMStructureImpl(ddmStructure);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public void deleteStructure(long structureId) throws PortalException {
        try {
            this._ddmStructureLocalService.deleteStructure(structureId);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public String extractAttributes(long structureId, DDMFormValues ddmFormValues, Locale locale) throws PortalException {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(structureId);
        return this._ddmIndexer.extractIndexableAttributes(ddmStructure, this._ddmBeanTranslator.translate(ddmFormValues), locale);
    }

    public DDMStructure fetchStructure(long structureId) {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(structureId);
        if (ddmStructure == null) {
            return null;
        }
        return new DDMStructureImpl(ddmStructure);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, classNameId, structureKey);
        if (ddmStructure == null) {
            return null;
        }
        return new DDMStructureImpl(ddmStructure);
    }

    public DDMStructure fetchStructureByUuidAndGroupId(String uuid, long groupId) {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructureByUuidAndGroupId(uuid, groupId);
        if (ddmStructure == null) {
            return null;
        }
        return new DDMStructureImpl(ddmStructure);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId) {
        ArrayList<DDMStructure> ddmStructures = new ArrayList<DDMStructure>();
        List structures = this._ddmStructureLocalService.getClassStructures(companyId, classNameId);
        for (com.liferay.dynamic.data.mapping.model.DDMStructure structure : structures) {
            ddmStructures.add(new DDMStructureImpl(structure));
        }
        return ddmStructures;
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, int structureComparator) {
        ArrayList<DDMStructure> ddmStructures = new ArrayList<DDMStructure>();
        for (com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure : this._ddmStructureLocalService.getClassStructures(companyId, classNameId, this.getStructureOrderByComparator(structureComparator))) {
            ddmStructures.add(new DDMStructureImpl(ddmStructure));
        }
        return ddmStructures;
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, int start, int end) {
        ArrayList<DDMStructure> ddmStructures = new ArrayList<DDMStructure>();
        for (com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure : this._ddmStructureLocalService.getClassStructures(companyId, classNameId, start, end)) {
            ddmStructures.add(new DDMStructureImpl(ddmStructure));
        }
        return ddmStructures;
    }

    public JSONArray getDDMFormFieldsJSONArray(long structureId, String script) throws PortalException {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(structureId);
        return this._ddm.getDDMFormFieldsJSONArray(ddmStructure, script);
    }

    public Class<?> getDDMStructureModelClass() {
        return com.liferay.dynamic.data.mapping.model.DDMStructure.class;
    }

    public Serializable getIndexedFieldValue(Serializable fieldValue, String fieldType) throws Exception {
        return this._ddm.getIndexedFieldValue(fieldValue, fieldType);
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        try {
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(structureId);
            return new DDMStructureImpl(ddmStructure);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        try {
            com.liferay.dynamic.data.mapping.model.DDMStructure structure = this._ddmStructureLocalService.getStructure(groupId, classNameId, structureKey);
            return new DDMStructureImpl(structure);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public DDMStructure getStructureByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        try {
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructureByUuidAndGroupId(uuid, groupId);
            return new DDMStructureImpl(ddmStructure);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId) {
        ArrayList<DDMStructure> ddmStructures = new ArrayList<DDMStructure>();
        for (com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure : this._ddmStructureLocalService.getStructures(groupIds, classNameId)) {
            ddmStructures.add(new DDMStructureImpl(ddmStructure));
        }
        return ddmStructures;
    }

    public int getStructureStorageLinksCount(long structureId) {
        return this._ddmStorageLinkLocalService.getStructureStorageLinksCount(structureId);
    }

    public DDMStructure updateStructure(long userId, long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, com.liferay.dynamic.data.mapping.kernel.DDMForm ddmForm, ServiceContext serviceContext) throws PortalException {
        try {
            DDMForm copyDDMForm = this._ddmBeanTranslator.translate(ddmForm);
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.updateStructure(userId, structureId, parentStructureId, nameMap, descriptionMap, copyDDMForm, this._ddm.getDefaultDDMFormLayout(copyDDMForm), serviceContext);
            return new DDMStructureImpl(ddmStructure);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public void updateStructureDefinition(long structureId, String definition) throws PortalException {
        try {
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(structureId);
            ddmStructure.setDefinition(definition);
            this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public void updateStructureKey(long structureId, String structureKey) throws PortalException {
        com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(structureId);
        ddmStructure.setStructureKey(structureKey);
        this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
    }

    protected OrderByComparator<com.liferay.dynamic.data.mapping.model.DDMStructure> getStructureOrderByComparator(int structureComparator) {
        if (structureComparator == 0) {
            return StructureStructureKeyComparator.INSTANCE_DESCENDING;
        }
        return new StructureIdComparator();
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMBeanTranslator(DDMBeanTranslator ddmBeanTranslator) {
        this._ddmBeanTranslator = ddmBeanTranslator;
    }

    @Reference(unbind="-")
    protected void setDDMIndexer(DDMIndexer ddmIndexer) {
        this._ddmIndexer = ddmIndexer;
    }

    @Reference(unbind="-")
    protected void setDDMStorageLinkLocalService(DDMStorageLinkLocalService ddmStorageLinkLocalService) {
        this._ddmStorageLinkLocalService = ddmStorageLinkLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    protected PortalException translate(PortalException portalException) {
        if (portalException instanceof NoSuchStructureException) {
            return new com.liferay.dynamic.data.mapping.kernel.NoSuchStructureException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof com.liferay.dynamic.data.mapping.exception.RequiredStructureException) {
            return new RequiredStructureException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof StructureDefinitionException) {
            return new com.liferay.dynamic.data.mapping.kernel.StructureDefinitionException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof StructureDuplicateElementException) {
            return new StructureDuplicateElementException(portalException.getMessage(), portalException.getCause());
        }
        if (portalException instanceof StructureNameException) {
            return new StructureNameException(portalException.getMessage(), portalException.getCause());
        }
        return portalException;
    }
}

