/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.upgrade.v1_1_1;

import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class UpgradeDDMFormFieldSettings
extends UpgradeProcess {
    private static final int _SCOPE_FORMS = 2;
    private final DDMFormJSONDeserializer _ddmFormJSONDeserializer;
    private final DDMFormJSONSerializer _ddmFormJSONSerializer;

    public UpgradeDDMFormFieldSettings(DDMFormJSONDeserializer ddmFormJSONDeserializer, DDMFormJSONSerializer ddmFormJSONSerializer) {
        this._ddmFormJSONDeserializer = ddmFormJSONDeserializer;
        this._ddmFormJSONSerializer = ddmFormJSONSerializer;
    }

    protected void doUpgrade() throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("select DDMStructure.structureId, DDMStructure.definition ");
        sb.append("from DDLRecordSet inner join DDMStructure on ");
        sb.append("DDLRecordSet.DDMStructureId = DDMStructure.structureId ");
        sb.append("where DDLRecordSet.scope = ? and DDMStructure.definition ");
        sb.append("like ?");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DDMStructure set definition = ? where structureId = ?");){
            ps1.setInt(1, 2);
            ps1.setString(2, "%ddmDataProviderInstanceId%");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String definition = rs.getString(2);
                    String newDefinition = this.upgradeRecordSetStructure(definition);
                    ps2.setString(1, newDefinition);
                    long structureId = rs.getLong(1);
                    ps2.setLong(2, structureId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    protected String upgradeRecordSetStructure(String definition) throws Exception {
        DDMForm ddmForm = this._ddmFormJSONDeserializer.deserialize(definition);
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            Map properties = ddmFormField.getProperties();
            if (!properties.containsKey("ddmDataProviderInstanceId")) continue;
            String ddmDataProviderInstanceId = GetterUtil.getString(properties.get("ddmDataProviderInstanceId"));
            properties.put("ddmDataProviderInstanceId", "[\"" + ddmDataProviderInstanceId + "\"]");
            properties.put("ddmDataProviderInstanceOutput", "[\"Default-Output\"]");
        }
        return this._ddmFormJSONSerializer.serialize(ddmForm);
    }
}

