/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.permission;

import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseResourcePermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionChecker;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"resource.name=com.liferay.dynamic.data.mapping"}, service={ResourcePermissionChecker.class})
public class DDMDataProviderPermission
extends BaseResourcePermissionChecker {
    public static final String RESOURCE_NAME = "com.liferay.dynamic.data.mapping";

    public static void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!DDMDataProviderPermission.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, RESOURCE_NAME, groupId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)DDMDataProviderInstance.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        return DDMDataProviderPermission.contains((PermissionChecker)permissionChecker, (String)RESOURCE_NAME, (String)portletId, (long)groupId, (String)actionId);
    }

    public Boolean checkResource(PermissionChecker permissionChecker, long classPK, String actionId) {
        return DDMDataProviderPermission.contains(permissionChecker, classPK, actionId);
    }
}

