/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.permission;

import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceLocalServiceUtil;
import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;

public class DDMDataProviderInstancePermission {
    public static void check(PermissionChecker permissionChecker, long dataProviderInstanceId, String actionId) throws PortalException {
        if (!DDMDataProviderInstancePermission.contains(permissionChecker, dataProviderInstanceId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DDMDataProviderInstance.class.getName(), dataProviderInstanceId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDMDataProviderInstance dataProviderInstance, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)DDMDataProviderInstance.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dataProviderInstance.getGroupId(), (String)DDMDataProviderInstance.class.getName(), (long)dataProviderInstance.getDataProviderInstanceId(), (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(dataProviderInstance.getCompanyId(), DDMDataProviderInstance.class.getName(), dataProviderInstance.getDataProviderInstanceId(), dataProviderInstance.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(dataProviderInstance.getGroupId(), DDMDataProviderInstance.class.getName(), dataProviderInstance.getDataProviderInstanceId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long dataProviderInstanceId, String actionId) throws PortalException {
        DDMDataProviderInstance dataProviderInstance = DDMDataProviderInstanceLocalServiceUtil.getDDMDataProviderInstance((long)dataProviderInstanceId);
        return DDMDataProviderInstancePermission.contains(permissionChecker, dataProviderInstance, actionId);
    }
}

