/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal;

import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManager;
import com.liferay.dynamic.data.mapping.kernel.StorageFieldRequiredException;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DDMBeanTranslator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class StorageEngineManagerImpl
implements StorageEngineManager {
    private DDM _ddm;
    private DDMBeanTranslator _ddmBeanTranslator;
    private StorageEngine _storageEngine;

    public long create(long companyId, long ddmStructureId, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        try {
            return this._storageEngine.create(companyId, ddmStructureId, this._ddmBeanTranslator.translate(ddmFormValues), serviceContext);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    public void deleteByClass(long classPK) throws PortalException {
        this._storageEngine.deleteByClass(classPK);
    }

    public DDMFormValues getDDMFormValues(long classPK) throws PortalException {
        return this._ddmBeanTranslator.translate(this._storageEngine.getDDMFormValues(classPK));
    }

    public DDMFormValues getDDMFormValues(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        return this._ddmBeanTranslator.translate(this._ddm.getDDMFormValues(ddmStructureId, fieldNamespace, serviceContext));
    }

    public void update(long classPK, DDMFormValues ddmFormValues, ServiceContext serviceContext) throws PortalException {
        try {
            this._storageEngine.update(classPK, this._ddmBeanTranslator.translate(ddmFormValues), serviceContext);
        }
        catch (PortalException pe) {
            throw this.translate(pe);
        }
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMBeanTranslator(DDMBeanTranslator ddmBeanTranslator) {
        this._ddmBeanTranslator = ddmBeanTranslator;
    }

    @Reference(unbind="-")
    protected void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }

    protected PortalException translate(PortalException portalException) {
        if (portalException instanceof com.liferay.dynamic.data.mapping.exception.StorageFieldRequiredException) {
            return new StorageFieldRequiredException(portalException.getMessage(), portalException.getCause());
        }
        return portalException;
    }
}

