/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateVersionServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.permission.DDMTemplatePermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class DDMTemplateVersionServiceImpl
extends DDMTemplateVersionServiceBaseImpl {
    public DDMTemplateVersion getLatestTemplateVersion(long templateId) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getLatestTemplateVersion(templateId);
    }

    public DDMTemplateVersion getTemplateVersion(long templateVersionId) throws PortalException {
        DDMTemplateVersion templateVersion = this.ddmTemplateVersionLocalService.getTemplateVersion(templateVersionId);
        DDMTemplatePermission.check(this.getPermissionChecker(), templateVersion.getTemplateId(), "VIEW");
        return templateVersion;
    }

    public List<DDMTemplateVersion> getTemplateVersions(long templateId, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getTemplateVersions(templateId, start, end, orderByComparator);
    }

    public int getTemplateVersionsCount(long templateId) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplateVersionLocalService.getTemplateVersionsCount(templateId);
    }
}

