/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureVersionServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.permission.DDMStructurePermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class DDMStructureVersionServiceImpl
extends DDMStructureVersionServiceBaseImpl {
    public DDMStructureVersion getLatestStructureVersion(long structureId) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructureVersionLocalService.getLatestStructureVersion(structureId);
    }

    public DDMStructureVersion getStructureVersion(long structureVersionId) throws PortalException {
        DDMStructureVersion structureVersion = this.ddmStructureVersionLocalService.getStructureVersion(structureVersionId);
        DDMStructurePermission.check(this.getPermissionChecker(), structureVersion.getStructureId(), "VIEW");
        return structureVersion;
    }

    public List<DDMStructureVersion> getStructureVersions(long structureId, int start, int end, OrderByComparator<DDMStructureVersion> orderByComparator) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructureVersionLocalService.getStructureVersions(structureId, start, end, orderByComparator);
    }

    public int getStructureVersionsCount(long structureId) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructureVersionLocalService.getStructureVersionsCount(structureId);
    }
}

