/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util.impl;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.dynamic.data.mapping.util.impl.DDMFieldsCounter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class FieldsToDDMFormValuesConverterImpl
implements FieldsToDDMFormValuesConverter {
    public DDMFormValues convert(DDMStructure ddmStructure, Fields fields) throws PortalException {
        DDMFormValues ddmFormValues = this.createDDMFormValues(ddmStructure.getDDMForm(), fields.getAvailableLocales(), fields.getDefaultLocale());
        DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
        for (String fieldName : ddmStructure.getRootFieldNames()) {
            int repetitions = this.countDDMFieldRepetitions(fields, fieldName, null, -1);
            for (int i = 0; i < repetitions; ++i) {
                DDMFormFieldValue ddmFormFieldValue = this.createDDMFormFieldValue(fieldName);
                this.setDDMFormFieldValueProperties(ddmFormFieldValue, ddmStructure, fields, ddmFieldsCounter);
                ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            }
        }
        return ddmFormValues;
    }

    protected int countDDMFieldRepetitions(Fields ddmFields, String fieldName, String parentFieldName, int parentOffset) throws PortalException {
        Field ddmFieldsDisplayField = ddmFields.get("_fieldsDisplay");
        if (ddmFieldsDisplayField == null) {
            if (ddmFields.contains(fieldName)) {
                return 1;
            }
            return 0;
        }
        String[] ddmFieldsDisplayValues = this.getDDMFieldsDisplayValues(ddmFieldsDisplayField);
        int offset = -1;
        int repetitions = 0;
        for (int i = 0; i < ddmFieldsDisplayValues.length; ++i) {
            String fieldDisplayName = ddmFieldsDisplayValues[i];
            if (offset > parentOffset) break;
            if (fieldDisplayName.equals(parentFieldName)) {
                ++offset;
            }
            if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
            ++repetitions;
        }
        return repetitions;
    }

    protected DDMFormFieldValue createDDMFormFieldValue(String name) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setName(name);
        return ddmFormFieldValue;
    }

    protected DDMFormValues createDDMFormValues(DDMForm ddmForm, Set<Locale> availableLocales, Locale defaultLocale) {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.setAvailableLocales(availableLocales);
        ddmFormValues.setDefaultLocale(defaultLocale);
        return ddmFormValues;
    }

    protected String getDDMFieldInstanceId(Fields ddmFields, String fieldName, int index) {
        String[] ddmFieldsDisplayValues;
        Field ddmFieldsDisplayField = ddmFields.get("_fieldsDisplay");
        if (ddmFieldsDisplayField == null) {
            return StringUtil.randomString();
        }
        String prefix = fieldName.concat("_INSTANCE_");
        for (String ddmFieldsDisplayValue : ddmFieldsDisplayValues = StringUtil.split((String)((String)((Object)ddmFieldsDisplayField.getValue())))) {
            if (!ddmFieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)ddmFieldsDisplayValue, (String)"_INSTANCE_");
        }
        return null;
    }

    protected String[] getDDMFieldsDisplayValues(Field ddmFieldsDisplayField) throws PortalException {
        try {
            String[] values;
            DDMStructure ddmStructure = ddmFieldsDisplayField.getDDMStructure();
            ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
            for (String value : values = this.splitFieldsDisplayValue(ddmFieldsDisplayField)) {
                String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
                if (!ddmStructure.hasField(fieldName)) continue;
                fieldsDisplayValues.add(fieldName);
            }
            return fieldsDisplayValues.toArray(new String[fieldsDisplayValues.size()]);
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    protected String getDDMFieldValueString(Field ddmField, Locale locale, int index) {
        Serializable fieldValue = ddmField.getValue(locale, index);
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            fieldValue = Long.valueOf(valueDate.getTime());
        }
        return String.valueOf(fieldValue);
    }

    protected void setDDMFormFieldValueInstanceId(DDMFormFieldValue ddmFormFieldValue, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) {
        String name = ddmFormFieldValue.getName();
        String instanceId = this.getDDMFieldInstanceId(ddmFields, name, ddmFieldsCounter.get(name));
        ddmFormFieldValue.setInstanceId(instanceId);
    }

    protected void setDDMFormFieldValueLocalizedValue(DDMFormFieldValue ddmFormFieldValue, Field ddmField, int index) {
        LocalizedValue value = new LocalizedValue(ddmField.getDefaultLocale());
        for (Locale availableLocale : ddmField.getAvailableLocales()) {
            String valueString = this.getDDMFieldValueString(ddmField, availableLocale, index);
            value.addString(availableLocale, valueString);
        }
        ddmFormFieldValue.setValue((Value)value);
    }

    protected void setDDMFormFieldValueProperties(DDMFormFieldValue ddmFormFieldValue, DDMStructure ddmStructure, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        this.setDDMFormFieldValueInstanceId(ddmFormFieldValue, ddmFields, ddmFieldsCounter);
        this.setNestedDDMFormFieldValues(ddmFormFieldValue, ddmStructure, ddmFields, ddmFieldsCounter);
        this.setDDMFormFieldValueValues(ddmFormFieldValue, ddmStructure, ddmFields, ddmFieldsCounter);
    }

    protected void setDDMFormFieldValueUnlocalizedValue(DDMFormFieldValue ddmFormFieldValue, Field ddmField, int index) {
        String valueString = this.getDDMFieldValueString(ddmField, ddmField.getDefaultLocale(), index);
        UnlocalizedValue value = new UnlocalizedValue(valueString);
        ddmFormFieldValue.setValue((Value)value);
    }

    protected void setDDMFormFieldValueValues(DDMFormFieldValue ddmFormFieldValue, DDMStructure ddmStructure, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        String fieldName = ddmFormFieldValue.getName();
        if (!ddmStructure.isFieldTransient(fieldName)) {
            DDMFormField ddmFormField = ddmStructure.getDDMFormField(fieldName);
            if (ddmFormField.isLocalizable()) {
                this.setDDMFormFieldValueLocalizedValue(ddmFormFieldValue, ddmFields.get(fieldName), ddmFieldsCounter.get(fieldName));
            } else {
                this.setDDMFormFieldValueUnlocalizedValue(ddmFormFieldValue, ddmFields.get(fieldName), ddmFieldsCounter.get(fieldName));
            }
        }
        ddmFieldsCounter.incrementKey(fieldName);
    }

    protected void setNestedDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue, DDMStructure ddmStructure, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws PortalException {
        String fieldName = ddmFormFieldValue.getName();
        int parentOffset = ddmFieldsCounter.get(fieldName);
        List nestedFieldNames = ddmStructure.getChildrenFieldNames(fieldName);
        for (String nestedFieldName : nestedFieldNames) {
            int repetitions = this.countDDMFieldRepetitions(ddmFields, nestedFieldName, fieldName, parentOffset);
            for (int i = 0; i < repetitions; ++i) {
                DDMFormFieldValue nestedDDMFormFieldValue = this.createDDMFormFieldValue(nestedFieldName);
                this.setDDMFormFieldValueProperties(nestedDDMFormFieldValue, ddmStructure, ddmFields, ddmFieldsCounter);
                ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
            }
        }
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }
}

