/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateVersionException;
import com.liferay.dynamic.data.mapping.model.DDMTemplateVersion;
import com.liferay.dynamic.data.mapping.service.base.DDMTemplateVersionLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.util.comparator.TemplateVersionVersionComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.List;

@ProviderType
public class DDMTemplateVersionLocalServiceImpl
extends DDMTemplateVersionLocalServiceBaseImpl {
    public DDMTemplateVersion getLatestTemplateVersion(long templateId) throws PortalException {
        List templateVersions = this.ddmTemplateVersionPersistence.findByTemplateId(templateId);
        if (templateVersions.isEmpty()) {
            throw new NoSuchTemplateVersionException("No template versions found for template ID " + templateId);
        }
        templateVersions = ListUtil.copy((List)templateVersions);
        Collections.sort(templateVersions, new TemplateVersionVersionComparator());
        return (DDMTemplateVersion)templateVersions.get(0);
    }

    public DDMTemplateVersion getTemplateVersion(long templateVersionId) throws PortalException {
        return this.ddmTemplateVersionPersistence.findByPrimaryKey(templateVersionId);
    }

    public DDMTemplateVersion getTemplateVersion(long templateId, String version) throws PortalException {
        return this.ddmTemplateVersionPersistence.findByT_V(templateId, version);
    }

    public List<DDMTemplateVersion> getTemplateVersions(long templateId, int start, int end, OrderByComparator<DDMTemplateVersion> orderByComparator) {
        return this.ddmTemplateVersionPersistence.findByTemplateId(templateId, start, end, orderByComparator);
    }

    public int getTemplateVersionsCount(long templateId) {
        return this.ddmTemplateVersionPersistence.countByTemplateId(templateId);
    }
}

