/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureServiceBaseImpl;
import com.liferay.dynamic.data.mapping.service.permission.DDMStructurePermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMStructureServiceImpl
extends DDMStructureServiceBaseImpl {
    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, classNameId, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, serviceContext);
    }

    @Deprecated
    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, classNameId, nameMap, descriptionMap, xsd, serviceContext);
    }

    public DDMStructure addStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    @Deprecated
    public DDMStructure addStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, xsd, storageType, type, serviceContext);
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(userId, groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, storageType, type, serviceContext);
    }

    @Deprecated
    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String xsd, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), groupId, classNameId);
        return this.ddmStructureLocalService.addStructure(userId, groupId, parentStructureKey, classNameId, structureKey, nameMap, descriptionMap, xsd, storageType, type, serviceContext);
    }

    public DDMStructure copyStructure(long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        DDMStructurePermission.check(this.getPermissionChecker(), structure, "VIEW");
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), structure.getClassNameId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), structureId, nameMap, descriptionMap, serviceContext);
    }

    public DDMStructure copyStructure(long structureId, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        DDMStructurePermission.check(this.getPermissionChecker(), structure, "VIEW");
        DDMStructurePermission.checkAddStruturePermission(this.getPermissionChecker(), serviceContext.getScopeGroupId(), structure.getClassNameId());
        return this.ddmStructureLocalService.copyStructure(this.getUserId(), structureId, serviceContext);
    }

    public void deleteStructure(long structureId) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "DELETE");
        this.ddmStructureLocalService.deleteStructure(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
        if (ddmStructure != null) {
            DDMStructurePermission.check(this.getPermissionChecker(), ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(groupId, classNameId, structureKey, includeAncestorStructures);
        if (ddmStructure != null) {
            DDMStructurePermission.check(this.getPermissionChecker(), ddmStructure, "VIEW");
        }
        return ddmStructure;
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "VIEW");
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, classNameId, structureKey, "VIEW");
        return this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, classNameId, structureKey, "VIEW");
        return this.ddmStructureLocalService.getStructure(groupId, classNameId, structureKey, includeAncestorStructures);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int status) {
        return this.ddmStructureFinder.filterFindByC_G_C_S(companyId, groupIds, classNameId, status, -1, -1, null);
    }

    public List<DDMStructure> getStructures(long companyId, long[] groupIds, long classNameId, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.filterFindByC_G_C_S(companyId, groupIds, classNameId, status, start, end, orderByComparator);
    }

    public void revertStructure(long structureId, String version, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        this.ddmStructureLocalService.revertStructure(this.getUserId(), structureId, version, serviceContext);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String keywords, int status, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.filterFindByKeywords(companyId, groupIds, classNameId, keywords, status, start, end, orderByComparator);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.filterFindByC_G_C_N_D_S_T_S(companyId, groupIds, classNameId, name, description, storageType, type, status, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String keywords, int status) {
        return this.ddmStructureFinder.filterCountByKeywords(companyId, groupIds, classNameId, keywords, status);
    }

    public int searchCount(long companyId, long[] groupIds, long classNameId, String name, String description, String storageType, int type, int status, boolean andOperator) {
        return this.ddmStructureFinder.filterCountByC_G_C_N_D_S_T_S(companyId, groupIds, classNameId, name, description, storageType, type, status, andOperator);
    }

    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, classNameId, structureKey, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(this.getUserId(), groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext);
    }

    @Deprecated
    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), groupId, classNameId, structureKey, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, definition, serviceContext);
    }

    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, DDMForm ddmForm, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(this.getUserId(), structureId, parentStructureId, nameMap, descriptionMap, ddmForm, ddmFormLayout, serviceContext);
    }

    @Deprecated
    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructurePermission.check(this.getPermissionChecker(), structureId, "UPDATE");
        return this.ddmStructureLocalService.updateStructure(structureId, parentStructureId, nameMap, descriptionMap, definition, serviceContext);
    }
}

