/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.service.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutJSONDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutJSONSerializer;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.service.base.DDMStructureLayoutLocalServiceBaseImpl;
import com.liferay.dynamic.data.mapping.validator.DDMFormLayoutValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.spring.extender.service.ServiceReference;

@ProviderType
public class DDMStructureLayoutLocalServiceImpl
extends DDMStructureLayoutLocalServiceBaseImpl {
    @ServiceReference(type=DDMFormLayoutJSONDeserializer.class)
    protected DDMFormLayoutJSONDeserializer ddmFormLayoutJSONDeserializer;
    @ServiceReference(type=DDMFormLayoutJSONSerializer.class)
    protected DDMFormLayoutJSONSerializer ddmFormLayoutJSONSerializer;
    @ServiceReference(type=DDMFormLayoutValidator.class)
    protected DDMFormLayoutValidator ddmFormLayoutValidator;

    public DDMStructureLayout addStructureLayout(long userId, long groupId, long structureVersionId, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validate(ddmFormLayout);
        long structureLayoutId = this.counterLocalService.increment();
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.create(structureLayoutId);
        structureLayout.setUuid(serviceContext.getUuid());
        structureLayout.setGroupId(groupId);
        structureLayout.setCompanyId(user.getCompanyId());
        structureLayout.setUserId(user.getUserId());
        structureLayout.setUserName(user.getFullName());
        structureLayout.setStructureVersionId(structureVersionId);
        structureLayout.setDefinition(this.ddmFormLayoutJSONSerializer.serialize(ddmFormLayout));
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    @SystemEvent(type=1)
    public void deleteStructureLayout(DDMStructureLayout structureLayout) {
        this.ddmStructureLayoutPersistence.remove((BaseModel)structureLayout);
    }

    public void deleteStructureLayout(long structureLayoutId) throws PortalException {
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
        this.ddmStructureLayoutLocalService.deleteStructureLayout(structureLayout);
    }

    public DDMStructureLayout getStructureLayout(long structureLayoutId) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
    }

    public DDMStructureLayout getStructureLayoutByStructureVersionId(long structureVersionId) throws PortalException {
        return this.ddmStructureLayoutPersistence.findByStructureVersionId(structureVersionId);
    }

    public DDMFormLayout getStructureLayoutDDMFormLayout(DDMStructureLayout structureLayout) throws PortalException {
        return this.ddmFormLayoutJSONDeserializer.deserialize(structureLayout.getDefinition());
    }

    public DDMStructureLayout updateStructureLayout(long structureLayoutId, DDMFormLayout ddmFormLayout, ServiceContext serviceContext) throws PortalException {
        DDMStructureLayout structureLayout = this.ddmStructureLayoutPersistence.findByPrimaryKey(structureLayoutId);
        this.validate(ddmFormLayout);
        structureLayout.setDefinition(this.ddmFormLayoutJSONSerializer.serialize(ddmFormLayout));
        return (DDMStructureLayout)this.ddmStructureLayoutPersistence.update((BaseModel)structureLayout);
    }

    protected void validate(DDMFormLayout ddmFormLayout) throws PortalException {
        this.ddmFormLayoutValidator.validate(ddmFormLayout);
    }
}

