/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.internal.template;

import com.liferay.dynamic.data.mapping.kernel.DDMTemplate;
import com.liferay.dynamic.data.mapping.kernel.DDMTemplateManager;
import com.liferay.dynamic.data.mapping.service.permission.DDMTemplatePermission;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistry;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.language.LanguageResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={TemplateHandlerRegistry.class})
public class TemplateHandlerRegistryImpl
implements TemplateHandlerRegistry {
    private volatile BundleContext _bundleContext;
    private DDMTemplateManager _ddmTemplateManager;
    private GroupLocalService _groupLocalService;
    private Portal _portal;
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    private final Map<String, TemplateHandler> _templateHandlers = new ConcurrentHashMap<String, TemplateHandler>();
    private UserLocalService _userLocalService;

    public long[] getClassNameIds() {
        long[] classNameIds = new long[this._templateHandlers.size()];
        int i = 0;
        for (Map.Entry<String, TemplateHandler> entry : this._templateHandlers.entrySet()) {
            TemplateHandler templateHandler = entry.getValue();
            classNameIds[i++] = this._portal.getClassNameId(templateHandler.getClassName());
        }
        return classNameIds;
    }

    public TemplateHandler getTemplateHandler(long classNameId) {
        String className = this._portal.getClassName(classNameId);
        return this._templateHandlers.get(className);
    }

    public TemplateHandler getTemplateHandler(String className) {
        return this._templateHandlers.get(className);
    }

    public List<TemplateHandler> getTemplateHandlers() {
        ArrayList<TemplateHandler> templateHandlers = new ArrayList<TemplateHandler>(this._templateHandlers.values());
        return Collections.unmodifiableList(templateHandlers);
    }

    @Activate
    protected synchronized void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        for (String className : this._templateHandlers.keySet()) {
            if (this._serviceRegistrations.containsKey(className)) continue;
            TemplateHandler templateHandler = this._templateHandlers.get(className);
            this.registerPortalInstanceLifecycleListener(templateHandler);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeTemplateHandler")
    protected synchronized void addTemplateHandler(TemplateHandler templateHandler) {
        this._templateHandlers.put(templateHandler.getClassName(), templateHandler);
        if (this._bundleContext == null) {
            return;
        }
        this.registerPortalInstanceLifecycleListener(templateHandler);
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._templateHandlers.clear();
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
        this._bundleContext = null;
    }

    protected void registerPortalInstanceLifecycleListener(TemplateHandler templateHandler) {
        ServiceRegistration serviceRegistration = this._serviceRegistrations.get(templateHandler.getClassName());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
        TemplateHandlerPortalInstanceLifecycleListener portalInstanceLifecycleListener = new TemplateHandlerPortalInstanceLifecycleListener(templateHandler);
        serviceRegistration = this._bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)portalInstanceLifecycleListener, (Dictionary)new HashMapDictionary());
        this._serviceRegistrations.put(templateHandler.getClassName(), serviceRegistration);
    }

    protected synchronized void removeTemplateHandler(TemplateHandler templateHandler) {
        this._templateHandlers.remove(templateHandler.getClassName());
        this._templateHandlers.put(templateHandler.getClassName(), templateHandler);
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.remove(templateHandler.getClassName());
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    @Reference(unbind="-")
    protected void setDDMTemplateManager(DDMTemplateManager ddmTemplateManager) {
        this._ddmTemplateManager = ddmTemplateManager;
    }

    @Reference(unbind="-")
    protected void setDDMTemplatePermission(DDMTemplatePermission ddmTemplatePermission) {
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setPortal(Portal portal) {
        this._portal = portal;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private class TemplateHandlerPortalInstanceLifecycleListener
    extends BasePortalInstanceLifecycleListener {
        private static final String _PORTLET_DISPLAY_TEMPLATE_CLASS_NAME = "com.liferay.portlet.display.template.PortletDisplayTemplate";
        private final TemplateHandler _templateHandler;

        public TemplateHandlerPortalInstanceLifecycleListener(TemplateHandler templateHandler) {
            this._templateHandler = templateHandler;
        }

        public void portalInstanceRegistered(Company company) throws Exception {
            long classNameId = TemplateHandlerRegistryImpl.this._portal.getClassNameId(this._templateHandler.getClassName());
            ServiceContext serviceContext = new ServiceContext();
            Group group = TemplateHandlerRegistryImpl.this._groupLocalService.getCompanyGroup(company.getCompanyId());
            serviceContext.setScopeGroupId(group.getGroupId());
            long userId = TemplateHandlerRegistryImpl.this._userLocalService.getDefaultUserId(company.getCompanyId());
            serviceContext.setUserId(userId);
            List templateElements = this._templateHandler.getDefaultTemplateElements();
            for (Element templateElement : templateElements) {
                String templateKey = templateElement.elementText("template-key");
                DDMTemplate ddmTemplate = TemplateHandlerRegistryImpl.this._ddmTemplateManager.fetchTemplate(group.getGroupId(), classNameId, templateKey);
                if (ddmTemplate != null) continue;
                Class<?> clazz = this._templateHandler.getClass();
                ClassLoader classLoader = clazz.getClassLoader();
                AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{ResourceBundleUtil.getResourceBundleLoader((String)"content.Language", (ClassLoader)classLoader), LanguageResources.RESOURCE_BUNDLE_LOADER});
                Map<Locale, String> nameMap = this.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, group.getGroupId(), templateElement.elementText("name"));
                Map<Locale, String> descriptionMap = this.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, group.getGroupId(), templateElement.elementText("description"));
                String type = templateElement.elementText("type");
                if (type == null) {
                    type = "display";
                }
                String language = templateElement.elementText("language");
                String scriptFileName = templateElement.elementText("script-file");
                String script = StringUtil.read((ClassLoader)classLoader, (String)scriptFileName);
                boolean cacheable = GetterUtil.getBoolean((String)templateElement.elementText("cacheable"));
                TemplateHandlerRegistryImpl.this._ddmTemplateManager.addTemplate(userId, group.getGroupId(), classNameId, 0L, TemplateHandlerRegistryImpl.this._portal.getClassNameId(_PORTLET_DISPLAY_TEMPLATE_CLASS_NAME), templateKey, nameMap, descriptionMap, type, null, language, script, cacheable, false, null, null, serviceContext);
            }
        }

        public void portalInstanceUnregistered(Company company) throws Exception {
        }

        protected Map<Locale, String> getLocalizationMap(ResourceBundleLoader resourceBundleLoader, long groupId, String key) {
            HashMap<Locale, String> map = new HashMap<Locale, String>();
            for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
                ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(LocaleUtil.toLanguageId((Locale)locale));
                map.put(locale, LanguageUtil.get((ResourceBundle)resourceBundle, (String)key));
            }
            return map;
        }
    }
}

