/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriter;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterRequest;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormInstanceRecordWriterResponse;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.CSVUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"ddm.form.instance.record.writer.type=csv"}, service={DDMFormInstanceRecordWriter.class})
public class DDMFormInstanceRecordCSVWriter
implements DDMFormInstanceRecordWriter {
    public DDMFormInstanceRecordWriterResponse write(DDMFormInstanceRecordWriterRequest ddmFormInstanceRecordWriterRequest) throws Exception {
        StringBundler sb = new StringBundler(3);
        Map ddmFormFieldsLabel = ddmFormInstanceRecordWriterRequest.getDDMFormFieldsLabel();
        sb.append(this.writeValues(ddmFormFieldsLabel.values()));
        sb.append("\n");
        sb.append(this.writeRecords(ddmFormInstanceRecordWriterRequest.getDDMFormFieldValues()));
        String csv = sb.toString();
        DDMFormInstanceRecordWriterResponse.Builder builder = DDMFormInstanceRecordWriterResponse.Builder.newBuilder((byte[])csv.getBytes());
        return builder.build();
    }

    protected String writeRecords(List<Map<String, String>> ddmFormFieldValues) {
        Stream stream = ddmFormFieldValues.stream();
        return stream.map(Map::values).map(this::writeValues).collect(Collectors.joining("\n"));
    }

    protected String writeValues(Collection<String> values) {
        Stream<String> stream = values.stream();
        return stream.map(CSVUtil::encode).collect(Collectors.joining(","));
    }
}

