/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal.exporter;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormExporter;
import com.liferay.dynamic.data.mapping.io.internal.exporter.BaseDDMFormExporter;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormExporter.class})
public class DDMFormXMLExporter
extends BaseDDMFormExporter {
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    @Reference
    private DDMFormInstanceVersionLocalService _ddmFormInstanceVersionService;
    @Reference
    private StorageEngine _storageEngine;

    @Override
    public DDMFormFieldTypeServicesTracker getDDMFormFieldTypeServicesTracker() {
        return this._ddmFormFieldTypeServicesTracker;
    }

    @Override
    public DDMFormInstanceVersionLocalService getDDMFormInstanceVersionLocalService() {
        return this._ddmFormInstanceVersionService;
    }

    public String getFormat() {
        return "xml";
    }

    @Deprecated
    protected void addFieldElement(BaseDDMFormExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue, Element element, Map.Entry<String, DDMFormField> entry) {
        LocalizedValue label = null;
        String value = null;
        if (ddmFormFieldRenderedValue == null) {
            DDMFormField ddmFormField = entry.getValue();
            label = ddmFormField.getLabel();
            value = "";
        } else {
            label = ddmFormFieldRenderedValue.getLabel();
            value = ddmFormFieldRenderedValue.getValue();
        }
        this.addFieldElement(element, label.getString(this.getLocale()), (Serializable)((Object)value));
    }

    protected void addFieldElement(Element fieldsElement, String label, Serializable value) {
        Element fieldElement = fieldsElement.addElement("field");
        Element labelElement = fieldElement.addElement("label");
        labelElement.addText(label);
        Element valueElement = fieldElement.addElement("value");
        valueElement.addText(String.valueOf(value));
    }

    @Override
    protected byte[] doExport(long formInstanceId, int status, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) throws Exception {
        Map<String, DDMFormField> ddmFormFields = this.getDistinctFields(formInstanceId);
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        List formInstanceRecords = this._ddmFormInstanceRecordLocalService.getFormInstanceRecords(formInstanceId, status, start, end, orderByComparator);
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        Locale locale = this.getLocale();
        Map<String, String> ddmFormFieldsLabels = this.getDDMFormFieldsLabels(ddmFormFields.values(), locale);
        for (DDMFormInstanceRecord formInstanceRecord : formInstanceRecords) {
            Element fieldsElement = rootElement.addElement("fields");
            DDMFormInstanceRecordVersion recordVersion = formInstanceRecord.getFormInstanceRecordVersion();
            DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getStorageId());
            Map<String, BaseDDMFormExporter.DDMFormFieldRenderedValue> values = this.getRenderedValues(ddmFormFields.values(), ddmFormValues);
            for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
                BaseDDMFormExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                String value = "";
                if (ddmFormFieldRenderedValue != null) {
                    value = ddmFormFieldRenderedValue.getValue();
                }
                this.addFieldElement(fieldsElement, ddmFormFieldsLabels.get(entry.getKey()), (Serializable)((Object)value));
            }
            this.addFieldElement(fieldsElement, LanguageUtil.get((Locale)locale, (String)"status"), (Serializable)((Object)this.getStatusMessage(recordVersion.getStatus())));
            this.addFieldElement(fieldsElement, LanguageUtil.get((Locale)locale, (String)"modified-date"), (Serializable)((Object)this.formatDate(recordVersion.getStatusDate(), dateTimeFormatter)));
            this.addFieldElement(fieldsElement, LanguageUtil.get((Locale)locale, (String)"author"), (Serializable)((Object)recordVersion.getUserName()));
        }
        String xml = document.asXML();
        return xml.getBytes();
    }
}

