/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal.exporter;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormExporter;
import com.liferay.dynamic.data.mapping.io.internal.exporter.BaseDDMFormExporter;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormExporter.class})
public class DDMFormXLSExporter
extends BaseDDMFormExporter {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormXLSExporter.class);
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    @Reference
    private DDMFormInstanceVersionLocalService _ddmFormInstanceVersionService;
    @Reference
    private StorageEngine _storageEngine;

    @Override
    public DDMFormFieldTypeServicesTracker getDDMFormFieldTypeServicesTracker() {
        return this._ddmFormFieldTypeServicesTracker;
    }

    @Override
    public DDMFormInstanceVersionLocalService getDDMFormInstanceVersionLocalService() {
        return this._ddmFormInstanceVersionService;
    }

    public String getFormat() {
        return "xls";
    }

    protected CellStyle createCellStyle(Workbook workbook, boolean bold, String fontName, short heightInPoints) {
        Font font = workbook.createFont();
        font.setBold(bold);
        font.setFontHeightInPoints(heightInPoints);
        font.setFontName(fontName);
        CellStyle style = workbook.createCellStyle();
        style.setFont(font);
        return style;
    }

    protected void createDataRow(int rowIndex, Sheet sheet, DateTimeFormatter dateTimeFormatter, String author, String status, Date statusDate, CellStyle style, Map<String, DDMFormField> ddmFormFields, Map<String, BaseDDMFormExporter.DDMFormFieldRenderedValue> values) {
        Row row = sheet.createRow(rowIndex);
        int cellIndex = 0;
        Cell cell = null;
        for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
            cell = row.createCell(cellIndex++, CellType.STRING);
            cell.setCellStyle(style);
            if (values.containsKey(entry.getKey())) {
                BaseDDMFormExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                cell.setCellValue(GetterUtil.getString((String)ddmFormFieldRenderedValue.getValue()));
                continue;
            }
            cell.setCellValue("");
        }
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(status);
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(this.formatDate(statusDate, dateTimeFormatter));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(style);
        cell.setCellValue(author);
    }

    protected void createHeaderRow(Collection<DDMFormField> ddmFormFields, Sheet sheet, Workbook workbook) {
        Row row = sheet.createRow(0);
        CellStyle cellStyle = this.createCellStyle(workbook, true, "Courier New", (short)14);
        int cellIndex = 0;
        Cell cell = null;
        Locale locale = this.getLocale();
        Map<String, String> ddmFormFieldsLabels = this.getDDMFormFieldsLabels(ddmFormFields, locale);
        for (DDMFormField ddmFormField : ddmFormFields) {
            String label = ddmFormFieldsLabels.get(ddmFormField.getName());
            cell = row.createCell(cellIndex++, CellType.STRING);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(label);
        }
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(LanguageUtil.get((Locale)locale, (String)"status"));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(LanguageUtil.get((Locale)locale, (String)"modified-date"));
        cell = row.createCell(cellIndex++, CellType.STRING);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(LanguageUtil.get((Locale)locale, (String)"author"));
    }

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] doExport(long formInstanceId, int status, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

