/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal.exporter;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormExporter;
import com.liferay.dynamic.data.mapping.io.internal.exporter.BaseDDMFormExporter;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormExporter.class})
public class DDMFormCSVExporter
extends BaseDDMFormExporter {
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    @Reference
    private DDMFormInstanceVersionLocalService _ddmFormInstanceVersionService;
    @Reference
    private StorageEngine _storageEngine;

    @Override
    public DDMFormFieldTypeServicesTracker getDDMFormFieldTypeServicesTracker() {
        return this._ddmFormFieldTypeServicesTracker;
    }

    @Override
    public DDMFormInstanceVersionLocalService getDDMFormInstanceVersionLocalService() {
        return this._ddmFormInstanceVersionService;
    }

    public String getFormat() {
        return "csv";
    }

    @Override
    protected byte[] doExport(long formInstanceId, int status, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) throws Exception {
        StringBundler sb = new StringBundler();
        Map<String, DDMFormField> ddmFormFields = this.getDistinctFields(formInstanceId);
        Locale locale = this.getLocale();
        for (DDMFormField ddmFormField : ddmFormFields.values()) {
            LocalizedValue label = ddmFormField.getLabel();
            sb.append(CSVUtil.encode((String)label.getString(locale)));
            sb.append(',');
        }
        sb.append(LanguageUtil.get((Locale)locale, (String)"status"));
        sb.append(',');
        sb.append(LanguageUtil.get((Locale)locale, (String)"modified-date"));
        sb.append(',');
        sb.append(LanguageUtil.get((Locale)locale, (String)"author"));
        sb.append("\n");
        List formInstanceRecords = this._ddmFormInstanceRecordLocalService.getFormInstanceRecords(formInstanceId, status, start, end, orderByComparator);
        Iterator iterator = formInstanceRecords.iterator();
        DateTimeFormatter dateTimeFormatter = this.getDateTimeFormatter();
        while (iterator.hasNext()) {
            DDMFormInstanceRecord record = (DDMFormInstanceRecord)iterator.next();
            DDMFormInstanceRecordVersion recordVersion = record.getFormInstanceRecordVersion();
            DDMFormValues ddmFormValues = this._storageEngine.getDDMFormValues(recordVersion.getStorageId());
            Map<String, BaseDDMFormExporter.DDMFormFieldRenderedValue> values = this.getRenderedValues(ddmFormFields.values(), ddmFormValues);
            for (Map.Entry<String, DDMFormField> entry : ddmFormFields.entrySet()) {
                if (values.containsKey(entry.getKey())) {
                    BaseDDMFormExporter.DDMFormFieldRenderedValue ddmFormFieldRenderedValue = values.get(entry.getKey());
                    sb.append(CSVUtil.encode((String)ddmFormFieldRenderedValue.getValue()));
                } else {
                    sb.append("");
                }
                sb.append(',');
            }
            sb.append(this.getStatusMessage(recordVersion.getStatus()));
            sb.append(',');
            sb.append(this.formatDate(recordVersion.getStatusDate(), dateTimeFormatter));
            sb.append(',');
            sb.append(CSVUtil.encode((String)recordVersion.getUserName()));
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        String csv = sb.toString();
        return csv.getBytes();
    }
}

