/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal.exporter;

import com.liferay.dynamic.data.mapping.io.exporter.DDMExporterFactory;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormExporter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMExporterFactory.class})
public class DDMExporterFactoryImpl
implements DDMExporterFactory {
    private final Map<String, DDMFormExporter> _ddmFormExporters = new ConcurrentHashMap<String, DDMFormExporter>();

    public Set<String> getAvailableFormats() {
        return Collections.unmodifiableSet(this._ddmFormExporters.keySet());
    }

    public Map<String, String> getAvailableFormatsMap() {
        TreeMap<String, String> availableFormatsMap = new TreeMap<String, String>();
        for (String format : this.getAvailableFormats()) {
            DDMFormExporter ddmFormExporter = this.getDDMFormExporter(format);
            availableFormatsMap.put(ddmFormExporter.getLabel(), format);
        }
        return availableFormatsMap;
    }

    public DDMFormExporter getDDMFormExporter(String format) {
        DDMFormExporter ddmExporter = this._ddmFormExporters.get(format);
        if (ddmExporter == null) {
            throw new IllegalArgumentException("No DDM Form exporter exists for the format " + format);
        }
        return ddmExporter;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMFormExporter(DDMFormExporter ddmExporter) {
        this._ddmFormExporters.put(ddmExporter.getFormat(), ddmExporter);
    }

    protected void removeDDMFormExporter(DDMFormExporter ddmExporter) {
        this._ddmFormExporters.remove(ddmExporter.getFormat());
    }
}

