/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal.exporter;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.io.exporter.DDMFormExporter;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.comparator.FormInstanceVersionVersionComparator;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BaseDDMFormExporter
implements DDMFormExporter {
    private Locale _locale;

    public byte[] export(long formInstanceId) throws Exception {
        return this.doExport(formInstanceId, -1, -1, -1, null);
    }

    public byte[] export(long formInstanceId, int status) throws Exception {
        return this.doExport(formInstanceId, status, -1, -1, null);
    }

    public byte[] export(long formInstanceId, int status, int start, int end) throws Exception {
        return this.doExport(formInstanceId, status, start, end, null);
    }

    public byte[] export(long formInstanceId, int status, int start, int end, OrderByComparator<DDMFormInstanceRecord> orderByComparator) throws Exception {
        return this.doExport(formInstanceId, status, start, end, orderByComparator);
    }

    public abstract DDMFormFieldTypeServicesTracker getDDMFormFieldTypeServicesTracker();

    public abstract DDMFormInstanceVersionLocalService getDDMFormInstanceVersionLocalService();

    public Locale getLocale() {
        if (this._locale == null) {
            this._locale = LocaleUtil.getSiteDefault();
        }
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    protected abstract byte[] doExport(long var1, int var3, int var4, int var5, OrderByComparator<DDMFormInstanceRecord> var6) throws Exception;

    protected String formatDate(Date date, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return dateTimeFormatter.format(localDateTime);
    }

    protected DateTimeFormatter getDateTimeFormatter() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
        return dateTimeFormatter.withLocale(this.getLocale());
    }

    protected DDMFormFieldRenderedValue getDDMFormFieldRenderedValue(DDMFormField ddmFormField, Map<String, List<DDMFormFieldValue>> ddmFormFieldValueMap) {
        List<DDMFormFieldValue> ddmForFieldValues = ddmFormFieldValueMap.get(ddmFormField.getName());
        DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker = this.getDDMFormFieldTypeServicesTracker();
        DDMFormFieldValueRenderer ddmFormFieldValueRenderer = ddmFormFieldTypeServicesTracker.getDDMFormFieldValueRenderer(ddmFormField.getType());
        String valueString = HtmlUtil.render((String)ddmFormFieldValueRenderer.render(ddmForFieldValues.get(0), this.getLocale()));
        return new DDMFormFieldRenderedValue(ddmFormField.getName(), ddmFormField.getLabel(), valueString);
    }

    protected Map<String, DDMFormField> getDistinctFields(long formInstanceId) throws Exception {
        List<DDMStructureVersion> ddmStructureVersions = this.getStructureVersions(formInstanceId);
        LinkedHashMap<String, DDMFormField> ddmFormFields = new LinkedHashMap<String, DDMFormField>();
        for (DDMStructureVersion ddmStructureVersion : ddmStructureVersions) {
            DDMForm ddmForm = ddmStructureVersion.getDDMForm();
            ddmFormFields.putAll(ddmForm.getNontransientDDMFormFieldsMap(true));
        }
        return ddmFormFields;
    }

    protected Map<String, DDMFormFieldRenderedValue> getRenderedValues(Collection<DDMFormField> ddmFormFields, DDMFormValues ddmFormValues) throws Exception {
        Map ddmFormFieldValueMap = ddmFormValues.getDDMFormFieldValuesMap();
        Stream<DDMFormField> ddmFormFieldStream = ddmFormFields.stream();
        ddmFormFieldStream = ddmFormFieldStream.filter(ddmFormField -> ddmFormFieldValueMap.containsKey(ddmFormField.getName()));
        Stream<DDMFormFieldRenderedValue> valueStream = ddmFormFieldStream.map(ddmFormField -> this.getDDMFormFieldRenderedValue((DDMFormField)ddmFormField, ddmFormFieldValueMap));
        return valueStream.collect(Collectors.toMap(DDMFormFieldRenderedValue::getFieldName, value -> value));
    }

    protected String getStatusMessage(int status) {
        String statusLabel = WorkflowConstants.getStatusLabel((int)status);
        return LanguageUtil.get((Locale)this._locale, (String)statusLabel);
    }

    protected List<DDMStructureVersion> getStructureVersions(long formInstanceId) throws Exception {
        DDMFormInstanceVersionLocalService ddmFormInstanceVersionLocalService = this.getDDMFormInstanceVersionLocalService();
        List formInstanceVersions = ddmFormInstanceVersionLocalService.getFormInstanceVersions(formInstanceId, -1, -1, null);
        formInstanceVersions = ListUtil.copy((List)formInstanceVersions);
        Collections.sort(formInstanceVersions, new FormInstanceVersionVersionComparator());
        ArrayList<DDMStructureVersion> ddmStructureVersions = new ArrayList<DDMStructureVersion>();
        for (DDMFormInstanceVersion formInstanceVersion : formInstanceVersions) {
            ddmStructureVersions.add(formInstanceVersion.getStructureVersion());
        }
        return ddmStructureVersions;
    }

    protected static class DDMFormFieldRenderedValue {
        private final String _fieldName;
        private final LocalizedValue _label;
        private final String _value;

        protected DDMFormFieldRenderedValue(String fieldName, LocalizedValue label, String value) {
            this._fieldName = fieldName;
            this._label = label;
            this._value = value;
        }

        protected String getFieldName() {
            return this._fieldName;
        }

        protected LocalizedValue getLabel() {
            return this._label;
        }

        protected String getValue() {
            return this._value;
        }
    }
}

