/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONSerializer;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormValuesJSONSerializerImpl
implements DDMFormValuesJSONSerializer {
    private JSONFactory _jsonFactory;

    @Override
    public String serialize(DDMFormValues ddmFormValues) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        this.addAvailableLanguageIds(jsonObject, ddmFormValues.getAvailableLocales());
        this.addDefaultLanguageId(jsonObject, ddmFormValues.getDefaultLocale());
        this.addFieldValues(jsonObject, ddmFormValues.getDDMFormFieldValues());
        return jsonObject.toString();
    }

    protected void addAvailableLanguageIds(JSONObject jsonObject, Set<Locale> availableLocales) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (Locale availableLocale : availableLocales) {
            jsonArray.put(LocaleUtil.toLanguageId((Locale)availableLocale));
        }
        jsonObject.put("availableLanguageIds", jsonArray);
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void addFieldValues(JSONObject jsonObject, List<DDMFormFieldValue> ddmFormFieldValues) {
        jsonObject.put("fieldValues", this.toJSONArray(ddmFormFieldValues));
    }

    protected void addNestedFieldValues(JSONObject jsonObject, List<DDMFormFieldValue> nestedDDMFormFieldValues) {
        if (nestedDDMFormFieldValues.isEmpty()) {
            return;
        }
        jsonObject.put("nestedFieldValues", this.toJSONArray(nestedDDMFormFieldValues));
    }

    protected void addValue(JSONObject jsonObject, Value value) {
        if (value == null) {
            return;
        }
        if (value.isLocalized()) {
            jsonObject.put("value", this.toJSONObject(value));
        } else {
            jsonObject.put("value", value.getString(LocaleUtil.ROOT));
        }
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected JSONArray toJSONArray(List<DDMFormFieldValue> ddmFormFieldValues) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            jsonArray.put(this.toJSONObject(ddmFormFieldValue));
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(DDMFormFieldValue ddmFormFieldValue) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("instanceId", ddmFormFieldValue.getInstanceId());
        jsonObject.put("name", ddmFormFieldValue.getName());
        this.addNestedFieldValues(jsonObject, ddmFormFieldValue.getNestedDDMFormFieldValues());
        this.addValue(jsonObject, ddmFormFieldValue.getValue());
        return jsonObject;
    }

    protected JSONObject toJSONObject(Value value) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        for (Locale availableLocale : value.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), value.getString(availableLocale));
        }
        return jsonObject;
    }
}

