/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormValuesJSONDeserializerImpl
implements DDMFormValuesJSONDeserializer {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormValuesJSONDeserializerImpl.class);
    private JSONFactory _jsonFactory;

    @Override
    public DDMFormValues deserialize(DDMForm ddmForm, String serializedDDMFormValues) {
        DDMFormValues ddmFormValues;
        block2: {
            ddmFormValues = new DDMFormValues(ddmForm);
            try {
                JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedDDMFormValues);
                this.setDDMFormValuesAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmFormValues);
                this.setDDMFormValuesDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmFormValues);
                this.setDDMFormFieldValues(jsonObject.getJSONArray("fieldValues"), ddmFormValues);
                this.setDDMFormLocalizedValuesDefaultLocale(ddmFormValues);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return ddmFormValues;
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
        ddmFormFieldValue.setName(jsonObject.getString("name"));
        this.setDDMFormFieldValueValue(jsonObject, ddmFormFieldValue);
        this.setNestedDDMFormFieldValues(jsonObject.getJSONArray("nestedFieldValues"), ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(JSONArray jsonArray) {
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i));
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        return ddmFormFieldValues;
    }

    protected LocalizedValue getLocalizedValue(JSONObject jsonObject) {
        LocalizedValue localizedValue = new LocalizedValue();
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            if (!LanguageUtil.isAvailableLocale((String)languageId)) continue;
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected Value getValue(JSONObject jsonObject) {
        JSONObject valueJSONObject = jsonObject.getJSONObject("value");
        if (this.isLocalized(valueJSONObject)) {
            return this.getLocalizedValue(valueJSONObject);
        }
        return new UnlocalizedValue(jsonObject.getString("value"));
    }

    protected boolean isInvalidLocale(String languageId) {
        return LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false) == null;
    }

    protected boolean isLocalized(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!this.isInvalidLocale(key)) continue;
            return false;
        }
        return true;
    }

    protected void setDDMFormFieldValueLocalizedValueDefaultLocale(DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) {
        Value value = ddmFormFieldValue.getValue();
        if (value != null && value.isLocalized()) {
            value.setDefaultLocale(defaultLocale);
        }
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(nestedDDMFormFieldValue, defaultLocale);
        }
    }

    protected void setDDMFormFieldValues(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValues(jsonArray);
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    protected void setDDMFormFieldValueValue(JSONObject jsonObject, DDMFormFieldValue ddmFormFieldValue) {
        String valueString = jsonObject.getString("value", null);
        if (valueString == null) {
            return;
        }
        Value value = this.getValue(jsonObject);
        ddmFormFieldValue.setValue(value);
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMFormValues ddmFormValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(ddmFormFieldValue, ddmFormValues.getDefaultLocale());
        }
    }

    protected void setDDMFormValuesAvailableLocales(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        Set<Locale> availableLocales = this.getAvailableLocales(jsonArray);
        ddmFormValues.setAvailableLocales(availableLocales);
    }

    protected void setDDMFormValuesDefaultLocale(String defaultLanguageId, DDMFormValues ddmFormValues) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmFormValues.setDefaultLocale(defaultLocale);
        Set availableLocales = ddmFormValues.getAvailableLocales();
        if (availableLocales != null && !availableLocales.contains(defaultLocale)) {
            availableLocales.add(defaultLocale);
        }
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void setNestedDDMFormFieldValues(JSONArray jsonArray, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormFieldValue> nestedDDMFormFieldValues = this.getDDMFormFieldValues(jsonArray);
        ddmFormFieldValue.setNestedDDMFormFields(nestedDDMFormFieldValues);
    }
}

