/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.io.internal;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DefaultDDMFormFieldTypeSettings;
import com.liferay.dynamic.data.mapping.io.DDMFormJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldRule;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldRuleType;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMFormJSONDeserializerImpl
implements DDMFormJSONDeserializer {
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private JSONFactory _jsonFactory;

    @Override
    public DDMForm deserialize(String serializedDDMForm) throws PortalException {
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedDDMForm);
            DDMForm ddmForm = new DDMForm();
            this.setDDMFormAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmForm);
            this.setDDMFormDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmForm);
            this.setDDMFormFields(jsonObject.getJSONArray("fields"), ddmForm);
            this.setDDMFormLocalizedValuesDefaultLocale(ddmForm);
            return ddmForm;
        }
        catch (JSONException jsone) {
            throw new PortalException((Throwable)jsone);
        }
    }

    protected void addOptionValueLabels(JSONObject jsonObject, DDMFormFieldOptions ddmFormFieldOptions, String optionValue) {
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            ddmFormFieldOptions.addOptionLabel(optionValue, LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
    }

    protected DDMFormFieldOptions deserializeDDMFormFieldOptions(String serializedDDMFormFieldProperty) throws PortalException {
        if (Validator.isNull((String)serializedDDMFormFieldProperty)) {
            return new DDMFormFieldOptions();
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(serializedDDMFormFieldProperty);
        return this.getDDMFormFieldOptions(jsonArray);
    }

    protected Object deserializeDDMFormFieldProperty(String serializedDDMFormFieldProperty, DDMFormField ddmFormFieldTypeSetting) throws PortalException {
        if (ddmFormFieldTypeSetting.isLocalizable()) {
            return this.deserializeLocalizedValue(serializedDDMFormFieldProperty);
        }
        String dataType = ddmFormFieldTypeSetting.getDataType();
        if (Objects.equals(dataType, "boolean")) {
            return Boolean.valueOf(serializedDDMFormFieldProperty);
        }
        if (Objects.equals(dataType, "ddm-options")) {
            return this.deserializeDDMFormFieldOptions(serializedDDMFormFieldProperty);
        }
        if (Objects.equals(dataType, "ddm-validation")) {
            return this.deserializeDDMFormFieldValidation(serializedDDMFormFieldProperty);
        }
        return serializedDDMFormFieldProperty;
    }

    protected DDMFormFieldValidation deserializeDDMFormFieldValidation(String serializedDDMFormFieldProperty) throws PortalException {
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        if (Validator.isNull((String)serializedDDMFormFieldProperty)) {
            return ddmFormFieldValidation;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedDDMFormFieldProperty);
        ddmFormFieldValidation.setExpression(jsonObject.getString("expression"));
        ddmFormFieldValidation.setErrorMessage(jsonObject.getString("errorMessage"));
        return ddmFormFieldValidation;
    }

    protected LocalizedValue deserializeLocalizedValue(String serializedDDMFormFieldProperty) throws PortalException {
        LocalizedValue localizedValue = new LocalizedValue();
        if (Validator.isNull((String)serializedDDMFormFieldProperty)) {
            return localizedValue;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedDDMFormFieldProperty);
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormField getDDMFormField(JSONObject jsonObject) throws PortalException {
        String name = jsonObject.getString("name");
        String type = jsonObject.getString("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        this.setDDMFormFieldProperties(jsonObject, ddmFormField);
        this.setNestedDDMFormField(jsonObject.getJSONArray("nestedFields"), ddmFormField);
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(JSONArray jsonArray) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String value = jsonObject.getString("value");
            ddmFormFieldOptions.addOption(value);
            this.addOptionValueLabels(jsonObject.getJSONObject("label"), ddmFormFieldOptions, value);
        }
        return ddmFormFieldOptions;
    }

    protected DDMFormFieldRule getDDMFormFieldRule(JSONObject jsonObject) {
        String expression = jsonObject.getString("expression");
        DDMFormFieldRuleType ddmFormFieldRuleType = DDMFormFieldRuleType.parse((String)jsonObject.getString("type"));
        return new DDMFormFieldRule(expression, ddmFormFieldRuleType);
    }

    protected List<DDMFormFieldRule> getDDMFormFieldRules(JSONArray jsonArray) {
        ArrayList<DDMFormFieldRule> ddmFormFieldRules = new ArrayList<DDMFormFieldRule>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldRule ddmFormFieldRule = this.getDDMFormFieldRule(jsonArray.getJSONObject(i));
            ddmFormFieldRules.add(ddmFormFieldRule);
        }
        return ddmFormFieldRules;
    }

    protected List<DDMFormField> getDDMFormFields(JSONArray jsonArray) throws PortalException {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormField ddmFormField = this.getDDMFormField(jsonArray.getJSONObject(i));
            ddmFormFields.add(ddmFormField);
        }
        return ddmFormFields;
    }

    protected DDMForm getDDMFormFieldTypeSettingsDDMForm(String type) {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(type);
        Class ddmFormFieldTypeSettings = DefaultDDMFormFieldTypeSettings.class;
        if (ddmFormFieldType != null) {
            ddmFormFieldTypeSettings = ddmFormFieldType.getDDMFormFieldTypeSettings();
        }
        return DDMFormFactory.create(ddmFormFieldTypeSettings);
    }

    protected void setDDMFormAvailableLocales(JSONArray jsonArray, DDMForm ddmForm) {
        Set<Locale> availableLocales = this.getAvailableLocales(jsonArray);
        ddmForm.setAvailableLocales(availableLocales);
    }

    protected void setDDMFormDefaultLocale(String defaultLanguageId, DDMForm ddmForm) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmForm.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormFieldLocalizedValueDefaultLocale(LocalizedValue localizedValue, Locale defaultLocale) {
        if (localizedValue == null) {
            return;
        }
        localizedValue.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormFieldLocalizedValuesDefaultLocale(DDMFormField ddmFormField, Locale defaultLocale) {
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getLabel(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getPredefinedValue(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getStyle(), defaultLocale);
        this.setDDMFormFieldLocalizedValueDefaultLocale(ddmFormField.getTip(), defaultLocale);
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        if (ddmFormFieldOptions != null) {
            ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(nestedDDMFormField, defaultLocale);
        }
    }

    protected void setDDMFormFieldProperties(JSONObject jsonObject, DDMFormField ddmFormField) throws PortalException {
        DDMForm ddmFormFieldTypeSettingsDDMForm = this.getDDMFormFieldTypeSettingsDDMForm(ddmFormField.getType());
        for (DDMFormField ddmFormFieldTypeSetting : ddmFormFieldTypeSettingsDDMForm.getDDMFormFields()) {
            this.setDDMFormFieldProperty(jsonObject, ddmFormField, ddmFormFieldTypeSetting);
        }
        this.setDDMFormFieldRules(jsonObject.getJSONArray("rules"), ddmFormField);
    }

    protected void setDDMFormFieldProperty(JSONObject jsonObject, DDMFormField ddmFormField, DDMFormField ddmFormFieldTypeSetting) throws PortalException {
        String settingName = ddmFormFieldTypeSetting.getName();
        Object deserializedDDMFormFieldProperty = this.deserializeDDMFormFieldProperty(jsonObject.getString(settingName), ddmFormFieldTypeSetting);
        ddmFormField.setProperty(settingName, deserializedDDMFormFieldProperty);
    }

    protected void setDDMFormFieldRules(JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormFieldRule> ddmFormFieldRules = this.getDDMFormFieldRules(jsonArray);
        ddmFormField.setDDMFormFieldRules(ddmFormFieldRules);
    }

    protected void setDDMFormFields(JSONArray jsonArray, DDMForm ddmForm) throws PortalException {
        List<DDMFormField> ddmFormFields = this.getDDMFormFields(jsonArray);
        ddmForm.setDDMFormFields(ddmFormFields);
    }

    @Reference(unbind="-")
    protected void setDDMFormFieldTypeServicesTracker(DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker) {
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMForm ddmForm) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(ddmFormField, ddmForm.getDefaultLocale());
        }
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected void setNestedDDMFormField(JSONArray jsonArray, DDMFormField ddmFormField) throws PortalException {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormField> nestedDDMFormFields = this.getDDMFormFields(jsonArray);
        ddmFormField.setNestedDDMFormFields(nestedDDMFormFields);
    }
}

