Liferay.Loader.define("dynamic-data-mapping-form-web@2.0.96/admin/js/util/StateSyncronizer.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-jsx', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _metalJsx = _interopRequireDefault(require("frontend-js-metal-web$metal-jsx"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var StateSyncronizer = /*#__PURE__*/function (_Component) {
    _inherits(StateSyncronizer, _Component);

    function StateSyncronizer() {
      _classCallCheck(this, StateSyncronizer);

      return _possibleConstructorReturn(this, _getPrototypeOf(StateSyncronizer).apply(this, arguments));
    }

    _createClass(StateSyncronizer, [{
      key: "created",
      value: function created() {
        var _this = this;

        var _this$props = this.props,
            descriptionEditor = _this$props.descriptionEditor,
            nameEditor = _this$props.nameEditor,
            translationManager = _this$props.translationManager;
        this._eventHandler = new _metalEvents.EventHandler();

        this._eventHandler.add(descriptionEditor.on('change', this._handleDescriptionEditorChanged.bind(this)), nameEditor.on('change', this._handleNameEditorChanged.bind(this)));

        if (translationManager) {
          this._eventHandler.add(translationManager.on('deleteAvailableLocale', function (_ref) {
            var locale = _ref.locale;

            _this.deleteLanguageId(locale);
          }), translationManager.on('editingLocaleChange', function (event) {
            _this.syncEditors(event.newVal);
          }));
        }
      }
    }, {
      key: "deleteLanguageId",
      value: function deleteLanguageId(languageId) {
        var _this$props2 = this.props,
            localizedDescription = _this$props2.localizedDescription,
            localizedName = _this$props2.localizedName;
        delete localizedDescription[languageId];
        delete localizedName[languageId];
        this.syncEditors();
      }
    }, {
      key: "disposeInternal",
      value: function disposeInternal() {
        _get(_getPrototypeOf(StateSyncronizer.prototype), "disposeInternal", this).call(this);

        this._eventHandler.removeAllListeners();
      }
    }, {
      key: "getAvailableLanguageIds",
      value: function getAvailableLanguageIds() {
        var translationManager = this.props.translationManager;
        var availableLanguageIds = [{
          id: this.getDefaultLanguageId()
        }];

        if (translationManager) {
          availableLanguageIds = translationManager.get('availableLocales');
        }

        return availableLanguageIds.map(function (_ref2) {
          var id = _ref2.id;
          return id;
        });
      }
    }, {
      key: "getDefaultLanguageId",
      value: function getDefaultLanguageId() {
        var translationManager = this.props.translationManager;
        var defaultLanguageId = themeDisplay.getDefaultLanguageId();

        if (translationManager) {
          defaultLanguageId = translationManager.get('defaultLocale');
        }

        return defaultLanguageId;
      }
    }, {
      key: "getEditingLanguageId",
      value: function getEditingLanguageId() {
        var translationManager = this.props.translationManager;
        var editingLanguageId = this.getDefaultLanguageId();

        if (translationManager) {
          editingLanguageId = translationManager.get('editingLocale');
        }

        return editingLanguageId;
      }
    }, {
      key: "getState",
      value: function getState() {
        var _this$props3 = this.props,
            localizedDescription = _this$props3.localizedDescription,
            localizedName = _this$props3.localizedName,
            store = _this$props3.store;
        var state = {
          availableLanguageIds: this.getAvailableLanguageIds(),
          defaultLanguageId: this.getDefaultLanguageId(),
          description: localizedDescription,
          name: localizedName,
          pages: store.state.pages,
          paginationMode: store.state.paginationMode,
          rules: store.getRules(),
          successPageSettings: store.state.successPageSettings
        };
        return state;
      }
    }, {
      key: "isEmpty",
      value: function isEmpty() {
        var store = this.props.store;
        return FormSupport.emptyPages(store.state.pages);
      }
    }, {
      key: "syncEditors",
      value: function syncEditors() {
        var editingLanguageId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.getDefaultLanguageId();
        var _this$props4 = this.props,
            descriptionEditor = _this$props4.descriptionEditor,
            localizedDescription = _this$props4.localizedDescription,
            localizedName = _this$props4.localizedName,
            nameEditor = _this$props4.nameEditor;
        var description = localizedDescription[editingLanguageId];

        if (!description) {
          description = localizedDescription[this.getDefaultLanguageId()];
        }

        window[descriptionEditor.name].setHTML(description);
        var name = localizedName[editingLanguageId];

        if (!name) {
          name = localizedName[this.getDefaultLanguageId()];
        }

        window[nameEditor.name].setHTML(name);
      }
    }, {
      key: "syncInputs",
      value: function syncInputs() {
        var _this$props5 = this.props,
            namespace = _this$props5.namespace,
            settingsDDMForm = _this$props5.settingsDDMForm;
        var state = this.getState();
        var description = state.description,
            name = state.name;
        Object.keys(state.name).forEach(function (key) {
          state.name[key] = Liferay.Util.unescape(state.name[key]);
        });
        Object.keys(state.description).forEach(function (key) {
          state.description[key] = Liferay.Util.unescape(state.description[key]);
        });

        if (settingsDDMForm) {
          document.querySelector("#".concat(namespace, "serializedSettingsContext")).value = JSON.stringify({
            pages: settingsDDMForm.pages
          });
        }

        document.querySelector("#".concat(namespace, "name")).value = JSON.stringify(name);
        document.querySelector("#".concat(namespace, "description")).value = JSON.stringify(description);
        document.querySelector("#".concat(namespace, "serializedFormBuilderContext")).value = this._getSerializedFormBuilderContext();
      }
    }, {
      key: "_getSerializedFormBuilderContext",
      value: function _getSerializedFormBuilderContext() {
        var _this2 = this;

        var state = this.getState();
        var visitor = new _visitors.PagesVisitor(state.pages);
        var pages = visitor.mapPages(function (page) {
          return _objectSpread({}, page, {
            description: page.localizedDescription,
            title: page.localizedTitle
          });
        });
        visitor.setPages(pages);
        return JSON.stringify(_objectSpread({}, state, {
          pages: visitor.mapFields(function (field) {
            return _objectSpread({}, field, {
              settingsContext: _objectSpread({}, field.settingsContext, {
                availableLanguageIds: _this2.getAvailableLanguageIds(),
                defaultLanguageId: _this2.getDefaultLanguageId(),
                pages: _this2._getSerializedSettingsContextPages(field.settingsContext.pages)
              })
            });
          })
        }));
      }
    }, {
      key: "_getSerializedSettingsContextPages",
      value: function _getSerializedSettingsContextPages(pages) {
        var defaultLanguageId = this.getDefaultLanguageId();
        var visitor = new _visitors.PagesVisitor(pages);
        return visitor.mapFields(function (field) {
          if (field.type === 'options') {
            var _field = field,
                value = _field.value;
            var newValue = {};
            Object.keys(value).forEach(function (locale) {
              newValue[locale] = value[locale].filter(function (_ref3) {
                var value = _ref3.value;
                return value !== '';
              });
            });

            if (!newValue[defaultLanguageId]) {
              newValue[defaultLanguageId] = [];
            }

            field = _objectSpread({}, field, {
              value: newValue
            });
          }

          return field;
        });
      }
    }, {
      key: "_handleDescriptionEditorChanged",
      value: function _handleDescriptionEditorChanged() {
        var _this$props6 = this.props,
            descriptionEditor = _this$props6.descriptionEditor,
            localizedDescription = _this$props6.localizedDescription;
        var editor = window[descriptionEditor.name];
        localizedDescription[this.getEditingLanguageId()] = editor.getHTML();
      }
    }, {
      key: "_handleNameEditorChanged",
      value: function _handleNameEditorChanged() {
        var _this$props7 = this.props,
            localizedName = _this$props7.localizedName,
            nameEditor = _this$props7.nameEditor;
        var editor = window[nameEditor.name];
        localizedName[this.getEditingLanguageId()] = editor.getHTML();
      }
    }]);

    return StateSyncronizer;
  }(_metalJsx["default"]);

  StateSyncronizer.PROPS = {
    descriptionEditor: _metalState.Config.any(),
    localizedDescription: _metalState.Config.object().value({}),
    localizedName: _metalState.Config.object().value({}),
    nameEditor: _metalState.Config.any(),
    namespace: _metalState.Config.string().required(),
    published: _metalState.Config.bool(),
    settingsDDMForm: _metalState.Config.any(),
    store: _metalState.Config.any(),
    translationManager: _metalState.Config.any()
  };
  var _default = StateSyncronizer;
  exports["default"] = _default;
  //# sourceMappingURL=StateSyncronizer.es.js.map
});
//# sourceMappingURL=StateSyncronizer.es.js.map