/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.form.values.query.DDMFormValuesQuery;
import com.liferay.dynamic.data.mapping.form.values.query.DDMFormValuesQueryFactory;
import com.liferay.dynamic.data.mapping.form.web.internal.portlet.action.SaveFormInstanceMVCActionCommand;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.Portal;
import java.io.Serializable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", "mvc.command.name=publishFormInstance"}, service={MVCActionCommand.class})
public class PublishFormInstanceMVCActionCommand
extends SaveFormInstanceMVCActionCommand {
    private DDMFormValuesQueryFactory _ddmFormValuesQueryFactory;
    private DDMFormInstanceService _formInstanceService;
    @Reference
    private Portal _portal;
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private RoleLocalService _roleLocalService;

    @Override
    protected void doService(ActionRequest actionRequest, ActionResponse actionResponse, LiferayPortletURL portletURL) throws Exception {
        DDMFormInstance ddmFormInstance = this.saveFormInstanceMVCCommandHelper.saveFormInstance((PortletRequest)actionRequest, (PortletResponse)actionResponse, true);
        boolean published = !this._isFormInstancePublished(ddmFormInstance);
        this.updateFormInstancePermission(actionRequest, ddmFormInstance.getFormInstanceId(), published);
        DDMFormValues settingsDDMFormValues = ddmFormInstance.getSettingsDDMFormValues();
        this.updatePublishedDDMFormFieldValue(settingsDDMFormValues, published);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMFormInstance.class.getName(), (PortletRequest)actionRequest);
        if (published) {
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
        } else {
            DDMFormInstanceVersion latestFormInstanceVersion = ddmFormInstance.getFormInstanceVersion(ddmFormInstance.getVersion());
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(latestFormInstanceVersion.getStatus()));
        }
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        DDMStructureVersion latestDDMStructureVersion = ddmStructure.getLatestStructureVersion();
        ddmFormInstance = this._formInstanceService.updateFormInstance(ddmFormInstance.getFormInstanceId(), ddmFormInstance.getNameMap(), ddmFormInstance.getDescriptionMap(), latestDDMStructureVersion.getDDMForm(), latestDDMStructureVersion.getDDMFormLayout(), settingsDDMFormValues, serviceContext);
        portletURL.setParameter("formInstanceId", String.valueOf(ddmFormInstance.getFormInstanceId()));
        portletURL.setParameter("showPublishAlert", Boolean.TRUE.toString());
    }

    @Reference(unbind="-")
    protected void setDDMFormInstanceService(DDMFormInstanceService formInstanceService) {
        this._formInstanceService = formInstanceService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesQueryFactory(DDMFormValuesQueryFactory ddmFormValuesQueryFactory) {
        this._ddmFormValuesQueryFactory = ddmFormValuesQueryFactory;
    }

    @Reference(unbind="-")
    protected void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    protected void updateFormInstancePermission(ActionRequest actionRequest, long formInstanceId, boolean published) throws PortalException {
        long companyId = this._portal.getCompanyId((PortletRequest)actionRequest);
        Role role = this._roleLocalService.getRole(companyId, "Guest");
        ResourcePermission resourcePermission = this._resourcePermissionLocalService.getResourcePermission(role.getCompanyId(), DDMFormInstance.class.getName(), 4, String.valueOf(formInstanceId), role.getRoleId());
        if (published) {
            resourcePermission.addResourceAction("ADD_FORM_INSTANCE_RECORD");
        } else {
            resourcePermission.removeResourceAction("ADD_FORM_INSTANCE_RECORD");
        }
        this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
    }

    protected void updatePublishedDDMFormFieldValue(DDMFormValues ddmFormValues, boolean published) throws PortalException {
        DDMFormValuesQuery ddmFormValuesQuery = this._ddmFormValuesQueryFactory.create(ddmFormValues, "/published");
        DDMFormFieldValue ddmFormFieldValue = ddmFormValuesQuery.selectSingleDDMFormFieldValue();
        Value value = ddmFormFieldValue.getValue();
        value.addString(ddmFormValues.getDefaultLocale(), Boolean.toString(published));
    }

    private boolean _isFormInstancePublished(DDMFormInstance formInstance) throws PortalException {
        DDMFormInstanceSettings ddmFormInstanceSettings = formInstance.getSettingsModel();
        return ddmFormInstanceSettings.published();
    }
}

