/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.instance.lifecycle;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AddDefaultSharedFormLayoutPortalInstanceLifecycleListener.class, PortalInstanceLifecycleListener.class})
public class AddDefaultSharedFormLayoutPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private RoleLocalService _roleLocalService;
    private UserLocalService _userLocalService;

    public String getFormLayoutURL(ThemeDisplay themeDisplay, boolean privateLayout) {
        StringBundler sb = new StringBundler(3);
        sb.append(themeDisplay.getPortalURL());
        Group group = themeDisplay.getSiteGroup();
        sb.append(group.getPathFriendlyURL(privateLayout, themeDisplay));
        sb.append("/forms/shared/-/form/");
        return sb.toString();
    }

    public boolean isSharedLayout(ThemeDisplay themeDisplay) {
        Layout layout = themeDisplay.getLayout();
        String type = layout.getType();
        return type.equals("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet");
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        Layout sharedLayout;
        Group group = this._groupLocalService.fetchFriendlyURLGroup(company.getCompanyId(), "/forms");
        if (group == null) {
            group = this.addFormsGroup(company.getCompanyId());
        }
        if ((sharedLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), false, "/shared")) == null) {
            sharedLayout = this.addPublicLayout(company.getCompanyId(), group.getGroupId());
        }
        this.verifyLayout(sharedLayout);
        Layout privateLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(group.getGroupId(), true, "/shared");
        if (privateLayout == null) {
            privateLayout = this.addPrivateLayout(company.getCompanyId(), group.getGroupId());
        }
        this.verifyLayout(privateLayout);
    }

    protected Group addFormsGroup(long companyId) throws PortalException {
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), "Forms");
        return this._groupLocalService.addGroup(defaultUserId, 0L, null, 0L, 0L, nameMap, null, 3, true, 0, "/forms", false, false, true, null);
    }

    protected Layout addPrivateLayout(long companyId, long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("layoutUpdateable", (Serializable)Boolean.FALSE);
        serviceContext.setScopeGroupId(groupId);
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        serviceContext.setUserId(defaultUserId);
        Layout layout = this._layoutLocalService.addLayout(defaultUserId, groupId, true, 0L, "Shared", "", "", "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet", true, "/shared", serviceContext);
        this.updateUserLayoutViewPermissionPermission(companyId, layout);
        return layout;
    }

    protected Layout addPublicLayout(long companyId, long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("layoutUpdateable", (Serializable)Boolean.FALSE);
        serviceContext.setScopeGroupId(groupId);
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        serviceContext.setUserId(defaultUserId);
        return this._layoutLocalService.addLayout(defaultUserId, groupId, false, 0L, "Shared", "", "", "com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet", true, "/shared", serviceContext);
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    protected void updateUserLayoutViewPermissionPermission(long companyId, Layout layout) throws PortalException {
        Role role = this._roleLocalService.getRole(companyId, "User");
        this._resourcePermissionLocalService.addResourcePermission(role.getCompanyId(), Layout.class.getName(), 2, String.valueOf(layout.getGroupId()), role.getRoleId(), "VIEW");
    }

    protected void verifyLayout(Layout layout) throws PortalException {
        if (StringUtil.equals((String)layout.getType(), (String)"com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet")) {
            return;
        }
        layout.setType("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet");
        this._layoutLocalService.updateLayout(layout);
    }
}

