/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.exception.FormInstanceSettingsRedirectURLException;
import com.liferay.dynamic.data.mapping.exception.StructureDefinitionException;
import com.liferay.dynamic.data.mapping.exception.StructureLayoutException;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializer;
import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextDeserializerRequest;
import com.liferay.dynamic.data.mapping.form.web.internal.portlet.action.util.DDMFormInstanceFieldSettingsValidator;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SaveFormInstanceMVCCommandHelper.class})
public class SaveFormInstanceMVCCommandHelper {
    @Reference(target="(dynamic.data.mapping.form.builder.context.deserializer.type=form)")
    protected DDMFormContextDeserializer<DDMForm> ddmFormBuilderContextToDDMForm;
    @Reference(target="(dynamic.data.mapping.form.builder.context.deserializer.type=formLayout)")
    protected DDMFormContextDeserializer<DDMFormLayout> ddmFormBuilderContextToDDMFormLayout;
    @Reference(target="(dynamic.data.mapping.form.builder.context.deserializer.type=formValues)")
    protected DDMFormContextDeserializer<DDMFormValues> ddmFormTemplateContextToDDMFormValues;
    @Reference
    protected DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer;
    @Reference
    protected volatile DDMFormInstanceFieldSettingsValidator formInstanceFieldSettingsValidator;
    @Reference
    protected DDMFormInstanceService formInstanceService;
    @Reference
    protected JSONFactory jsonFactory;
    @Reference
    private Portal _portal;

    public DDMFormInstance saveFormInstance(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return this.saveFormInstance(portletRequest, portletResponse, false);
    }

    public DDMFormInstance saveFormInstance(PortletRequest portletRequest, PortletResponse portletResponse, boolean validateDDMFormFieldSettings) throws Exception {
        long formInstanceId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"formInstanceId");
        if (formInstanceId == 0L) {
            return this.addFormInstance(portletRequest, validateDDMFormFieldSettings);
        }
        return this.updateFormInstance(portletRequest, formInstanceId, validateDDMFormFieldSettings);
    }

    protected DDMFormInstance addFormInstance(PortletRequest portletRequest, boolean validateFormFieldsSettings) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMFormInstance.class.getName(), (PortletRequest)portletRequest);
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
        DDMForm ddmForm = this.getDDMForm(portletRequest, serviceContext);
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(portletRequest);
        Map<Locale, String> nameMap = this.getLocalizedMap(name, ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
        Map<Locale, String> descriptionMap = this.getLocalizedMap(description, ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
        if (ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"saveAsDraft")) {
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(2));
        }
        if (validateFormFieldsSettings) {
            this.formInstanceFieldSettingsValidator.validate(portletRequest, ddmForm);
        }
        DDMFormValues settingsDDMFormValues = this.getSettingsDDMFormValues(portletRequest);
        this.validateRedirectURL(settingsDDMFormValues);
        return this.formInstanceService.addFormInstance(groupId, nameMap, descriptionMap, ddmForm, ddmFormLayout, settingsDDMFormValues, serviceContext);
    }

    protected DDMForm getDDMForm(PortletRequest portletRequest, ServiceContext serviceContext) throws PortalException {
        try {
            String serializedFormBuilderContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"serializedFormBuilderContext");
            return (DDMForm)this.ddmFormBuilderContextToDDMForm.deserialize(DDMFormContextDeserializerRequest.with((String)serializedFormBuilderContext));
        }
        catch (PortalException pe) {
            throw new StructureDefinitionException((Throwable)pe);
        }
    }

    protected DDMFormLayout getDDMFormLayout(PortletRequest portletRequest) throws PortalException {
        try {
            String serializedFormBuilderContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"serializedFormBuilderContext");
            return (DDMFormLayout)this.ddmFormBuilderContextToDDMFormLayout.deserialize(DDMFormContextDeserializerRequest.with((String)serializedFormBuilderContext));
        }
        catch (PortalException pe) {
            throw new StructureLayoutException((Throwable)pe);
        }
    }

    protected Map<Locale, String> getLocalizedMap(String value, Set<Locale> availableLocales, Locale defaultLocale) throws PortalException {
        HashMap<Locale, String> localizedMap = new HashMap<Locale, String>();
        JSONObject jsonObject = this.jsonFactory.createJSONObject(value);
        String defaultValueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)defaultLocale));
        for (Locale availableLocale : availableLocales) {
            String valueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)availableLocale), defaultValueString);
            localizedMap.put(availableLocale, valueString);
        }
        return localizedMap;
    }

    protected DDMFormValues getSettingsDDMFormValues(PortletRequest portletRequest) throws PortalException {
        String settingsContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"serializedSettingsContext");
        DDMFormValues settingsDDMFormValues = (DDMFormValues)this.ddmFormTemplateContextToDDMFormValues.deserialize(DDMFormContextDeserializerRequest.with((DDMForm)DDMFormFactory.create(DDMFormInstanceSettings.class), (String)settingsContext));
        return settingsDDMFormValues;
    }

    protected DDMFormInstance updateFormInstance(PortletRequest portletRequest, long formInstanceId, boolean validateFormFieldsSettings) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMFormInstance.class.getName(), (PortletRequest)portletRequest);
        String name = ParamUtil.getString((PortletRequest)portletRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)portletRequest, (String)"description");
        DDMForm ddmForm = this.getDDMForm(portletRequest, serviceContext);
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(portletRequest);
        Map<Locale, String> nameMap = this.getLocalizedMap(name, ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
        Map<Locale, String> descriptionMap = this.getLocalizedMap(description, ddmForm.getAvailableLocales(), ddmForm.getDefaultLocale());
        if (ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"saveAsDraft")) {
            serviceContext.setAttribute("status", (Serializable)Integer.valueOf(2));
        }
        if (validateFormFieldsSettings) {
            this.formInstanceFieldSettingsValidator.validate(portletRequest, ddmForm);
        }
        DDMFormValues settingsDDMFormValues = this.getSettingsDDMFormValues(portletRequest);
        this.validateRedirectURL(settingsDDMFormValues);
        return this.formInstanceService.updateFormInstance(formInstanceId, nameMap, descriptionMap, ddmForm, ddmFormLayout, settingsDDMFormValues, serviceContext);
    }

    protected void validateRedirectURL(DDMFormValues settingsDDMFormValues) throws PortalException {
        Map ddmFormFieldValuesMap = settingsDDMFormValues.getDDMFormFieldValuesMap();
        if (!ddmFormFieldValuesMap.containsKey("redirectURL")) {
            return;
        }
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("redirectURL");
        DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        Value value = ddmFormFieldValue.getValue();
        for (Locale availableLocale : value.getAvailableLocales()) {
            String escapedRedirect;
            String valueString = value.getString(availableLocale);
            if (!Validator.isNotNull((String)valueString) || !Validator.isNull((String)(escapedRedirect = this._portal.escapeRedirect(valueString)))) continue;
            throw new FormInstanceSettingsRedirectURLException();
        }
    }
}

