/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.exception.RequiredFormInstanceException;
import com.liferay.dynamic.data.mapping.form.values.query.DDMFormValuesQuery;
import com.liferay.dynamic.data.mapping.form.values.query.DDMFormValuesQueryFactory;
import com.liferay.dynamic.data.mapping.form.web.internal.portlet.action.util.BaseDDMFormMVCResourceCommand;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.Serializable;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", "mvc.command.name=publishFormInstance"}, service={MVCResourceCommand.class})
public class PublishFormInstanceMVCResourceCommand
extends BaseDDMFormMVCResourceCommand {
    private DDMFormValuesQueryFactory _ddmFormValuesQueryFactory;
    private DDMFormInstanceService _formInstanceService;
    @Reference
    private Portal _portal;
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private RoleLocalService _roleLocalService;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            long formInstanceId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"formInstanceId");
            if (formInstanceId == 0L) {
                throw new RequiredFormInstanceException();
            }
            boolean published = ParamUtil.getBoolean((PortletRequest)resourceRequest, (String)"published");
            this.updateFormInstancePermission(resourceRequest, formInstanceId, published);
            DDMFormInstance formInstance = this._formInstanceService.getFormInstance(formInstanceId);
            DDMFormValues settingsDDMFormValues = formInstance.getSettingsDDMFormValues();
            this.updatePublishedDDMFormFieldValue(settingsDDMFormValues, published);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMFormInstance.class.getName(), (PortletRequest)resourceRequest);
            if (published) {
                serviceContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            } else {
                DDMFormInstanceVersion latestFormInstanceVersion = formInstance.getFormInstanceVersion(formInstance.getVersion());
                serviceContext.setAttribute("status", (Serializable)Integer.valueOf(latestFormInstanceVersion.getStatus()));
            }
            DDMStructure ddmStructure = formInstance.getStructure();
            this._formInstanceService.updateFormInstance(formInstanceId, formInstance.getNameMap(), formInstance.getDescriptionMap(), ddmStructure.getDDMForm(), ddmStructure.getDDMFormLayout(), settingsDDMFormValues, serviceContext);
            this.writeResponse(resourceRequest, resourceResponse, formInstance);
        }
        catch (Throwable t) {
            resourceResponse.setProperty("portlet.http-status-code", String.valueOf(400));
        }
    }

    @Reference(unbind="-")
    protected void setDDMFormInstanceService(DDMFormInstanceService formInstanceService) {
        this._formInstanceService = formInstanceService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesQueryFactory(DDMFormValuesQueryFactory ddmFormValuesQueryFactory) {
        this._ddmFormValuesQueryFactory = ddmFormValuesQueryFactory;
    }

    @Reference(unbind="-")
    protected void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this._roleLocalService = roleLocalService;
    }

    protected void updateFormInstancePermission(ResourceRequest resourceRequest, long formInstanceId, boolean published) throws PortalException {
        long companyId = this._portal.getCompanyId((PortletRequest)resourceRequest);
        Role role = this._roleLocalService.getRole(companyId, "Guest");
        ResourcePermission resourcePermission = this._resourcePermissionLocalService.getResourcePermission(role.getCompanyId(), DDMFormInstance.class.getName(), 4, String.valueOf(formInstanceId), role.getRoleId());
        if (published) {
            resourcePermission.addResourceAction("ADD_FORM_INSTANCE_RECORD");
        } else {
            resourcePermission.removeResourceAction("ADD_FORM_INSTANCE_RECORD");
        }
        this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
    }

    protected void updatePublishedDDMFormFieldValue(DDMFormValues ddmFormValues, boolean published) throws PortalException {
        DDMFormValuesQuery ddmFormValuesQuery = this._ddmFormValuesQueryFactory.create(ddmFormValues, "/published");
        DDMFormFieldValue ddmFormFieldValue = ddmFormValuesQuery.selectSingleDDMFormFieldValue();
        Value value = ddmFormFieldValue.getValue();
        value.addString(ddmFormValues.getDefaultLocale(), Boolean.toString(published));
    }
}

