/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorContext;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AddFormInstanceRecordMVCCommandHelper.class})
public class AddFormInstanceRecordMVCCommandHelper {
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference
    private DDMFormInstanceService _ddmFormInstanceService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private Portal _portal;

    public void updateRequiredFieldsAccordingToVisibility(ActionRequest actionRequest, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) throws Exception {
        List<DDMFormField> requiredFields = this.getRequiredFields(ddmForm);
        if (requiredFields.isEmpty()) {
            return;
        }
        DDMFormEvaluationResult ddmFormEvaluationResult = this.evaluate(actionRequest, ddmForm, ddmFormValues, locale);
        Set<String> invisibleFields = this.getInvisibleFields(ddmFormEvaluationResult);
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(actionRequest);
        Set<String> fieldsFromDisabledPages = this.getFieldNamesFromDisabledPages(ddmFormEvaluationResult, ddmFormLayout);
        invisibleFields.addAll(fieldsFromDisabledPages);
        if (invisibleFields.isEmpty()) {
            return;
        }
        this.removeRequiredProperty(invisibleFields, requiredFields);
    }

    protected DDMFormEvaluationResult evaluate(ActionRequest actionRequest, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) throws Exception {
        DDMFormEvaluatorContext ddmFormEvaluatorContext = new DDMFormEvaluatorContext(ddmForm, ddmFormValues, locale);
        ddmFormEvaluatorContext.addProperty("groupId", (Object)ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId"));
        ddmFormEvaluatorContext.addProperty("request", (Object)this._portal.getHttpServletRequest((PortletRequest)actionRequest));
        return this._ddmFormEvaluator.evaluate(ddmFormEvaluatorContext);
    }

    protected DDMFormLayout getDDMFormLayout(ActionRequest actionRequest) throws PortalException {
        long formInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"formInstanceId");
        DDMFormInstance formInstance = this._ddmFormInstanceService.getFormInstance(formInstanceId);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(formInstance.getStructureId());
        return ddmStructure.getDDMFormLayout();
    }

    protected Set<String> getFieldNamesFromDisabledPages(DDMFormEvaluationResult ddmFormEvaluationResult, DDMFormLayout ddmFormLayout) {
        Set disabledPagesIndexes = ddmFormEvaluationResult.getDisabledPagesIndexes();
        Stream disablePagesIndexesStream = disabledPagesIndexes.stream();
        Stream fieldsStream = disablePagesIndexesStream.map(index -> this.getFieldNamesFromPage((int)index, ddmFormLayout)).flatMap(field -> field.stream());
        return fieldsStream.collect(Collectors.toSet());
    }

    protected Set<String> getFieldNamesFromPage(int index, DDMFormLayout ddmFormLayout) {
        DDMFormLayoutPage ddmFormLayoutPage = ddmFormLayout.getDDMFormLayoutPage(index);
        List ddmFormLayoutRows = ddmFormLayoutPage.getDDMFormLayoutRows();
        HashSet<String> fieldNames = new HashSet<String>();
        for (DDMFormLayoutRow ddmFormLayoutRow : ddmFormLayoutRows) {
            for (DDMFormLayoutColumn ddmFormLayoutColumn : ddmFormLayoutRow.getDDMFormLayoutColumns()) {
                fieldNames.addAll(ddmFormLayoutColumn.getDDMFormFieldNames());
            }
        }
        return fieldNames;
    }

    protected Set<String> getInvisibleFields(DDMFormEvaluationResult ddmFormEvaluationResult) {
        List ddmFormFieldEvaluationResults = ddmFormEvaluationResult.getDDMFormFieldEvaluationResults();
        Stream<Object> stream = ddmFormFieldEvaluationResults.stream();
        stream = stream.filter(result -> !result.isVisible());
        Stream<String> fieldNameStream = stream.map(result -> result.getName());
        return fieldNameStream.collect(Collectors.toSet());
    }

    protected List<DDMFormField> getRequiredFields(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Collection ddmFormFields = ddmFormFieldsMap.values();
        Stream<Object> stream = ddmFormFields.stream();
        stream = stream.filter(ddmFormField -> ddmFormField.isRequired());
        return stream.collect(Collectors.toList());
    }

    protected void removeRequiredProperty(DDMFormField ddmFormField) {
        ddmFormField.setRequired(false);
    }

    protected void removeRequiredProperty(Set<String> invisibleFields, List<DDMFormField> requiredFields) {
        Stream<Object> stream = requiredFields.stream();
        stream = stream.filter(field -> invisibleFields.contains(field.getName()));
        stream.forEach(this::removeRequiredProperty);
    }
}

