/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action;

import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.form.web.internal.portlet.action.AddFormInstanceRecordMVCCommandHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet", "mvc.command.name=addFormInstanceRecord"}, service={MVCActionCommand.class})
public class AddFormInstanceRecordMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private AddFormInstanceRecordMVCCommandHelper _addFormInstanceMVCCommandHelper;
    private DDMFormInstanceRecordService _ddmFormInstanceRecordService;
    @Reference
    private DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;
    private DDMFormInstanceService _ddmFormInstanceService;
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long formInstanceId;
        PortletSession portletSession = actionRequest.getPortletSession();
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        if (groupId == 0L) {
            groupId = GetterUtil.getLong((Object)portletSession.getAttribute("GROUP_ID"));
        }
        if ((formInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"formInstanceId")) == 0L) {
            formInstanceId = GetterUtil.getLong((Object)portletSession.getAttribute("DYNAMIC_DATA_MAPPING_FORM_INSTANCE_ID"));
        }
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceService.getFormInstance(formInstanceId);
        this.validateCaptcha(actionRequest, ddmFormInstance);
        DDMForm ddmForm = this.getDDMForm(ddmFormInstance);
        DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create((PortletRequest)actionRequest, ddmForm);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._addFormInstanceMVCCommandHelper.updateRequiredFieldsAccordingToVisibility(actionRequest, ddmForm, ddmFormValues, themeDisplay.getLocale());
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMFormInstanceRecord.class.getName(), (PortletRequest)actionRequest);
        serviceContext.setRequest(this._portal.getHttpServletRequest((PortletRequest)actionRequest));
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.fetchLatestFormInstanceRecordVersion(themeDisplay.getUserId(), formInstanceId, ddmFormInstance.getVersion(), 2);
        if (ddmFormInstanceRecordVersion == null) {
            this._ddmFormInstanceRecordService.addFormInstanceRecord(groupId, formInstanceId, ddmFormValues, serviceContext);
        } else {
            this._ddmFormInstanceRecordService.updateFormInstanceRecord(ddmFormInstanceRecordVersion.getFormInstanceRecordId(), false, ddmFormValues, serviceContext);
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            DDMFormInstanceSettings formInstanceSettings = ddmFormInstance.getSettingsModel();
            String redirectURL = formInstanceSettings.redirectURL();
            if (Validator.isNotNull((String)redirectURL)) {
                portletSession.setAttribute("DYNAMIC_DATA_MAPPING_FORM_INSTANCE_ID", (Object)formInstanceId);
                portletSession.setAttribute("GROUP_ID", (Object)groupId);
                this.sendRedirect(actionRequest, actionResponse, redirectURL);
            } else {
                DDMFormSuccessPageSettings ddmFormSuccessPageSettings = ddmForm.getDDMFormSuccessPageSettings();
                if (ddmFormSuccessPageSettings.isEnabled()) {
                    String portletId = this._portal.getPortletId((PortletRequest)actionRequest);
                    SessionMessages.add((PortletRequest)actionRequest, (String)portletId.concat(".hideDefaultSuccessMessage"));
                }
            }
        }
    }

    protected DDMForm getDDMForm(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        return ddmStructure.getDDMForm();
    }

    @Reference(unbind="-")
    protected void setDDMFormInstanceRecordService(DDMFormInstanceRecordService ddmFormInstanceRecordService) {
        this._ddmFormInstanceRecordService = ddmFormInstanceRecordService;
    }

    @Reference(unbind="-")
    protected void setDDMFormInstanceService(DDMFormInstanceService ddmFormInstanceService) {
        this._ddmFormInstanceService = ddmFormInstanceService;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesFactory(DDMFormValuesFactory ddmFormValuesFactory) {
        this._ddmFormValuesFactory = ddmFormValuesFactory;
    }

    protected void validateCaptcha(ActionRequest actionRequest, DDMFormInstance ddmFormInstance) throws Exception {
        DDMFormInstanceSettings formInstanceSettings = ddmFormInstance.getSettingsModel();
        if (formInstanceSettings.requireCaptcha()) {
            try {
                CaptchaUtil.check((PortletRequest)actionRequest);
            }
            catch (CaptchaTextException cte) {
                SessionErrors.add((PortletRequest)actionRequest, (String)CaptchaTextException.class.getName());
                throw cte;
            }
        }
    }
}

