/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class DDMFormExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormExportImportPortletPreferencesProcessor.class);
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;
    @Reference
    private DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    @Reference(unbind="-")
    private GroupLocalService _groupLocalService;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        DDMFormInstance ddmFormInstance;
        try {
            portletDataContext.addPortletPermissions("com.liferay.dynamic.data.mapping");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        String portletId = portletDataContext.getPortletId();
        long formInstanceId = GetterUtil.getLong((String)portletPreferences.getValue("formInstanceId", null));
        if (formInstanceId == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("FormInstance ID is not set for preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        long formInstanceGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", ""));
        if (formInstanceGroupId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No group ID found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        Group group = this._groupLocalService.fetchGroup(formInstanceGroupId);
        if (ExportImportThreadLocal.isStagingInProcess() && !group.isStagedPortlet("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Form instance is not staged in the site " + group.getName()));
            }
            return portletPreferences;
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        if (formInstanceGroupId != previousScopeGroupId) {
            portletDataContext.setScopeGroupId(formInstanceGroupId);
        }
        if ((ddmFormInstance = this._ddmFormInstanceLocalService.fetchFormInstance(formInstanceId)) != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)ddmFormInstance);
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.dynamic.data.mapping");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long importGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", null));
        long groupId = MapUtil.getLong((Map)groupIds, (long)importGroupId, (long)importGroupId);
        long importedFormInstanceId = GetterUtil.getLong((String)portletPreferences.getValue("formInstanceId", null));
        Map formInstanceGroupIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstance.class + ".groupId");
        if (formInstanceGroupIds.containsKey(importedFormInstanceId)) {
            groupId = (Long)formInstanceGroupIds.get(importedFormInstanceId);
        }
        portletDataContext.setScopeGroupId(groupId);
        Map formInstanceIds = portletDataContext.getNewPrimaryKeysMap(DDMFormInstance.class);
        long formInstanceId = MapUtil.getLong((Map)formInstanceIds, (long)importedFormInstanceId, (long)importedFormInstanceId);
        try {
            portletPreferences.setValue("formInstanceId", String.valueOf(formInstanceId));
            portletPreferences.setValue("groupId", String.valueOf(groupId));
        }
        catch (ReadOnlyException roe) {
            throw new PortletDataException("Unable to update portlet preferences during import", (Throwable)roe);
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }
}

