/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.display.context;

import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.form.web.internal.security.permission.resource.DDMFormInstancePermission;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceVersion;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceService;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceVersionLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesMerger;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;

public class DDMFormDisplayContext {
    private static final String _DDM_FORM_FIELD_NAME_CAPTCHA = "_CAPTCHA_";
    private static final Log _log = LogFactoryUtil.getLog(DDMFormDisplayContext.class);
    private Boolean _autosaveEnabled;
    private final String _containerId;
    private DDMFormInstance _ddmFormInstance;
    private long _ddmFormInstanceId;
    private final DDMFormInstanceLocalService _ddmFormInstanceLocalService;
    private final DDMFormInstanceRecordVersionLocalService _ddmFormInstanceRecordVersionLocalService;
    private final DDMFormInstanceService _ddmFormInstanceService;
    private final DDMFormInstanceVersionLocalService _ddmFormInstanceVersionLocalService;
    private final DDMFormRenderer _ddmFormRenderer;
    private final DDMFormValuesFactory _ddmFormValuesFactory;
    private final DDMFormValuesMerger _ddmFormValuesMerger;
    private final GroupLocalService _groupLocalService;
    private Boolean _hasAddFormInstanceRecordPermission;
    private Boolean _hasViewPermission;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private Boolean _showConfigurationIcon;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public DDMFormDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, DDMFormInstanceLocalService ddmFormInstanceLocalService, DDMFormInstanceRecordVersionLocalService ddmFormInstanceRecordVersionLocalService, DDMFormInstanceService ddmFormInstanceService, DDMFormInstanceVersionLocalService ddmFormInstanceVersionLocalService, DDMFormRenderer ddmFormRenderer, DDMFormValuesFactory ddmFormValuesFactory, DDMFormValuesMerger ddmFormValuesMerger, GroupLocalService groupLocalService, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) throws PortalException {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ddmFormInstanceLocalService = ddmFormInstanceLocalService;
        this._ddmFormInstanceRecordVersionLocalService = ddmFormInstanceRecordVersionLocalService;
        this._ddmFormInstanceService = ddmFormInstanceService;
        this._ddmFormInstanceVersionLocalService = ddmFormInstanceVersionLocalService;
        this._ddmFormRenderer = ddmFormRenderer;
        this._ddmFormValuesFactory = ddmFormValuesFactory;
        this._ddmFormValuesMerger = ddmFormValuesMerger;
        this._groupLocalService = groupLocalService;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
        this._containerId = StringUtil.randomString();
        if (Validator.isNotNull((String)this.getPortletResource())) {
            return;
        }
        DDMFormInstance ddmFormInstance = this._ddmFormInstanceLocalService.fetchDDMFormInstance(this.getFormInstanceId());
        if (ddmFormInstance == null || !this.hasViewPermission()) {
            renderRequest.setAttribute("PORTLET_CONFIGURATOR_VISIBILITY", (Object)Boolean.TRUE);
        }
    }

    public String[] getAvailableLanguageIds() throws PortalException {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        Set siteAvailablesLocales = LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId());
        DDMForm ddmForm = this.getDDMForm();
        Set availableLocales = ddmForm.getAvailableLocales();
        Stream localeStreams = availableLocales.stream();
        return (String[])localeStreams.filter(locale -> siteAvailablesLocales.contains(locale)).map(locale -> LanguageUtil.getLanguageId((Locale)locale)).toArray(String[]::new);
    }

    public String getContainerId() {
        return this._containerId;
    }

    public String getDDMFormHTML() throws PortalException {
        DDMFormInstance ddmFormInstance = this.getFormInstance();
        if (ddmFormInstance == null) {
            return "";
        }
        boolean requireCaptcha = this.isCaptchaRequired(ddmFormInstance);
        DDMForm ddmForm = this.getDDMForm(ddmFormInstance, requireCaptcha);
        DDMFormLayout ddmFormLayout = this.getDDMFormLayout(ddmFormInstance, requireCaptcha);
        DDMFormRenderingContext ddmFormRenderingContext = this.createDDMFormRenderingContext(ddmForm);
        ddmFormRenderingContext.setGroupId(ddmFormInstance.getGroupId());
        DDMFormInstanceRecordVersion ddmFormInstanceRecordVersion = this._ddmFormInstanceRecordVersionLocalService.fetchLatestFormInstanceRecordVersion(this.getUserId(), this.getFormInstanceId(), this.getFormInstanceVersion(), 2);
        if (ddmFormInstanceRecordVersion != null) {
            DDMFormValues mergedDDMFormValues = this._ddmFormValuesMerger.merge(ddmFormInstanceRecordVersion.getDDMFormValues(), ddmFormRenderingContext.getDDMFormValues());
            ddmFormRenderingContext.setDDMFormValues(mergedDDMFormValues);
        }
        boolean showSubmitButton = this.isShowSubmitButton();
        ddmFormRenderingContext.setShowSubmitButton(showSubmitButton);
        String submitLabel = this.getSubmitLabel(ddmFormInstance, ddmFormRenderingContext.getLocale());
        ddmFormRenderingContext.setSubmitLabel(submitLabel);
        if (!this.hasAddFormInstanceRecordPermission()) {
            ddmFormRenderingContext.setReadOnly(true);
        }
        return this._ddmFormRenderer.render(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    public DDMFormSuccessPageSettings getDDMFormSuccessPageSettings() throws PortalException {
        DDMForm ddmForm = this.getDDMForm();
        return ddmForm.getDDMFormSuccessPageSettings();
    }

    public String getDefaultLanguageId() throws PortalException {
        DDMForm ddmForm = this.getDDMForm();
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"languageId", (String)LanguageUtil.getLanguageId((Locale)ddmForm.getDefaultLocale()));
    }

    public DDMFormInstance getFormInstance() {
        if (this._ddmFormInstance != null) {
            return this._ddmFormInstance;
        }
        try {
            this._ddmFormInstance = this._ddmFormInstanceService.fetchFormInstance(this.getFormInstanceId());
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
        return this._ddmFormInstance;
    }

    public long getFormInstanceId() {
        if (this._ddmFormInstanceId != 0L) {
            return this._ddmFormInstanceId;
        }
        this._ddmFormInstanceId = PrefsParamUtil.getLong((PortletPreferences)this._renderRequest.getPreferences(), (PortletRequest)this._renderRequest, (String)"formInstanceId");
        if (this._ddmFormInstanceId == 0L) {
            this._ddmFormInstanceId = this.getFormInstanceIdFromSession();
        }
        return this._ddmFormInstanceId;
    }

    public String getRedirectURL() throws PortalException {
        DDMFormInstance ddmFormInstance = this.getFormInstance();
        if (ddmFormInstance == null) {
            return null;
        }
        DDMFormInstanceSettings ddmFormInstanceSettings = ddmFormInstance.getSettingsModel();
        return ddmFormInstanceSettings.redirectURL();
    }

    public boolean hasAddFormInstanceRecordPermission() throws PortalException {
        if (this._hasAddFormInstanceRecordPermission != null) {
            return this._hasAddFormInstanceRecordPermission;
        }
        this._hasAddFormInstanceRecordPermission = true;
        DDMFormInstance ddmFormInstance = this.getFormInstance();
        if (ddmFormInstance != null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._hasAddFormInstanceRecordPermission = DDMFormInstancePermission.contains(themeDisplay.getPermissionChecker(), ddmFormInstance, "ADD_FORM_INSTANCE_RECORD");
        }
        return this._hasAddFormInstanceRecordPermission;
    }

    public boolean isAutosaveEnabled() throws PortalException {
        if (this._autosaveEnabled != null) {
            return this._autosaveEnabled;
        }
        if (this.isDefaultUser()) {
            this._autosaveEnabled = Boolean.FALSE;
        } else {
            DDMFormInstance formInstance = this.getFormInstance();
            DDMFormInstanceSettings formInstanceSettings = formInstance.getSettingsModel();
            this._autosaveEnabled = formInstanceSettings.autosaveEnabled();
        }
        return this._autosaveEnabled;
    }

    public boolean isFormAvailable() throws PortalException {
        Group group;
        if (this.isPreview()) {
            return true;
        }
        DDMFormInstance formInstance = this.getFormInstance();
        if (formInstance != null && (group = this._groupLocalService.getGroup(formInstance.getGroupId())) != null && group.isStagingGroup()) {
            return false;
        }
        if (this.isSharedURL()) {
            return this.isFormPublished() && this.isFormShared();
        }
        return formInstance != null;
    }

    public boolean isFormShared() {
        PortletSession portletSession = this._renderRequest.getPortletSession(false);
        if (portletSession != null) {
            return SessionParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"shared");
        }
        return ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"shared");
    }

    public boolean isPreview() throws PortalException {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        return ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"preview") && DDMFormInstancePermission.contains(themeDisplay.getPermissionChecker(), this.getFormInstanceId(), "UPDATE");
    }

    public boolean isShowConfigurationIcon() throws PortalException {
        if (this._showConfigurationIcon != null) {
            return this._showConfigurationIcon;
        }
        if (this.isPreview() || this.isSharedURL() && this.isFormShared()) {
            this._showConfigurationIcon = false;
            return this._showConfigurationIcon;
        }
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        this._showConfigurationIcon = PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)this.getPortletId(), (String)"CONFIGURATION");
        return this._showConfigurationIcon;
    }

    public boolean isShowSuccessPage() throws PortalException {
        if (SessionMessages.isEmpty((PortletRequest)this._renderRequest)) {
            return false;
        }
        DDMFormSuccessPageSettings ddmFormSuccessPageSettings = this.getDDMFormSuccessPageSettings();
        return ddmFormSuccessPageSettings.isEnabled();
    }

    protected String createCaptchaResourceURL() {
        ResourceURL resourceURL = this._renderResponse.createResourceURL();
        resourceURL.setResourceID("captcha");
        return resourceURL.toString();
    }

    protected DDMFormRenderingContext createDDMFormRenderingContext(DDMForm ddmForm) {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setContainerId(this._containerId);
        ddmFormRenderingContext.setDDMFormValues(this._ddmFormValuesFactory.create((PortletRequest)this._renderRequest, ddmForm));
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        ddmFormRenderingContext.setHttpServletRequest(request);
        ddmFormRenderingContext.setHttpServletResponse(PortalUtil.getHttpServletResponse((PortletResponse)this._renderResponse));
        ddmFormRenderingContext.setLocale(this.getLocale(request, ddmForm));
        ddmFormRenderingContext.setPortletNamespace(this._renderResponse.getNamespace());
        ddmFormRenderingContext.setSharedURL(this.isSharedURL());
        ddmFormRenderingContext.setViewMode(true);
        return ddmFormRenderingContext;
    }

    protected DDMFormLayoutRow createFullColumnDDMFormLayoutRow(String ddmFormFieldName) {
        DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
        DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(12, new String[]{ddmFormFieldName});
        ddmFormLayoutRow.addDDMFormLayoutColumn(ddmFormLayoutColumn);
        return ddmFormLayoutRow;
    }

    protected DDMForm getDDMForm() throws PortalException {
        DDMFormInstance ddmFormInstance = this.getFormInstance();
        DDMStructure ddmStructure = ddmFormInstance.getStructure();
        return ddmStructure.getDDMForm();
    }

    protected DDMForm getDDMForm(DDMFormInstance ddmFormInstance, boolean requireCaptcha) throws PortalException {
        DDMForm ddmForm = null;
        if (this.isPreview()) {
            DDMStructure ddmStructure = ddmFormInstance.getStructure();
            ddmForm = ddmStructure.getDDMForm();
        } else {
            DDMFormInstanceVersion latestFormInstanceVersion = this._ddmFormInstanceVersionLocalService.getLatestFormInstanceVersion(ddmFormInstance.getFormInstanceId(), 0);
            DDMStructureVersion structureVersion = latestFormInstanceVersion.getStructureVersion();
            ddmForm = structureVersion.getDDMForm();
        }
        if (requireCaptcha) {
            DDMFormField captchaDDMFormField = new DDMFormField(_DDM_FORM_FIELD_NAME_CAPTCHA, "captcha");
            captchaDDMFormField.setDataType("string");
            captchaDDMFormField.setProperty("url", (Object)this.createCaptchaResourceURL());
            ddmForm.addDDMFormField(captchaDDMFormField);
        }
        return ddmForm;
    }

    protected DDMFormLayout getDDMFormLayout(DDMFormInstance ddmFormInstance, boolean requireCaptcha) throws PortalException {
        DDMFormLayout ddmFormLayout = null;
        if (this.isPreview()) {
            DDMStructure ddmStructure = ddmFormInstance.getStructure();
            ddmFormLayout = ddmStructure.getDDMFormLayout();
        } else {
            DDMFormInstanceVersion latestFormInstanceVersion = this._ddmFormInstanceVersionLocalService.getLatestFormInstanceVersion(ddmFormInstance.getFormInstanceId(), 0);
            DDMStructureVersion structureVersion = latestFormInstanceVersion.getStructureVersion();
            ddmFormLayout = structureVersion.getDDMFormLayout();
        }
        if (requireCaptcha) {
            DDMFormLayoutPage lastDDMFormLayoutPage = this.getLastDDMFormLayoutPage(ddmFormLayout);
            DDMFormLayoutRow ddmFormLayoutRow = this.createFullColumnDDMFormLayoutRow(_DDM_FORM_FIELD_NAME_CAPTCHA);
            lastDDMFormLayoutPage.addDDMFormLayoutRow(ddmFormLayoutRow);
        }
        return ddmFormLayout;
    }

    protected long getFormInstanceIdFromSession() {
        PortletSession portletSession = this._renderRequest.getPortletSession();
        return GetterUtil.getLong((Object)portletSession.getAttribute("ddmFormInstanceId"));
    }

    protected String getFormInstanceVersion() {
        DDMFormInstance ddmFormInstance = this.getFormInstance();
        if (ddmFormInstance == null) {
            return "1.0";
        }
        return ddmFormInstance.getVersion();
    }

    protected DDMFormLayoutPage getLastDDMFormLayoutPage(DDMFormLayout ddmFormLayout) {
        List ddmFormLayoutPages = ddmFormLayout.getDDMFormLayoutPages();
        return (DDMFormLayoutPage)ddmFormLayoutPages.get(ddmFormLayoutPages.size() - 1);
    }

    protected Locale getLocale(HttpServletRequest request, DDMForm ddmForm) {
        String languageId;
        Locale locale;
        Set availableLocales = ddmForm.getAvailableLocales();
        if (availableLocales.contains(locale = LocaleUtil.fromLanguageId((String)(languageId = LanguageUtil.getLanguageId((HttpServletRequest)request))))) {
            return locale;
        }
        return ddmForm.getDefaultLocale();
    }

    protected String getPortletId() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getId();
    }

    protected String getPortletResource() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getPortletResource();
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundleLoader portalResourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        ResourceBundle portalResourceBundle = portalResourceBundleLoader.loadResourceBundle(locale);
        ResourceBundle moduleResourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return new AggregateResourceBundle(new ResourceBundle[]{moduleResourceBundle, portalResourceBundle});
    }

    protected String getSubmitLabel(DDMFormInstance ddmFormInstance, Locale locale) {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        boolean workflowEnabled = this.hasWorkflowEnabled(ddmFormInstance, themeDisplay);
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        if (workflowEnabled) {
            return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"submit-for-publication");
        }
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"submit-form");
    }

    protected ThemeDisplay getThemeDisplay() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return themeDisplay;
    }

    protected User getUser() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        return themeDisplay.getUser();
    }

    protected long getUserId() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        return themeDisplay.getUserId();
    }

    protected boolean hasViewPermission() throws PortalException {
        if (this._hasViewPermission != null) {
            return this._hasViewPermission;
        }
        this._hasViewPermission = true;
        DDMFormInstance ddmFormInstance = this.getFormInstance();
        if (ddmFormInstance != null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            this._hasViewPermission = DDMFormInstancePermission.contains(themeDisplay.getPermissionChecker(), ddmFormInstance, "VIEW");
        }
        return this._hasViewPermission;
    }

    protected boolean hasWorkflowEnabled(DDMFormInstance ddmFormInstance, ThemeDisplay themeDisplay) {
        return this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(themeDisplay.getCompanyId(), ddmFormInstance.getGroupId(), DDMFormInstance.class.getName(), ddmFormInstance.getFormInstanceId());
    }

    protected boolean isCaptchaRequired(DDMFormInstance ddmFormInstance) throws PortalException {
        DDMFormInstanceSettings ddmFormInstanceSettings = ddmFormInstance.getSettingsModel();
        return ddmFormInstanceSettings.requireCaptcha();
    }

    protected boolean isDefaultUser() {
        User user = this.getUser();
        return user.isDefaultUser();
    }

    protected boolean isFormPublished() throws PortalException {
        DDMFormInstance ddmFormInstance = this.getFormInstance();
        if (ddmFormInstance == null) {
            return false;
        }
        DDMFormInstanceSettings ddmFormInstanceSettings = ddmFormInstance.getSettingsModel();
        return ddmFormInstanceSettings.published();
    }

    protected boolean isSharedURL() {
        ThemeDisplay themeDisplay = this.getThemeDisplay();
        String urlCurrent = themeDisplay.getURLCurrent();
        return urlCurrent.contains("/shared");
    }

    protected boolean isShowSubmitButton() {
        boolean preview = ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"preview");
        return !preview;
    }
}

