/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.portlet.action.util;

import com.liferay.dynamic.data.mapping.form.builder.context.DDMFormContextVisitor;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationException;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluator;
import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorContext;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.web.FormInstanceFieldSettingsException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMFormInstanceFieldSettingsValidator.class})
public class DDMFormInstanceFieldSettingsValidator {
    @Reference
    private DDMFormEvaluator _ddmFormEvaluator;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public void validate(PortletRequest portletRequest, DDMForm ddmForm) throws PortalException {
        Map<String, Set<String>> fieldNamePropertiesMap = this.evaluate(portletRequest, ddmForm);
        if (!fieldNamePropertiesMap.isEmpty()) {
            throw new FormInstanceFieldSettingsException.MustSetValidValueForProperties(fieldNamePropertiesMap);
        }
    }

    protected DDMFormValues createDDMFormFieldFormValues(JSONObject jsonObject, DDMForm fieldSettingsDDMForm) {
        final DDMFormValues fieldSettingsDDMFormValues = new DDMFormValues(fieldSettingsDDMForm);
        final Locale defaultLocale = fieldSettingsDDMForm.getDefaultLocale();
        fieldSettingsDDMFormValues.setDefaultLocale(defaultLocale);
        final Set availableLocales = fieldSettingsDDMForm.getAvailableLocales();
        fieldSettingsDDMFormValues.setAvailableLocales(availableLocales);
        DDMFormContextVisitor ddmFormContextVisitor = new DDMFormContextVisitor(jsonObject.getJSONArray("pages"));
        ddmFormContextVisitor.onVisitField((Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject jsonObject) {
                DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
                ddmFormFieldValue.setDDMFormValues(fieldSettingsDDMFormValues);
                ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
                ddmFormFieldValue.setName(jsonObject.getString("fieldName"));
                ddmFormFieldValue.setValue(this.getValue(jsonObject));
                fieldSettingsDDMFormValues.addDDMFormFieldValue(ddmFormFieldValue);
            }

            protected LocalizedValue getLocalizedValue(String serializedValue, Set<Locale> availableLocales2, Locale defaultLocale2) {
                LocalizedValue localizedValue = new LocalizedValue(defaultLocale2);
                try {
                    JSONObject jsonObject = DDMFormInstanceFieldSettingsValidator.this._jsonFactory.createJSONObject(serializedValue);
                    String defaultValueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)defaultLocale2));
                    for (Locale availableLocale : availableLocales2) {
                        String valueString = jsonObject.getString(LocaleUtil.toLanguageId((Locale)availableLocale), defaultValueString);
                        localizedValue.addString(availableLocale, valueString);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return localizedValue;
            }

            protected Value getValue(JSONObject jsonObject) {
                boolean localizable = jsonObject.getBoolean("localizable", false);
                if (localizable) {
                    return this.getLocalizedValue(jsonObject.getString("localizedValue"), availableLocales, defaultLocale);
                }
                return new UnlocalizedValue(jsonObject.getString("value"));
            }
        });
        ddmFormContextVisitor.visit();
        return fieldSettingsDDMFormValues;
    }

    protected DDMFormEvaluationResult doEvaluate(PortletRequest portletRequest, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        DDMFormEvaluatorContext ddmFormEvaluatorContext = new DDMFormEvaluatorContext(ddmForm, ddmFormValues, locale);
        ddmFormEvaluatorContext.addProperty("groupId", (Object)ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId"));
        ddmFormEvaluatorContext.addProperty("request", (Object)this._portal.getHttpServletRequest(portletRequest));
        try {
            return this._ddmFormEvaluator.evaluate(ddmFormEvaluatorContext);
        }
        catch (DDMFormEvaluationException ddmfee) {
            ddmfee.printStackTrace();
            return new DDMFormEvaluationResult();
        }
    }

    protected Map<String, Set<String>> evaluate(final PortletRequest portletRequest, final DDMForm ddmForm) throws JSONException {
        final HashMap<String, Set<String>> fieldNamePropertiesMap = new HashMap<String, Set<String>>();
        final Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        String serializedFormBuilderContext = ParamUtil.getString((PortletRequest)portletRequest, (String)"serializedFormBuilderContext");
        JSONObject jsonObject = this._jsonFactory.createJSONObject(serializedFormBuilderContext);
        DDMFormContextVisitor ddmFormContextVisitor = new DDMFormContextVisitor(jsonObject.getJSONArray("pages"));
        ddmFormContextVisitor.onVisitField((Consumer)new Consumer<JSONObject>(){

            @Override
            public void accept(JSONObject jsonObject) {
                DDMFormValues fieldDDMFormValues;
                DDMFormEvaluationResult ddmFormEvaluationResult;
                DDMFormField field = (DDMFormField)ddmFormFieldsMap.get(jsonObject.getString("fieldName"));
                DDMFormFieldType ddmFormFieldType = DDMFormInstanceFieldSettingsValidator.this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(field.getType());
                DDMForm fieldDDMForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
                Set<String> invalidDDMFormFields = DDMFormInstanceFieldSettingsValidator.this.getInvalidDDMFormFields(fieldDDMForm, ddmFormEvaluationResult = DDMFormInstanceFieldSettingsValidator.this.doEvaluate(portletRequest, fieldDDMForm, fieldDDMFormValues = DDMFormInstanceFieldSettingsValidator.this.createDDMFormFieldFormValues(jsonObject.getJSONObject("settingsContext"), fieldDDMForm), ddmForm.getDefaultLocale()), fieldDDMForm.getDefaultLocale());
                if (!invalidDDMFormFields.isEmpty()) {
                    fieldNamePropertiesMap.put(DDMFormInstanceFieldSettingsValidator.this.getFieldLabel(field, ddmForm.getDefaultLocale()), invalidDDMFormFields);
                }
            }
        });
        ddmFormContextVisitor.visit();
        return fieldNamePropertiesMap;
    }

    protected String getFieldLabel(DDMFormField ddmFormField, Locale locale) {
        LocalizedValue label = ddmFormField.getLabel();
        return label.getString(locale);
    }

    protected Set<String> getInvalidDDMFormFields(DDMForm fieldDDMForm, DDMFormEvaluationResult ddmFormEvaluationResult, Locale locale) {
        List ddmFormFieldEvaluationResults = ddmFormEvaluationResult.getDDMFormFieldEvaluationResults();
        if (ListUtil.isEmpty((List)ddmFormFieldEvaluationResults)) {
            return Collections.emptySet();
        }
        HashSet<String> ddmFormFieldList = new HashSet<String>();
        Map ddmFormFieldsMap = fieldDDMForm.getDDMFormFieldsMap(true);
        Stream stream = ddmFormFieldEvaluationResults.parallelStream();
        stream.forEach(fieldEvaluationResult -> {
            if (!fieldEvaluationResult.isValid()) {
                DDMFormField propertyFormField = (DDMFormField)ddmFormFieldsMap.get(fieldEvaluationResult.getName());
                ddmFormFieldList.add(this.getFieldLabel(propertyFormField, locale));
            }
        });
        return ddmFormFieldList;
    }
}

