/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.web.internal.display.context;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.form.web.internal.search.FormInstanceRecordSearch;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecord;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceRecordVersion;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMFormInstanceRecordLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DDMFormViewFormInstanceRecordsDisplayContext {
    private static final int _MAX_COLUMNS = 5;
    private final List<DDMFormField> _ddmFormFields = new ArrayList<DDMFormField>();
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final DDMFormInstance _ddmFormInstance;
    private final DDMFormInstanceRecordLocalService _ddmFormInstanceRecordLocalService;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final StorageEngine _storageEngine;

    public DDMFormViewFormInstanceRecordsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, DDMFormInstance formInstance, DDMFormInstanceRecordLocalService formInstanceRecordLocalService, DDMFormFieldTypeServicesTracker formFieldTypeServicesTracker, StorageEngine storageEngine) throws PortalException {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ddmFormInstance = formInstance;
        this._ddmFormInstanceRecordLocalService = formInstanceRecordLocalService;
        this._ddmFormFieldTypeServicesTracker = formFieldTypeServicesTracker;
        this._storageEngine = storageEngine;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        portletDisplay.setShowBackIcon(true);
        portletDisplay.setURLBack(ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect"));
        this.setDDMFormFields();
    }

    public List<DropdownItem> getActionItemsDropdownItems() {
        final HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteRecords");
                    dropdownItem.setIcon("trash");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() throws PortletException {
        PortletURL clearResultsURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getColumnName(DDMFormField formField) {
        LocalizedValue label = formField.getLabel();
        return label.getString(this._renderRequest.getLocale());
    }

    public String getColumnValue(DDMFormField formField, List<DDMFormFieldValue> formFieldValues) {
        if (formField == null || formFieldValues == null) {
            return "";
        }
        final DDMFormFieldValueRenderer fieldValueRenderer = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldValueRenderer(formField.getType());
        List renderedFormFielValues = ListUtil.toList(formFieldValues, (Function)new Function<DDMFormFieldValue, String>(){

            public String apply(DDMFormFieldValue formFieldValue) {
                return fieldValueRenderer.render(formFieldValue, DDMFormViewFormInstanceRecordsDisplayContext.this._renderRequest.getLocale());
            }
        });
        return StringUtil.merge((Collection)renderedFormFielValues, (String)", ");
    }

    public List<DDMFormField> getDDMFormFields() {
        return this._ddmFormFields;
    }

    public DDMFormInstance getDDMFormInstance() {
        return this._ddmFormInstance;
    }

    public DDMFormValues getDDMFormValues(DDMFormInstanceRecord formInstanceRecord) throws PortalException {
        DDMFormInstanceRecordVersion formInstanceRecordVersion = formInstanceRecord.getFormInstanceRecordVersion();
        return this._storageEngine.getDDMFormValues(formInstanceRecordVersion.getStorageId());
    }

    public String getDisplayStyle() {
        return "list";
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        final HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMFormViewFormInstanceRecordsDisplayContext.this.getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMFormViewFormInstanceRecordsDisplayContext.this.getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)request, (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems() {
        final DDMFormInstance ddmFormInstance = this.getDDMFormInstance();
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(HtmlUtil.extractText((String)ddmFormInstance.getName(DDMFormViewFormInstanceRecordsDisplayContext.this._renderRequest.getLocale())));
                });
            }
        };
    }

    public String getOrderByCol() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol");
        if (Validator.isNull((String)orderByCol)) {
            orderByCol = portalPreferences.getValue("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", "view-entries-order-by-col", "modified-date");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", "view-entries-order-by-col", orderByCol);
        }
        return orderByCol;
    }

    public String getOrderByType() {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)this._renderRequest);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        if (Validator.isNull((String)orderByType)) {
            orderByType = portalPreferences.getValue("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", "view-entries-order-by-type", "asc");
        } else {
            portalPreferences.setValue("com_liferay_dynamic_data_mapping_form_web_portlet_DDMFormAdminPortlet", "view-entries-order-by-type", orderByType);
        }
        return orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        DDMFormInstance ddmFormInstance = this.getDDMFormInstance();
        PortletURL portletURL = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
        portletURL.setParameter("mvcPath", "/admin/view_form_instance_records.jsp");
        portletURL.setParameter("redirect", ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect"));
        portletURL.setParameter("formInstanceId", String.valueOf(ddmFormInstance.getFormInstanceId()));
        String delta = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(displayStyle = this.getDisplayStyle()))) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public SearchContainer<?> getSearch() {
        String displayStyle = this.getDisplayStyle();
        PortletURL portletURL = this.getPortletURL();
        portletURL.setParameter("displayStyle", displayStyle);
        FormInstanceRecordSearch formInstanceRecordSearch = new FormInstanceRecordSearch((PortletRequest)this._renderRequest, portletURL, this.getHeaderNames());
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator<DDMFormInstanceRecord> orderByComparator = FormInstanceRecordSearch.getDDMFormInstanceRecordOrderByComparator(orderByCol, orderByType);
        formInstanceRecordSearch.setOrderByCol(orderByCol);
        formInstanceRecordSearch.setOrderByComparator(orderByComparator);
        formInstanceRecordSearch.setOrderByType(orderByType);
        if (formInstanceRecordSearch.isSearch()) {
            formInstanceRecordSearch.setEmptyResultsMessage("no-entries-were-found");
        } else {
            formInstanceRecordSearch.setEmptyResultsMessage("there-are-no-entries");
        }
        this.setDDMFormInstanceRecordSearchResults(formInstanceRecordSearch);
        this.setDDMFormInstanceRecordSearchTotal(formInstanceRecordSearch);
        return formInstanceRecordSearch;
    }

    public String getSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        DDMFormInstance ddmFormInstance = this.getDDMFormInstance();
        portletURL.setParameter("mvcPath", "/admin/view_form_instance_records.jsp");
        portletURL.setParameter("redirect", ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect"));
        portletURL.setParameter("formInstanceId", String.valueOf(ddmFormInstance.getFormInstanceId()));
        return portletURL.toString();
    }

    public String getSearchContainerId() {
        return "ddmFormInstanceRecord";
    }

    public String getSortingURL() throws Exception {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        sortingURL.setParameter("orderByType", orderByType.equals("asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getStatus(DDMFormInstanceRecord formInstanceRecord) throws PortalException {
        DDMFormInstanceRecordVersion formInstanceRecordVersion = formInstanceRecord.getFormInstanceRecordVersion();
        return formInstanceRecordVersion.getStatus();
    }

    public int getTotalItems() {
        SearchContainer<?> searchContainer = this.getSearch();
        return searchContainer.getTotal();
    }

    public boolean isDisabledManagementBar() {
        if (this.hasResults()) {
            return false;
        }
        return !this.isSearch();
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        final HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(DDMFormViewFormInstanceRecordsDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)request, (String)"all"));
                });
            }
        };
    }

    protected List<String> getHeaderNames() {
        ArrayList<String> headerNames = new ArrayList<String>();
        List<DDMFormField> formFields = this.getDDMFormFields();
        int totalColumns = 5;
        if (formFields.size() < totalColumns) {
            totalColumns = formFields.size();
        }
        for (int i = 0; i < totalColumns; ++i) {
            DDMFormField formField = formFields.get(i);
            LocalizedValue label = formField.getLabel();
            headerNames.add(label.getString(this._renderRequest.getLocale()));
        }
        return headerNames;
    }

    protected String getKeywords() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
    }

    protected List<DDMFormField> getNontransientFormFields(DDMForm form) {
        ArrayList<DDMFormField> formFields = new ArrayList<DDMFormField>();
        for (DDMFormField formField : form.getDDMFormFields()) {
            if (formField.isTransient()) continue;
            formFields.add(formField);
        }
        return formFields;
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    String orderByCol = "modified-date";
                    dropdownItem.setActive(orderByCol.equals(DDMFormViewFormInstanceRecordsDisplayContext.this.getOrderByCol()));
                    dropdownItem.setHref(DDMFormViewFormInstanceRecordsDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
                    dropdownItem.setLabel(orderByCol);
                });
            }
        };
    }

    protected SearchContext getSearchContext(int status) {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest));
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("formInstanceId", (Serializable)Long.valueOf(this._ddmFormInstance.getFormInstanceId()));
        searchContext.setEnd(searchContext.getEnd());
        searchContext.setKeywords(this.getKeywords());
        searchContext.setStart(searchContext.getStart());
        return searchContext;
    }

    protected boolean hasResults() {
        return this.getTotalItems() > 0;
    }

    protected boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    protected void setDDMFormFields() throws PortalException {
        DDMStructure structure = this._ddmFormInstance.getStructure();
        List<DDMFormField> formFields = this.getNontransientFormFields(structure.getDDMForm());
        for (DDMFormField formField : formFields) {
            this._ddmFormFields.add(formField);
        }
    }

    protected void setDDMFormInstanceRecordSearchResults(FormInstanceRecordSearch formInstanceRecordSearch) {
        List results;
        int status = -1;
        if (Validator.isNull((String)this.getKeywords())) {
            results = this._ddmFormInstanceRecordLocalService.getFormInstanceRecords(this._ddmFormInstance.getFormInstanceId(), status, formInstanceRecordSearch.getStart(), formInstanceRecordSearch.getEnd(), formInstanceRecordSearch.getOrderByComparator());
        } else {
            SearchContext searchContext = this.getSearchContext(status);
            BaseModelSearchResult baseModelSearchResult = this._ddmFormInstanceRecordLocalService.searchFormInstanceRecords(searchContext);
            results = baseModelSearchResult.getBaseModels();
        }
        formInstanceRecordSearch.setResults(results);
    }

    protected void setDDMFormInstanceRecordSearchTotal(FormInstanceRecordSearch ddmFormInstanceRecordSearch) {
        int total;
        int status = -1;
        if (Validator.isNull((String)this.getKeywords())) {
            total = this._ddmFormInstanceRecordLocalService.getFormInstanceRecordsCount(this._ddmFormInstance.getFormInstanceId(), status);
        } else {
            SearchContext searchContext = this.getSearchContext(status);
            BaseModelSearchResult baseModelSearchResult = this._ddmFormInstanceRecordLocalService.searchFormInstanceRecords(searchContext);
            total = baseModelSearchResult.getLength();
        }
        ddmFormInstanceRecordSearch.setTotal(total);
    }
}

