Liferay.Loader.define("dynamic-data-mapping-form-report-web$recharts-scale@0.4.3/es6/getNiceTickValues", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * @fileOverview calculate tick values of scale
     * @author xile611, arcthur
     * @date 2015-09-17
     */
    import Decimal from 'decimal.js-light';
    import { compose, range, memoize, map, reverse } from './util/utils';
    import Arithmetic from './util/arithmetic';
    /**
     * Calculate a interval of a minimum value and a maximum value
     *
     * @param  {Number} min       The minimum value
     * @param  {Number} max       The maximum value
     * @return {Array} An interval
     */

    function getValidInterval(_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          min = _ref2[0],
          max = _ref2[1];

      var validMin = min,
          validMax = max; // exchange

      if (min > max) {
        validMin = max;
        validMax = min;
      }

      return [validMin, validMax];
    }
    /**
     * Calculate the step which is easy to understand between ticks, like 10, 20, 25
     *
     * @param  {Decimal} roughStep        The rough step calculated by deviding the
     * difference by the tickCount
     * @param  {Boolean} allowDecimals    Allow the ticks to be decimals or not
     * @param  {Integer} correctionFactor A correction factor
     * @return {Decimal} The step which is easy to understand between two ticks
     */

    function getFormatStep(roughStep, allowDecimals, correctionFactor) {
      if (roughStep.lte(0)) {
        return new Decimal(0);
      }

      var digitCount = Arithmetic.getDigitCount(roughStep.toNumber()); // The ratio between the rough step and the smallest number which has a bigger
      // order of magnitudes than the rough step

      var digitCountValue = new Decimal(10).pow(digitCount);
      var stepRatio = roughStep.div(digitCountValue); // When an integer and a float multiplied, the accuracy of result may be wrong

      var stepRatioScale = digitCount !== 1 ? 0.05 : 0.1;
      var amendStepRatio = new Decimal(Math.ceil(stepRatio.div(stepRatioScale).toNumber())).add(correctionFactor).mul(stepRatioScale);
      var formatStep = amendStepRatio.mul(digitCountValue);
      return allowDecimals ? formatStep : new Decimal(Math.ceil(formatStep));
    }
    /**
     * calculate the ticks when the minimum value equals to the maximum value
     *
     * @param  {Number}  value         The minimum valuue which is also the maximum value
     * @param  {Integer} tickCount     The count of ticks
     * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not
     * @return {Array}                 ticks
     */

    function getTickOfSingleValue(value, tickCount, allowDecimals) {
      var step = 1; // calculate the middle value of ticks

      var middle = new Decimal(value);

      if (!middle.isint() && allowDecimals) {
        var absVal = Math.abs(value);

        if (absVal < 1) {
          // The step should be a float number when the difference is smaller than 1
          step = new Decimal(10).pow(Arithmetic.getDigitCount(value) - 1);
          middle = new Decimal(Math.floor(middle.div(step).toNumber())).mul(step);
        } else if (absVal > 1) {
          // Return the maximum integer which is smaller than 'value' when 'value' is greater than 1
          middle = new Decimal(Math.floor(value));
        }
      } else if (value === 0) {
        middle = new Decimal(Math.floor((tickCount - 1) / 2));
      } else if (!allowDecimals) {
        middle = new Decimal(Math.floor(value));
      }

      var middleIndex = Math.floor((tickCount - 1) / 2);
      var fn = compose(map(function (n) {
        return middle.add(new Decimal(n - middleIndex).mul(step)).toNumber();
      }), range);
      return fn(0, tickCount);
    }
    /**
     * Calculate the step
     *
     * @param  {Number}  min              The minimum value of an interval
     * @param  {Number}  max              The maximum value of an interval
     * @param  {Integer} tickCount        The count of ticks
     * @param  {Boolean} allowDecimals    Allow the ticks to be decimals or not
     * @param  {Number}  correctionFactor A correction factor
     * @return {Object}  The step, minimum value of ticks, maximum value of ticks
     */

    function calculateStep(min, max, tickCount, allowDecimals) {
      var correctionFactor = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;

      // dirty hack (for recharts' test)
      if (!Number.isFinite((max - min) / (tickCount - 1))) {
        return {
          step: new Decimal(0),
          tickMin: new Decimal(0),
          tickMax: new Decimal(0)
        };
      } // The step which is easy to understand between two ticks


      var step = getFormatStep(new Decimal(max).sub(min).div(tickCount - 1), allowDecimals, correctionFactor); // A medial value of ticks

      var middle; // When 0 is inside the interval, 0 should be a tick

      if (min <= 0 && max >= 0) {
        middle = new Decimal(0);
      } else {
        // calculate the middle value
        middle = new Decimal(min).add(max).div(2); // minus modulo value

        middle = middle.sub(new Decimal(middle).mod(step));
      }

      var belowCount = Math.ceil(middle.sub(min).div(step).toNumber());
      var upCount = Math.ceil(new Decimal(max).sub(middle).div(step).toNumber());
      var scaleCount = belowCount + upCount + 1;

      if (scaleCount > tickCount) {
        // When more ticks need to cover the interval, step should be bigger.
        return calculateStep(min, max, tickCount, allowDecimals, correctionFactor + 1);
      }

      if (scaleCount < tickCount) {
        // When less ticks can cover the interval, we should add some additional ticks
        upCount = max > 0 ? upCount + (tickCount - scaleCount) : upCount;
        belowCount = max > 0 ? belowCount : belowCount + (tickCount - scaleCount);
      }

      return {
        step: step,
        tickMin: middle.sub(new Decimal(belowCount).mul(step)),
        tickMax: middle.add(new Decimal(upCount).mul(step))
      };
    }
    /**
     * Calculate the ticks of an interval, the count of ticks will be guraranteed
     *
     * @param  {Number}  min, max      min: The minimum value, max: The maximum value
     * @param  {Integer} tickCount     The count of ticks
     * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not
     * @return {Array}   ticks
     */

    function getNiceTickValuesFn(_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
          min = _ref4[0],
          max = _ref4[1];

      var tickCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 6;
      var allowDecimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      // More than two ticks should be return
      var count = Math.max(tickCount, 2);

      var _getValidInterval = getValidInterval([min, max]),
          _getValidInterval2 = _slicedToArray(_getValidInterval, 2),
          cormin = _getValidInterval2[0],
          cormax = _getValidInterval2[1];

      if (cormin === -Infinity || cormax === Infinity) {
        var _values = cormax === Infinity ? [cormin].concat(_toConsumableArray(range(0, tickCount - 1).map(function () {
          return Infinity;
        }))) : _toConsumableArray(range(0, tickCount - 1).map(function () {
          return -Infinity;
        })).concat([cormax]);

        return min > max ? reverse(_values) : _values;
      }

      if (cormin === cormax) {
        return getTickOfSingleValue(cormin, tickCount, allowDecimals);
      } // Get the step between two ticks


      var _calculateStep = calculateStep(cormin, cormax, count, allowDecimals),
          step = _calculateStep.step,
          tickMin = _calculateStep.tickMin,
          tickMax = _calculateStep.tickMax;

      var values = Arithmetic.rangeStep(tickMin, tickMax.add(new Decimal(0.1).mul(step)), step);
      return min > max ? reverse(values) : values;
    }
    /**
     * Calculate the ticks of an interval, the count of ticks won't be guraranteed
     *
     * @param  {Number}  min, max      min: The minimum value, max: The maximum value
     * @param  {Integer} tickCount     The count of ticks
     * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not
     * @return {Array}   ticks
     */

    function getTickValuesFn(_ref5) {
      var _ref6 = _slicedToArray(_ref5, 2),
          min = _ref6[0],
          max = _ref6[1];

      var tickCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 6;
      var allowDecimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
      // More than two ticks should be return
      var count = Math.max(tickCount, 2);

      var _getValidInterval3 = getValidInterval([min, max]),
          _getValidInterval4 = _slicedToArray(_getValidInterval3, 2),
          cormin = _getValidInterval4[0],
          cormax = _getValidInterval4[1];

      if (cormin === -Infinity || cormax === Infinity) {
        return [min, max];
      }

      if (cormin === cormax) {
        return getTickOfSingleValue(cormin, tickCount, allowDecimals);
      }

      var step = getFormatStep(new Decimal(cormax).sub(cormin).div(count - 1), allowDecimals, 0);
      var fn = compose(map(function (n) {
        return new Decimal(cormin).add(new Decimal(n).mul(step)).toNumber();
      }), range);
      var values = fn(0, count).filter(function (entry) {
        return entry >= cormin && entry <= cormax;
      });
      return min > max ? reverse(values) : values;
    }
    /**
     * Calculate the ticks of an interval, the count of ticks won't be guraranteed,
     * but the domain will be guaranteed
     *
     * @param  {Number}  min, max      min: The minimum value, max: The maximum value
     * @param  {Integer} tickCount     The count of ticks
     * @param  {Boolean} allowDecimals Allow the ticks to be decimals or not
     * @return {Array}   ticks
     */

    function getTickValuesFixedDomainFn(_ref7, tickCount) {
      var _ref8 = _slicedToArray(_ref7, 2),
          min = _ref8[0],
          max = _ref8[1];

      var allowDecimals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

      // More than two ticks should be return
      var _getValidInterval5 = getValidInterval([min, max]),
          _getValidInterval6 = _slicedToArray(_getValidInterval5, 2),
          cormin = _getValidInterval6[0],
          cormax = _getValidInterval6[1];

      if (cormin === -Infinity || cormax === Infinity) {
        return [min, max];
      }

      if (cormin === cormax) {
        return [cormin];
      }

      var count = Math.max(tickCount, 2);
      var step = getFormatStep(new Decimal(cormax).sub(cormin).div(count - 1), allowDecimals, 0);

      var values = _toConsumableArray(Arithmetic.rangeStep(new Decimal(cormin), new Decimal(cormax).sub(new Decimal(0.99).mul(step)), step)).concat([cormax]);

      return min > max ? reverse(values) : values;
    }

    export var getNiceTickValues = memoize(getNiceTickValuesFn);
    export var getTickValues = memoize(getTickValuesFn);
    export var getTickValuesFixedDomain = memoize(getTickValuesFixedDomainFn);
  }
});
//# sourceMappingURL=getNiceTickValues.js.map