Liferay.Loader.define('dynamic-data-mapping-form-report-web$lodash-es@4.17.15/pick', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import basePick from './_basePick.js';
    import flatRest from './_flatRest.js';

    /**
     * Creates an object composed of the picked `object` properties.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The source object.
     * @param {...(string|string[])} [paths] The property paths to pick.
     * @returns {Object} Returns the new object.
     * @example
     *
     * var object = { 'a': 1, 'b': '2', 'c': 3 };
     *
     * _.pick(object, ['a', 'c']);
     * // => { 'a': 1, 'c': 3 }
     */
    var pick = flatRest(function (object, paths) {
      return object == null ? {} : basePick(object, paths);
    });

    export default pick;
  }
});
//# sourceMappingURL=pick.js.map